/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.actions.menuextension;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jst.pagedesigner.extensionpoint.IContextMenuItemContributor;
import org.eclipse.jst.pagedesigner.utils.JSPUtil;
import org.eclipse.jst.pagedesigner.utils.StructuredModelUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class CustomedContextMenuActionGroup
extends ActionGroup {
    private static final String POPUPMENU_EXTENSION_ID = "org.eclipse.jst.pagedesigner.popupMenuContributor";
    private List _contributedMenuListener;
    private Control _parentControl;
    private IStructuredModel _model;

    public void fillContextMenu(IMenuManager menu) {
        this.populateContributedMenu(menu);
    }

    private List getListeners() {
        if (this._contributedMenuListener == null) {
            this._contributedMenuListener = this.computeContributedMenuListener();
        }
        return this._contributedMenuListener;
    }

    private List computeContributedMenuListener() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(POPUPMENU_EXTENSION_ID);
        IExtension[] extensions = extensionPoint.getExtensions();
        ArrayList<Object> results = new ArrayList<Object>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                try {
                    Object listener = elements[j].createExecutableExtension("class");
                    if (listener instanceof IContextMenuItemContributor) {
                        results.add(listener);
                        ((IContextMenuItemContributor)listener).setURI(elements[j].getAttribute("URI"));
                    }
                }
                catch (CoreException coreException) {}
                ++j;
            }
            ++i;
        }
        return results;
    }

    private void populateContributedMenu(IMenuManager menuMgr) {
        List list = this.getListeners();
        int i = 0;
        int n = list.size();
        while (i < n) {
            IContextMenuItemContributor contributor = (IContextMenuItemContributor)list.get(i);
            IFile file = StructuredModelUtil.getFileFor(this._model);
            if (file != null && contributor.getURI() != null && JSPUtil.supportTaglib(contributor.getURI(), file)) {
                contributor.fillContextMenu(menuMgr, this.getContext().getSelection(), this._model, this._parentControl);
            }
            ++i;
        }
    }

    public IStructuredModel getModel() {
        return this._model;
    }

    public void setModel(IStructuredModel model) {
        this._model = model;
    }

    public Control getParentControl() {
        return this._parentControl;
    }

    public void setParentControl(Control parentControl) {
        this._parentControl = parentControl;
    }
}

