/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.listener;

import org.easymock.EasyMock;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IEclipseFacade;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPASolver;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.jpt.jpadiagrameditor.ui.tests.internal.JPACreateFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JPAProjectListenerTest {
    private IJPAEditorFeatureProvider featureProvider;
    final String TEST_PROJECT = "Test";
    private JpaProject jpaProject = null;
    private JPACreateFactory factory = null;
    IEclipseFacade eclipseFacade = null;

    @Before
    public void setUp() throws Exception {
        this.factory = JPACreateFactory.instance();
        this.jpaProject = this.factory.createJPAProject("Test_" + System.currentTimeMillis());
        Assert.assertNotNull((Object)this.jpaProject);
        IFile entity = this.factory.createEntity(this.jpaProject, "org.eclipse.Entity1");
        Thread.sleep(2000L);
        this.featureProvider = (IJPAEditorFeatureProvider)EasyMock.createMock(IJPAEditorFeatureProvider.class);
        EasyMock.expect((Object)this.featureProvider.getBusinessObjectForPictogramElement(null)).andReturn((Object)JPACreateFactory.getPersistentType(entity));
        EasyMock.expect((Object)this.featureProvider.getCompilationUnit((PersistentType)EasyMock.isA(PersistentType.class))).andReturn((Object)JavaCore.createCompilationUnitFrom((IFile)entity)).anyTimes();
    }

    public ICompilationUnit createCompilationUnitFrom(IFile file) {
        return JavaCore.createCompilationUnitFrom((IFile)file);
    }

    @Test
    public void testJPAProjectListener() {
        JPASolver slv = new JPASolver();
        slv.setFeatureProvider(this.featureProvider);
        this.jpaProject.addCollectionChangeListener("mark", (CollectionChangeListener)new JPASolver.JPAProjectListener(slv));
        PersistenceUnit pu = JpaArtifactFactory.instance().getPersistenceUnit(this.jpaProject);
        PersistentType jpt = JpaArtifactFactory.instance().getJPT("org.eclipse.Entity1", pu);
        ContainerShape cs = (ContainerShape)EasyMock.createMock(ContainerShape.class);
        EasyMock.expect((Object)this.featureProvider.getPictogramElementForBusinessObject((Object)jpt)).andStubReturn((Object)cs);
        IRemoveFeature ft = (IRemoveFeature)EasyMock.createMock(IRemoveFeature.class);
        EasyMock.expect((Object)this.featureProvider.getRemoveFeature((IRemoveContext)EasyMock.isA(IRemoveContext.class))).andReturn((Object)ft);
        ft.remove((IRemoveContext)EasyMock.isA(IRemoveContext.class));
        EasyMock.replay((Object[])new Object[]{ft, cs, this.featureProvider});
        JpaArtifactFactory.instance().deleteEntityClass(jpt, this.featureProvider);
    }

    @Test
    public void testJPAProjectListenerNoRemove() {
        JPASolver slv = new JPASolver();
        slv.setFeatureProvider(this.featureProvider);
        this.jpaProject.addCollectionChangeListener("mark", (CollectionChangeListener)new JPASolver.JPAProjectListener(slv));
        PersistenceUnit pu = JpaArtifactFactory.instance().getPersistenceUnit(this.jpaProject);
        PersistentType jpt = JpaArtifactFactory.instance().getJPT("org.eclipse.Entity1", pu);
        EasyMock.expect((Object)this.featureProvider.getPictogramElementForBusinessObject((Object)jpt)).andStubReturn(null);
        IRemoveFeature ft = (IRemoveFeature)EasyMock.createMock(IRemoveFeature.class);
        EasyMock.expect((Object)this.featureProvider.getRemoveFeature((IRemoveContext)EasyMock.isA(IRemoveContext.class))).andReturn((Object)ft);
        EasyMock.replay((Object[])new Object[]{ft, this.featureProvider});
        JpaArtifactFactory.instance().deleteEntityClass(jpt, this.featureProvider);
    }

    @After
    public void tearDown() throws Exception {
        this.deleteAllProjects();
    }

    private void deleteAllProjects() throws Exception {
        NullProgressMonitor monitor = new NullProgressMonitor();
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    IProject project = JPAProjectListenerTest.this.jpaProject.getProject();
                    project.close(monitor);
                    project.close(monitor);
                    project.delete(true, true, monitor);
                }
                catch (Exception exception) {}
            }
        }, (IProgressMonitor)monitor);
    }
}

