/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.collection.Bag;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.tests.internal.MultiThreadedTestCase;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public abstract class BagTests
extends MultiThreadedTestCase {
    private Bag<String> bag;

    protected BagTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.bag = this.buildBag();
    }

    protected Bag<String> buildBag() {
        Bag<String> b = this.buildBag_();
        b.add(null);
        b.add((Object)new String("one"));
        b.add((Object)new String("two"));
        b.add((Object)new String("two"));
        b.add((Object)new String("three"));
        b.add((Object)new String("three"));
        b.add((Object)new String("three"));
        b.add((Object)new String("four"));
        b.add((Object)new String("four"));
        b.add((Object)new String("four"));
        b.add((Object)new String("four"));
        return b;
    }

    protected abstract Bag<String> buildBag_();

    protected abstract Bag<String> buildBag(Collection<String> var1);

    protected abstract Bag<String> buildBag(int var1, float var2);

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private Collection<String> buildCollection() {
        ArrayList<String> c = new ArrayList<String>();
        c.add(new String("foo"));
        c.add(new String("foo"));
        c.add(new String("bar"));
        c.add(new String("bar"));
        c.add(new String("bar"));
        return c;
    }

    public void testCtorCollection() {
        Collection<String> c = this.buildCollection();
        Bag<String> b = this.buildBag(c);
        for (String s : c) {
            BagTests.assertTrue((boolean)b.contains((Object)s));
        }
    }

    public void testCtorIntFloat() {
        boolean exCaught = false;
        try {
            this.bag = this.buildBag(-20, 0.66f);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            this.bag = this.buildBag(20, -0.66f);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
    }

    public void testAdd() {
        BagTests.assertTrue((boolean)this.bag.add((Object)"five"));
        BagTests.assertTrue((boolean)this.bag.contains((Object)"one"));
        BagTests.assertTrue((boolean)this.bag.contains((Object)"two"));
        BagTests.assertTrue((boolean)this.bag.contains((Object)"three"));
        BagTests.assertTrue((boolean)this.bag.contains((Object)"four"));
        BagTests.assertTrue((boolean)this.bag.contains((Object)"five"));
    }

    public void testAddCount() {
        this.bag.add((Object)"minus3", -3);
        this.bag.add((Object)"zero", 0);
        this.bag.add((Object)"five", 5);
        BagTests.assertFalse((boolean)this.bag.contains((Object)"minus3"));
        BagTests.assertFalse((boolean)this.bag.contains((Object)"zero"));
        BagTests.assertEquals((int)1, (int)this.bag.count((Object)"one"));
        BagTests.assertEquals((int)2, (int)this.bag.count((Object)"two"));
        BagTests.assertEquals((int)3, (int)this.bag.count((Object)"three"));
        BagTests.assertEquals((int)4, (int)this.bag.count((Object)"four"));
        BagTests.assertEquals((int)5, (int)this.bag.count((Object)"five"));
        this.bag.add((Object)"three", 2);
        BagTests.assertEquals((int)5, (int)this.bag.count((Object)"three"));
    }

    public void testAddAll() {
        Collection<String> c = this.buildCollection();
        BagTests.assertTrue((boolean)this.bag.addAll(c));
        for (String s : c) {
            BagTests.assertTrue((boolean)this.bag.contains((Object)s));
        }
    }

    public void testClear() {
        BagTests.assertTrue((boolean)this.bag.contains((Object)"one"));
        BagTests.assertTrue((boolean)this.bag.contains((Object)"two"));
        BagTests.assertTrue((boolean)this.bag.contains((Object)"three"));
        BagTests.assertTrue((boolean)this.bag.contains((Object)"four"));
        BagTests.assertTrue((boolean)this.bag.contains(null));
        BagTests.assertEquals((int)11, (int)this.bag.size());
        this.bag.clear();
        BagTests.assertFalse((boolean)this.bag.contains((Object)"one"));
        BagTests.assertFalse((boolean)this.bag.contains((Object)"two"));
        BagTests.assertFalse((boolean)this.bag.contains((Object)"three"));
        BagTests.assertFalse((boolean)this.bag.contains((Object)"four"));
        BagTests.assertFalse((boolean)this.bag.contains(null));
        BagTests.assertEquals((int)0, (int)this.bag.size());
    }

    public void testClone() {
        Bag bag2 = (Bag)ObjectTools.execute(this.bag, (String)"clone");
        BagTests.assertTrue((this.bag != bag2 ? 1 : 0) != 0);
        BagTests.assertEquals(this.bag, (Object)bag2);
        BagTests.assertTrue((this.bag.hashCode() == bag2.hashCode() ? 1 : 0) != 0);
    }

    public void testContains() {
        BagTests.assertTrue((boolean)this.bag.contains(null));
        BagTests.assertTrue((boolean)this.bag.contains((Object)"one"));
        BagTests.assertTrue((boolean)this.bag.contains((Object)"two"));
        BagTests.assertTrue((boolean)this.bag.contains((Object)"three"));
        BagTests.assertTrue((boolean)this.bag.contains((Object)"four"));
        BagTests.assertTrue((boolean)this.bag.contains((Object)new String("four")));
        BagTests.assertTrue((boolean)this.bag.contains((Object)"four"));
        BagTests.assertFalse((boolean)this.bag.contains((Object)"five"));
    }

    public void testContainsAll() {
        ArrayList<String> c = new ArrayList<String>();
        c.add(null);
        c.add(new String("one"));
        c.add(new String("two"));
        c.add(new String("three"));
        c.add(new String("four"));
        BagTests.assertTrue((boolean)this.bag.containsAll(c));
    }

    public void testCount() {
        BagTests.assertEquals((int)0, (int)this.bag.count((Object)"zero"));
        BagTests.assertEquals((int)1, (int)this.bag.count((Object)"one"));
        BagTests.assertEquals((int)2, (int)this.bag.count((Object)"two"));
        BagTests.assertEquals((int)3, (int)this.bag.count((Object)"three"));
        BagTests.assertEquals((int)4, (int)this.bag.count((Object)"four"));
        BagTests.assertEquals((int)0, (int)this.bag.count((Object)"five"));
    }

    public void testEqualsObject() {
        Bag<String> bag2 = this.buildBag();
        BagTests.assertEquals(this.bag, this.bag);
        BagTests.assertEquals(this.bag, bag2);
        bag2.add((Object)"four");
        BagTests.assertFalse((boolean)this.bag.equals(bag2));
        bag2.remove((Object)"four");
        bag2.add((Object)"five");
        bag2.remove((Object)"four");
        BagTests.assertFalse((boolean)this.bag.equals(bag2));
        bag2.remove((Object)"five");
        bag2.add((Object)"four");
        bag2.remove((Object)"two");
        bag2.add((Object)"four");
        BagTests.assertFalse((boolean)this.bag.equals(bag2));
        ArrayList<String> c = new ArrayList<String>((Collection<String>)this.bag);
        BagTests.assertFalse((boolean)this.bag.equals(c));
    }

    public void testHashCode() {
        Bag<String> bag2 = this.buildBag();
        BagTests.assertEquals((int)this.bag.hashCode(), (int)bag2.hashCode());
    }

    public void testIsEmpty() {
        BagTests.assertFalse((boolean)this.bag.isEmpty());
        this.bag.clear();
        BagTests.assertTrue((boolean)this.bag.isEmpty());
        this.bag.add((Object)"foo");
        BagTests.assertFalse((boolean)this.bag.isEmpty());
    }

    public void testEmptyIterator() {
        this.bag.clear();
        Iterator iterator = this.bag.iterator();
        BagTests.assertFalse((boolean)iterator.hasNext());
        boolean exCaught = false;
        Object element = null;
        try {
            element = iterator.next();
            BagTests.fail((String)element.toString());
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
    }

    public void testIterator() {
        int i = 0;
        Iterator iterator = this.bag.iterator();
        BagTests.assertTrue((boolean)iterator.hasNext());
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        BagTests.assertEquals((int)11, (int)i);
        BagTests.assertFalse((boolean)iterator.hasNext());
        boolean exCaught = false;
        Object element = null;
        try {
            element = iterator.next();
            BagTests.fail((String)element.toString());
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
        iterator.remove();
        BagTests.assertEquals((int)10, (int)this.bag.size());
        exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
        iterator = this.bag.iterator();
        this.bag.add((Object)"five");
        exCaught = false;
        try {
            iterator.next();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
    }

    public void testIterator_remove_all() {
        BagTests.assertEquals((int)4, (int)this.bag.count((Object)"four"));
        Iterator iterator = this.bag.iterator();
        String next = null;
        while (iterator.hasNext()) {
            next = (String)iterator.next();
            if (next == null || !next.equals("four")) continue;
            iterator.remove();
        }
        BagTests.assertEquals((int)0, (int)this.bag.count((Object)"four"));
    }

    public void testIterator_remove_CME() {
        Iterator iterator = this.bag.iterator();
        BagTests.assertTrue((boolean)iterator.hasNext());
        boolean exCaught = false;
        try {
            String next = null;
            while (iterator.hasNext()) {
                next = (String)iterator.next();
                if (!next.equals("four")) continue;
                this.bag.remove((Object)"two");
                iterator.remove();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
    }

    public void testEmptyUniqueIterator() {
        this.bag.clear();
        Iterator iterator = this.bag.uniqueIterator();
        BagTests.assertFalse((boolean)iterator.hasNext());
        boolean exCaught = false;
        Object element = null;
        try {
            element = iterator.next();
            BagTests.fail((String)element.toString());
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
    }

    public void testUniqueIterator() {
        int i = 0;
        Iterator iterator = this.bag.uniqueIterator();
        BagTests.assertTrue((boolean)iterator.hasNext());
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        BagTests.assertEquals((int)5, (int)i);
        BagTests.assertFalse((boolean)iterator.hasNext());
        boolean exCaught = false;
        Object element = null;
        try {
            element = iterator.next();
            BagTests.fail((String)element.toString());
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
        iterator = this.bag.uniqueIterator();
        Object next = null;
        while (iterator.hasNext() && !"four".equals(next)) {
            next = iterator.next();
        }
        iterator.remove();
        BagTests.assertEquals((int)7, (int)this.bag.size());
        exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
        iterator = this.bag.uniqueIterator();
        this.bag.add((Object)"five");
        exCaught = false;
        try {
            iterator.next();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
    }

    public void testEmptyEntries() {
        this.bag.clear();
        Iterator iterator = this.bag.entries();
        BagTests.assertFalse((boolean)iterator.hasNext());
        boolean exCaught = false;
        Object element = null;
        try {
            element = iterator.next();
            BagTests.fail((String)element.toString());
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
        exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
    }

    public void testEntries() {
        int i = 0;
        Iterator iterator = this.bag.entries();
        BagTests.assertTrue((boolean)iterator.hasNext());
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        BagTests.assertEquals((int)5, (int)i);
        BagTests.assertFalse((boolean)iterator.hasNext());
        boolean exCaught = false;
        Object element = null;
        try {
            element = iterator.next();
            BagTests.fail((String)element.toString());
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
        iterator = this.bag.entries();
        Bag.Entry next = null;
        while (iterator.hasNext()) {
            next = (Bag.Entry)iterator.next();
            if (!((String)next.getElement()).equals("four")) continue;
            iterator.remove();
            break;
        }
        BagTests.assertEquals((int)7, (int)this.bag.size());
        exCaught = false;
        try {
            iterator.remove();
        }
        catch (IllegalStateException illegalStateException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
        iterator = this.bag.entries();
        this.bag.add((Object)"five");
        exCaught = false;
        try {
            iterator.next();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
    }

    public void testEntries_remove_CME() {
        Iterator iterator = this.bag.entries();
        BagTests.assertTrue((boolean)iterator.hasNext());
        boolean exCaught = false;
        try {
            Bag.Entry next = null;
            while (iterator.hasNext()) {
                next = (Bag.Entry)iterator.next();
                if (!((String)next.getElement()).equals("four")) continue;
                this.bag.remove((Object)"two");
                iterator.remove();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
    }

    public void testEntry_setCount_increase() {
        Iterator iterator = this.bag.entries();
        BagTests.assertEquals((int)4, (int)this.bag.count((Object)"four"));
        Bag.Entry next = null;
        while (iterator.hasNext()) {
            next = (Bag.Entry)iterator.next();
            if (!((String)next.getElement()).equals("four")) continue;
            BagTests.assertEquals((int)4, (int)next.setCount(42));
            break;
        }
        BagTests.assertEquals((int)42, (int)this.bag.count((Object)"four"));
        BagTests.assertEquals((int)49, (int)this.bag.size());
    }

    public void testEntry_setCount_same() {
        Iterator iterator = this.bag.entries();
        BagTests.assertEquals((int)4, (int)this.bag.count((Object)"four"));
        Bag.Entry next = null;
        while (iterator.hasNext()) {
            next = (Bag.Entry)iterator.next();
            if (!((String)next.getElement()).equals("four")) continue;
            BagTests.assertEquals((int)4, (int)next.setCount(4));
            break;
        }
        BagTests.assertEquals((int)4, (int)this.bag.count((Object)"four"));
        BagTests.assertEquals((int)11, (int)this.bag.size());
    }

    public void testEntry_setCount_derease() {
        Iterator iterator = this.bag.entries();
        BagTests.assertEquals((int)4, (int)this.bag.count((Object)"four"));
        Bag.Entry next = null;
        while (iterator.hasNext()) {
            next = (Bag.Entry)iterator.next();
            if (!((String)next.getElement()).equals("four")) continue;
            BagTests.assertEquals((int)4, (int)next.setCount(2));
            break;
        }
        BagTests.assertEquals((int)2, (int)this.bag.count((Object)"four"));
        BagTests.assertEquals((int)9, (int)this.bag.size());
    }

    public void testEntry_setCount_IAE1() {
        Iterator iterator = this.bag.entries();
        boolean exCaught = false;
        try {
            Bag.Entry next = null;
            while (iterator.hasNext()) {
                next = (Bag.Entry)iterator.next();
                if (!((String)next.getElement()).equals("four")) continue;
                next.setCount(0);
                BagTests.fail((String)next.toString());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
    }

    public void testEntry_setCount_IAE2() {
        Iterator iterator = this.bag.entries();
        boolean exCaught = false;
        try {
            Bag.Entry next = null;
            while (iterator.hasNext()) {
                next = (Bag.Entry)iterator.next();
                if (!((String)next.getElement()).equals("four")) continue;
                next.setCount(-33);
                BagTests.fail((String)next.toString());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        BagTests.assertTrue((boolean)exCaught);
    }

    public void testEntry_equalsObject() {
        Iterator iterator1 = this.bag.entries();
        Bag<String> bag2 = this.buildBag();
        Bag.Entry next1 = null;
        while (iterator1.hasNext()) {
            next1 = (Bag.Entry)iterator1.next();
            if (((String)next1.getElement()).equals("four")) break;
        }
        BagTests.assertFalse((boolean)next1.equals((Object)"four"));
        Iterator iterator2 = bag2.entries();
        Bag.Entry next2 = null;
        while (iterator2.hasNext()) {
            next2 = (Bag.Entry)iterator2.next();
            if (((String)next2.getElement()).equals("four")) break;
        }
        BagTests.assertEquals((Object)next1, next2);
        bag2.remove((Object)"four");
        iterator1 = this.bag.entries();
        while (iterator1.hasNext()) {
            next1 = (Bag.Entry)iterator1.next();
            if (((String)next1.getElement()).equals("four")) break;
        }
        iterator2 = bag2.entries();
        while (iterator2.hasNext()) {
            next2 = (Bag.Entry)iterator2.next();
            if (((String)next2.getElement()).equals("four")) break;
        }
        BagTests.assertEquals((String)((String)next1.getElement()), (String)((String)next2.getElement()));
        BagTests.assertFalse((boolean)next1.equals((Object)next2));
        iterator1 = this.bag.entries();
        while (iterator1.hasNext()) {
            next1 = (Bag.Entry)iterator1.next();
            if (((String)next1.getElement()).equals("three")) break;
        }
        BagTests.assertEquals((int)next1.getCount(), (int)next2.getCount());
        BagTests.assertFalse((boolean)next1.equals((Object)next2));
    }

    public void testEntry_hashCode() {
        Iterator iterator = this.bag.entries();
        Bag.Entry next = null;
        while (iterator.hasNext()) {
            next = (Bag.Entry)iterator.next();
            if (((String)next.getElement()).equals("four")) break;
        }
        BagTests.assertEquals((int)(4 * "four".hashCode()), (int)next.hashCode());
        while (iterator.hasNext()) {
            next = (Bag.Entry)iterator.next();
            if (next.getElement() == null) break;
        }
        BagTests.assertEquals((int)0, (int)next.hashCode());
    }

    public void testEntry_toString() {
        Iterator iterator = this.bag.entries();
        Object next = null;
        while (iterator.hasNext()) {
            next = (Bag.Entry)iterator.next();
            if (((String)next.getElement()).equals("four")) break;
        }
        BagTests.assertEquals((String)"four=>4", (String)next.toString());
    }

    public void testRemove() {
        BagTests.assertTrue((boolean)this.bag.remove((Object)"one"));
        BagTests.assertFalse((boolean)this.bag.contains((Object)"one"));
        BagTests.assertFalse((boolean)this.bag.remove((Object)"one"));
        BagTests.assertTrue((boolean)this.bag.remove((Object)"two"));
        BagTests.assertTrue((boolean)this.bag.remove((Object)"two"));
        BagTests.assertFalse((boolean)this.bag.contains((Object)"two"));
        BagTests.assertFalse((boolean)this.bag.remove((Object)"two"));
    }

    public void testRemoveCount() {
        BagTests.assertFalse((boolean)this.bag.remove((Object)"one", 0));
        BagTests.assertTrue((boolean)this.bag.contains((Object)"one"));
        BagTests.assertTrue((boolean)this.bag.remove((Object)"one", 1));
        BagTests.assertFalse((boolean)this.bag.contains((Object)"one"));
        BagTests.assertFalse((boolean)this.bag.remove((Object)"one"));
        BagTests.assertFalse((boolean)this.bag.remove((Object)"two", -3));
        BagTests.assertTrue((boolean)this.bag.remove((Object)"two", 1));
        BagTests.assertTrue((boolean)this.bag.contains((Object)"two"));
        BagTests.assertTrue((boolean)this.bag.remove((Object)"two", 1));
        BagTests.assertFalse((boolean)this.bag.contains((Object)"two"));
        BagTests.assertFalse((boolean)this.bag.remove((Object)"two"));
        BagTests.assertTrue((boolean)this.bag.remove((Object)"three", 3));
        BagTests.assertFalse((boolean)this.bag.contains((Object)"three"));
        BagTests.assertFalse((boolean)this.bag.remove((Object)"three"));
    }

    public void testRemoveAll() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("one");
        c.add("three");
        BagTests.assertTrue((boolean)this.bag.removeAll(c));
        BagTests.assertFalse((boolean)this.bag.contains((Object)"one"));
        BagTests.assertFalse((boolean)this.bag.contains((Object)"three"));
        BagTests.assertFalse((boolean)this.bag.remove((Object)"one"));
        BagTests.assertFalse((boolean)this.bag.remove((Object)"three"));
        BagTests.assertFalse((boolean)this.bag.removeAll(c));
    }

    public void testRetainAll() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("one");
        c.add("three");
        BagTests.assertTrue((boolean)this.bag.retainAll(c));
        BagTests.assertTrue((boolean)this.bag.contains((Object)"one"));
        BagTests.assertTrue((boolean)this.bag.contains((Object)"three"));
        BagTests.assertFalse((boolean)this.bag.contains((Object)"two"));
        BagTests.assertFalse((boolean)this.bag.contains((Object)"four"));
        BagTests.assertFalse((boolean)this.bag.remove((Object)"two"));
        BagTests.assertFalse((boolean)this.bag.remove((Object)"four"));
        BagTests.assertFalse((boolean)this.bag.retainAll(c));
    }

    public void testSize() {
        BagTests.assertTrue((this.bag.size() == 11 ? 1 : 0) != 0);
        this.bag.add((Object)"five");
        this.bag.add((Object)"five");
        this.bag.add((Object)"five");
        this.bag.add((Object)"five");
        this.bag.add((Object)"five");
        BagTests.assertEquals((int)16, (int)this.bag.size());
    }

    public void testSerialization() throws Exception {
        Bag<String> bag2 = TestTools.serialize(this.bag);
        BagTests.assertTrue((String)"same object?", (this.bag != bag2 ? 1 : 0) != 0);
        BagTests.assertEquals((int)11, (int)bag2.size());
        BagTests.assertEquals(this.bag, bag2);
        BagTests.assertTrue((boolean)bag2.contains(null));
        BagTests.assertTrue((boolean)bag2.contains((Object)"one"));
        BagTests.assertTrue((boolean)bag2.contains((Object)"two"));
        BagTests.assertTrue((boolean)bag2.contains((Object)"three"));
        BagTests.assertTrue((boolean)bag2.contains((Object)"four"));
        int nullCount = 0;
        int oneCount = 0;
        int twoCount = 0;
        int threeCount = 0;
        int fourCount = 0;
        for (String s : bag2) {
            if (s == null) {
                ++nullCount;
                continue;
            }
            if (s.equals("one")) {
                ++oneCount;
                continue;
            }
            if (s.equals("two")) {
                ++twoCount;
                continue;
            }
            if (s.equals("three")) {
                ++threeCount;
                continue;
            }
            if (!s.equals("four")) continue;
            ++fourCount;
        }
        BagTests.assertEquals((int)1, (int)nullCount);
        BagTests.assertEquals((int)1, (int)oneCount);
        BagTests.assertEquals((int)2, (int)twoCount);
        BagTests.assertEquals((int)3, (int)threeCount);
        BagTests.assertEquals((int)4, (int)fourCount);
    }

    public void testSerialization_empty() throws Exception {
        this.bag.clear();
        Bag<String> bag2 = TestTools.serialize(this.bag);
        BagTests.assertTrue((String)"same object?", (this.bag != bag2 ? 1 : 0) != 0);
        BagTests.assertEquals((int)0, (int)bag2.size());
        BagTests.assertEquals(this.bag, bag2);
    }

    public void testToArray() {
        Object[] a = this.bag.toArray();
        BagTests.assertEquals((int)11, (int)a.length);
        BagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, null));
        BagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"one"));
        BagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"two"));
        BagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"three"));
        BagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"four"));
    }

    public void testToArrayObjectArray() {
        Object[] a = new String[12];
        a[11] = "not null";
        String[] b = (String[])this.bag.toArray(a);
        BagTests.assertEquals((Object)a, (Object)b);
        BagTests.assertEquals((int)12, (int)a.length);
        BagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, null));
        BagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"one"));
        BagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"two"));
        BagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"three"));
        BagTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"four"));
        BagTests.assertTrue((a[11] == null ? 1 : 0) != 0);
    }

    public void testToString() {
        String s = this.bag.toString();
        BagTests.assertTrue((boolean)s.startsWith("["));
        BagTests.assertTrue((boolean)s.endsWith("]"));
        int commaCount = 0;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == ',') {
                ++commaCount;
            }
            ++i;
        }
        BagTests.assertEquals((int)10, (int)commaCount);
        BagTests.assertTrue((s.indexOf("one") != -1 ? 1 : 0) != 0);
        BagTests.assertTrue((s.indexOf("two") != -1 ? 1 : 0) != 0);
        BagTests.assertTrue((s.indexOf("three") != -1 ? 1 : 0) != 0);
        BagTests.assertTrue((s.indexOf("four") != -1 ? 1 : 0) != 0);
        BagTests.assertTrue((s.indexOf("null") != -1 ? 1 : 0) != 0);
    }
}

