/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.deque;

import java.util.Comparator;
import org.eclipse.jpt.common.utility.internal.deque.AbstractPriorityDeque;

public class FixedCapacityPriorityDeque<E>
extends AbstractPriorityDeque<E> {
    private static final long serialVersionUID = 1L;

    public FixedCapacityPriorityDeque(Comparator<? super E> comparator, int capacity) {
        super(comparator, capacity);
    }

    @Override
    public void enqueue(E element) {
        if (this.isFull()) {
            throw new IllegalStateException("Deque is full.");
        }
        super.enqueue(element);
    }

    public boolean isFull() {
        return this.size == this.elements.length - 1;
    }

    @Override
    public FixedCapacityPriorityDeque<E> clone() {
        return (FixedCapacityPriorityDeque)super.clone();
    }
}

