/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.cache.internal.preferences;

import java.util.Arrays;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.internet.cache.internal.Cache;
import org.eclipse.wst.internet.cache.internal.CacheMessages;
import org.eclipse.wst.internet.cache.internal.CachePlugin;

public class CachePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected Button clearButton;
    protected Button deleteButton;
    protected Button enabledButton;
    protected Button ignoreNoCacheButton;
    protected Text cacheDuration;
    protected Button disagreedLicensesButton;
    protected List entries;
    protected Composite composite = null;

    public void dispose() {
        if (this.composite != null) {
            this.composite.dispose();
        }
        super.dispose();
    }

    public CachePreferencePage() {
        this.setPreferenceStore(CachePlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.noDefaultAndApplyButton();
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.composite.setLayout((Layout)layout);
        GridData gd = new GridData(784);
        this.composite.setLayoutData((Object)gd);
        Label aboutLabel = new Label(this.composite, 64);
        aboutLabel.setText(CacheMessages._UI_PREF_CACHE_ABOUT);
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        aboutLabel.setLayoutData((Object)gridData);
        new Label(this.composite, 0);
        try {
            this.enabledButton = new Button(this.composite, 16416);
            gridData = new GridData(32);
            gridData.horizontalSpan = 2;
            this.enabledButton.setLayoutData((Object)gridData);
            this.enabledButton.setText(CacheMessages._UI_PREF_CACHE_CACHE_OPTION);
            this.enabledButton.setSelection(CachePlugin.getDefault().getPreferenceStore().getBoolean("cacheEnabled"));
            this.enabledButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled = CachePreferencePage.this.enabledButton.getSelection();
                    CachePlugin.getDefault().setCacheEnabled(enabled);
                }
            });
            this.ignoreNoCacheButton = new Button(this.composite, 16416);
            gridData = new GridData(32);
            gridData.horizontalSpan = 2;
            this.ignoreNoCacheButton.setLayoutData((Object)gridData);
            this.ignoreNoCacheButton.setText(CacheMessages._UI_PREF_CACHE_IGNORE_NO_CACHE_HEADER);
            this.ignoreNoCacheButton.setSelection(CachePlugin.getDefault().isIgnoreNoCacheHeader());
            this.ignoreNoCacheButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean ignoreNoCacheHeader = CachePreferencePage.this.ignoreNoCacheButton.getSelection();
                    CachePlugin.getDefault().setIgnoreNoCacheHeader(ignoreNoCacheHeader);
                }
            });
            this.disagreedLicensesButton = new Button(this.composite, 16416);
            gridData = new GridData(32);
            gridData.horizontalSpan = 2;
            this.disagreedLicensesButton.setLayoutData((Object)gridData);
            this.disagreedLicensesButton.setText(CacheMessages._UI_PREF_PROMPT_FOR_DISAGREED_LICENSES);
            this.disagreedLicensesButton.setSelection(CachePlugin.getDefault().getPreferenceStore().getBoolean("promptDisagreedLicenses"));
            this.disagreedLicensesButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean prompt = CachePreferencePage.this.disagreedLicensesButton.getSelection();
                    CachePlugin.getDefault().setPromptDisagreedLicenses(prompt);
                }
            });
            Composite durationWrapper = new Composite(this.composite, 0);
            durationWrapper.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).span(2, 1).create());
            GridLayout gl = new GridLayout(2, false);
            durationWrapper.setLayout((Layout)gl);
            Label cacheDurationLabel = new Label(durationWrapper, 0);
            cacheDurationLabel.setText(CacheMessages._UI_PREF_CACHE_CACHE_DURATION_LABEL);
            gridData = new GridData(4, 4, false, false);
            cacheDurationLabel.setLayoutData((Object)gridData);
            this.cacheDuration = new Text(durationWrapper, 133120);
            this.cacheDuration.setText(Long.toString(CachePlugin.getDefault().getCacheTimeout()));
            gridData = new GridData(32);
            gridData.minimumWidth = gridData.widthHint = this.convertWidthInCharsToPixels(6);
            this.cacheDuration.setLayoutData((Object)gridData);
            this.cacheDuration.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    try {
                        long newTimeout = Long.parseLong(CachePreferencePage.this.cacheDuration.getText());
                        if (newTimeout < 1L) {
                            CachePreferencePage.this.setValid(newTimeout > 0L);
                            CachePreferencePage.this.setErrorMessage(CacheMessages._NUMBER_MUST_BE_GREATER_THAN_ZERO);
                        } else {
                            CachePreferencePage.this.setValid(true);
                            CachePreferencePage.this.setErrorMessage(null);
                            CachePlugin.getDefault().setCacheTimeout(newTimeout);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        CachePreferencePage.this.setValid(false);
                        CachePreferencePage.this.setErrorMessage(CacheMessages._NOT_A_VALID_NUMBER);
                    }
                }
            });
            Label entriesLabel = new Label(this.composite, 64);
            entriesLabel.setText(CacheMessages._UI_PREF_CACHE_ENTRIES_TITLE);
            gridData = new GridData(32);
            gridData.horizontalSpan = 2;
            entriesLabel.setLayoutData((Object)gridData);
            this.entries = new List(this.composite, 2562);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.entries, "org.eclipse.wst.internet.cache.cpr0002");
            Object[] cacheEntries = Cache.getInstance().getCachedURIs();
            Arrays.sort(cacheEntries);
            this.entries.setItems((String[])cacheEntries);
            gridData = new GridData(272);
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            this.entries.setLayoutData((Object)gridData);
            this.entries.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    CachePreferencePage.this.setPreferenceWidgets();
                }
            });
            Composite buttonComposite = new Composite(this.composite, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = this.convertVerticalDLUsToPixels(3);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.numColumns = 1;
            buttonComposite.setLayout((Layout)gridLayout);
            gridData = new GridData(144);
            buttonComposite.setLayoutData((Object)gridData);
            this.deleteButton = new Button(buttonComposite, 8);
            this.deleteButton.setText(CacheMessages._UI_BUTTON_DELETE_ENTRY);
            gridData = new GridData(258);
            gridData.grabExcessHorizontalSpace = true;
            this.deleteButton.setLayoutData((Object)gridData);
            this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)CacheMessages._UI_CONFIRM_DELETE_CACHE_ENTRY_DIALOG_TITLE, (String)CacheMessages._UI_CONFIRM_DELETE_CACHE_ENTRY_DIALOG_MESSAGE)) {
                        String[] selectedEntries = CachePreferencePage.this.entries.getSelection();
                        int numSelectedEntries = selectedEntries.length;
                        Cache cache = Cache.getInstance();
                        int i = 0;
                        while (i < numSelectedEntries) {
                            cache.deleteEntry(selectedEntries[i]);
                            ++i;
                        }
                        Object[] cacheEntries = cache.getCachedURIs();
                        Arrays.sort(cacheEntries);
                        CachePreferencePage.this.entries.setItems((String[])cacheEntries);
                        CachePreferencePage.this.setPreferenceWidgets();
                    }
                }
            });
            this.clearButton = new Button(buttonComposite, 8);
            this.clearButton.setText(CacheMessages._UI_BUTTON_CLEAR_CACHE);
            gridData = new GridData(258);
            gridData.grabExcessHorizontalSpace = true;
            this.clearButton.setLayoutData((Object)gridData);
            this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)CacheMessages._UI_CONFIRM_CLEAR_CACHE_DIALOG_TITLE, (String)CacheMessages._UI_CONFIRM_CLEAR_CACHE_DIALOG_MESSAGE)) {
                        Cache cache = Cache.getInstance();
                        cache.clear();
                        Object[] cacheEntries = cache.getCachedURIs();
                        Arrays.sort(cacheEntries);
                        CachePreferencePage.this.entries.setItems((String[])cacheEntries);
                        CachePreferencePage.this.setPreferenceWidgets();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setPreferenceWidgets();
        this.applyDialogFont(this.composite);
        return this.composite;
    }

    public void setPreferenceWidgets() {
        if (this.composite != null && this.composite.getEnabled()) {
            if (this.entries.getSelectionCount() > 0) {
                this.deleteButton.setEnabled(true);
            } else {
                this.deleteButton.setEnabled(false);
            }
            if (this.entries.getItemCount() > 0) {
                this.clearButton.setEnabled(true);
            } else {
                this.clearButton.setEnabled(false);
            }
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.internet.cache.cpr0000");
    }
}

