/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.wsil.WSILElement;

public final class Util {
    protected static String sClassName = Util.class.getName();
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private Util() {
    }

    public static ThreadGroup findThreadGroup(String sName) {
        boolean bThgFound = false;
        ThreadGroup thgReturn = null;
        ThreadGroup thgCurrent = Thread.currentThread().getThreadGroup();
        if (thgCurrent.getName().equals(sName)) {
            bThgFound = true;
            thgReturn = thgCurrent;
        }
        if (!bThgFound) {
            ThreadGroup thgNext;
            ThreadGroup thgPrev = null;
            thgPrev = thgNext = thgCurrent;
            while (thgNext != null && !bThgFound) {
                thgPrev = thgNext;
                if (thgNext.getName().equals(sName)) {
                    bThgFound = true;
                    thgReturn = thgNext;
                }
                thgNext = thgPrev.getParent();
            }
        }
        if (!bThgFound) {
            ThreadGroup[] thg = new ThreadGroup[thgCurrent.activeGroupCount()];
            int iCnt = thgCurrent.enumerate(thg);
            int i = 0;
            while (i < iCnt && !bThgFound) {
                if (thg[i].getName().equals(sName)) {
                    bThgFound = true;
                    thgReturn = thg[i];
                }
                ++i;
            }
        }
        return thgReturn;
    }

    public static void out(String className, String methodName, Exception e) {
        Util.out(className, methodName, e.toString());
    }

    public static void out(String className, String methodName, String msg) {
        System.out.println("[" + className + "] [" + methodName + "()] " + msg);
    }

    public static void debug(String className, String methodName, Exception e) {
        Util.debug(className, methodName, e.toString());
    }

    public static void debug(String className, String methodName, String msg) {
        System.out.println("[" + className + "] [" + methodName + "()] " + msg);
    }

    public static String getDateTimeStamp() {
        return Util.getDateTimeStamp(new Date());
    }

    public static String getDateTimeStamp(Date date) {
        return "UTC-Timestamp=" + DateFormat.getDateTimeInstance().format(date);
    }

    public static InputStream getInputStream(String sResourceName) throws IOException {
        URL aURL;
        InputStream is;
        block10: {
            is = null;
            try {
                URL urlResource = new URL(sResourceName);
                is = Util.getInputStream(urlResource);
            }
            catch (MalformedURLException mue) {
                boolean bTryClassLoader = false;
                try {
                    is = new BufferedInputStream(new FileInputStream(sResourceName));
                }
                catch (FileNotFoundException fnfe) {
                    bTryClassLoader = true;
                }
                catch (SecurityException se) {
                    bTryClassLoader = true;
                }
                catch (Exception e) {
                    Util.out(sClassName, "getInputStream", e.toString());
                }
                if (!bTryClassLoader) break block10;
                is = ClassLoader.getSystemResourceAsStream(sResourceName);
            }
        }
        if (is == null) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(sResourceName);
        }
        if (is == null && (aURL = Thread.currentThread().getContextClassLoader().getResource(sResourceName)) != null) {
            is = Util.getInputStream(aURL);
        }
        if (is == null) {
            throw new FileNotFoundException("Could not locate resource file: " + sResourceName);
        }
        return is;
    }

    public static InputStream getInputStream(URL urlFile) throws IOException, ConnectException {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(urlFile.openStream());
        }
        catch (ConnectException e) {
            throw new ConnectException("Could not connect to URL: " + urlFile.toExternalForm() + ".");
        }
        return is;
    }

    public static String getLocalHostName() {
        String sLocalHostName;
        try {
            sLocalHostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            sLocalHostName = "127.0.0.1";
        }
        return sLocalHostName;
    }

    public static String formatURL(String hostname, String port, String urn) {
        String formatURN = urn;
        if (!formatURN.startsWith("/")) {
            formatURN = "/" + urn;
        }
        return "http://" + hostname + ":" + port + formatURN;
    }

    public static String replaceString(String sText, String sFind, String sReplace) {
        int iPrevIndex = 0;
        int iFindLen = sFind.length();
        int iReplaceLen = sReplace.length();
        String sUpdatedText = sText;
        int iIndex = sUpdatedText.indexOf(sFind);
        while (iIndex < sUpdatedText.length() - 1 && iIndex != -1) {
            sUpdatedText = String.valueOf(sUpdatedText.substring(0, iIndex)) + sReplace + sUpdatedText.substring(iIndex + iFindLen);
            iPrevIndex = iIndex;
            iIndex = sUpdatedText.indexOf(sFind, iPrevIndex + iReplaceLen);
        }
        return sUpdatedText;
    }

    public static String[] toStringArray(String s) {
        return Util.toStringArray(s, " ");
    }

    public static String[] toStringArray(String s, String sDelim) {
        int iCnt = 0;
        String[] sa = null;
        if (s == null) {
            sa = new String[]{};
        } else {
            StringTokenizer st = new StringTokenizer(s, " ");
            sa = new String[st.countTokens()];
            while (st.hasMoreTokens()) {
                sa[iCnt++] = st.nextToken();
            }
        }
        return sa;
    }

    public static URL createURL(String urlString) throws MalformedURLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        URL url = null;
        if (urlString != null) {
            if (urlString.startsWith("https")) {
                String t1 = new String(urlString.substring(8));
                String host = new String(t1.substring(0, t1.indexOf(47)));
                String file = new String(t1.substring(t1.indexOf(47)));
                int index = host.indexOf(":443");
                if (index != -1) {
                    host = host.substring(0, index);
                }
                url = new URL("https", host, 443, file, (URLStreamHandler)Class.forName("com.ibm.net.ssl.internal.www.protocol.https.Handler").newInstance());
            } else {
                url = new URL(urlString);
            }
        }
        return url;
    }

    public static String createHttpsURL(String url) {
        String returnURL = null;
        if (url != null) {
            if (url.startsWith("https")) {
                String t1 = new String(url.substring(8));
                String prot = new String(url.substring(0, 8));
                String host = new String(t1.substring(0, t1.indexOf(47)));
                String file = new String(t1.substring(t1.indexOf(47)));
                int index = host.indexOf(":443");
                if (index != -1) {
                    host = host.substring(0, index);
                }
                returnURL = String.valueOf(prot) + host + ":443" + file;
            } else {
                returnURL = url;
            }
        }
        return returnURL;
    }

    public static String toXMLString(Collection collection) {
        StringBuffer sb = new StringBuffer("");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            sb.append(((WSILElement)iterator.next()).toXMLString());
        }
        return sb.toString();
    }
}

