/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.reference;

import org.eclipse.jpt.common.utility.internal.predicate.int_.IntPredicateTools;
import org.eclipse.jpt.common.utility.internal.reference.SimpleIntReference;
import org.eclipse.jpt.common.utility.internal.reference.SynchronizedInt;
import org.eclipse.jpt.common.utility.reference.IntReference;
import org.eclipse.jpt.common.utility.reference.ModifiableIntReference;
import org.eclipse.jpt.common.utility.tests.internal.MultiThreadedTestCase;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class SynchronizedIntTests
extends MultiThreadedTestCase {
    private volatile SynchronizedInt si;
    volatile boolean timeoutOccurred;
    volatile int value = 7;
    volatile long startTime;
    volatile long endTime;
    volatile int sIntValue;

    public SynchronizedIntTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.si = new SynchronizedInt();
        this.timeoutOccurred = false;
        this.startTime = 0L;
        this.endTime = 0L;
        this.sIntValue = 0;
    }

    public void testCtorIntObject() throws Exception {
        String mutex = "mutex";
        SynchronizedInt syncInt = new SynchronizedInt(22, (Object)mutex);
        SynchronizedIntTests.assertEquals((int)22, (int)syncInt.getValue());
        SynchronizedIntTests.assertEquals((Object)mutex, (Object)syncInt.getMutex());
    }

    public void testCtorInt() throws Exception {
        SynchronizedInt syncInt = new SynchronizedInt(22);
        SynchronizedIntTests.assertEquals((int)22, (int)syncInt.getValue());
        SynchronizedIntTests.assertEquals((Object)syncInt, (Object)syncInt.getMutex());
    }

    public void testCtorObject() throws Exception {
        String mutex = "mutex";
        SynchronizedInt syncInt = new SynchronizedInt((Object)mutex);
        SynchronizedIntTests.assertEquals((int)0, (int)syncInt.getValue());
        SynchronizedIntTests.assertEquals((Object)mutex, (Object)syncInt.getMutex());
    }

    public void testGetValue() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
    }

    public void testEqualsInt() throws Exception {
        SynchronizedIntTests.assertTrue((boolean)this.si.equals(0));
        SynchronizedIntTests.assertFalse((boolean)this.si.equals(7));
        this.si.setValue(this.value);
        SynchronizedIntTests.assertFalse((boolean)this.si.equals(0));
        SynchronizedIntTests.assertTrue((boolean)this.si.equals(7));
    }

    public void testNotEqualInt() throws Exception {
        SynchronizedIntTests.assertTrue((boolean)this.si.notEqual(7));
        SynchronizedIntTests.assertFalse((boolean)this.si.notEqual(0));
        this.si.setValue(this.value);
        SynchronizedIntTests.assertTrue((boolean)this.si.notEqual(0));
        SynchronizedIntTests.assertFalse((boolean)this.si.notEqual(7));
    }

    public void testIsZero() throws Exception {
        SynchronizedIntTests.assertTrue((boolean)this.si.isZero());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertFalse((boolean)this.si.isZero());
    }

    public void testIsNotZero() throws Exception {
        SynchronizedIntTests.assertFalse((boolean)this.si.isNotZero());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertTrue((boolean)this.si.isNotZero());
    }

    public void testIsGreaterThan() throws Exception {
        SynchronizedIntTests.assertTrue((boolean)this.si.isGreaterThan(-1));
        SynchronizedIntTests.assertFalse((boolean)this.si.isGreaterThan(0));
        SynchronizedIntTests.assertFalse((boolean)this.si.isGreaterThan(1));
        this.si.setValue(this.value);
        SynchronizedIntTests.assertTrue((boolean)this.si.isGreaterThan(-1));
        SynchronizedIntTests.assertFalse((boolean)this.si.isGreaterThan(7));
        SynchronizedIntTests.assertFalse((boolean)this.si.isGreaterThan(8));
    }

    public void testIsGreaterThanOrEqual() throws Exception {
        SynchronizedIntTests.assertTrue((boolean)this.si.isGreaterThanOrEqual(-1));
        SynchronizedIntTests.assertTrue((boolean)this.si.isGreaterThanOrEqual(0));
        SynchronizedIntTests.assertFalse((boolean)this.si.isGreaterThanOrEqual(1));
        this.si.setValue(this.value);
        SynchronizedIntTests.assertTrue((boolean)this.si.isGreaterThanOrEqual(-1));
        SynchronizedIntTests.assertTrue((boolean)this.si.isGreaterThanOrEqual(7));
        SynchronizedIntTests.assertFalse((boolean)this.si.isGreaterThanOrEqual(8));
    }

    public void testIsLessThan() throws Exception {
        SynchronizedIntTests.assertFalse((boolean)this.si.isLessThan(-1));
        SynchronizedIntTests.assertFalse((boolean)this.si.isLessThan(0));
        SynchronizedIntTests.assertTrue((boolean)this.si.isLessThan(1));
        this.si.setValue(this.value);
        SynchronizedIntTests.assertFalse((boolean)this.si.isLessThan(-1));
        SynchronizedIntTests.assertFalse((boolean)this.si.isLessThan(7));
        SynchronizedIntTests.assertTrue((boolean)this.si.isLessThan(8));
    }

    public void testIsLessThanOrEqual() throws Exception {
        SynchronizedIntTests.assertFalse((boolean)this.si.isLessThanOrEqual(-1));
        SynchronizedIntTests.assertTrue((boolean)this.si.isLessThanOrEqual(0));
        SynchronizedIntTests.assertTrue((boolean)this.si.isLessThanOrEqual(1));
        this.si.setValue(this.value);
        SynchronizedIntTests.assertFalse((boolean)this.si.isLessThanOrEqual(-1));
        SynchronizedIntTests.assertTrue((boolean)this.si.isLessThanOrEqual(7));
        SynchronizedIntTests.assertTrue((boolean)this.si.isLessThanOrEqual(8));
    }

    public void testIsPositive() throws Exception {
        SynchronizedIntTests.assertFalse((boolean)this.si.isPositive());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertTrue((boolean)this.si.isPositive());
        this.si.setValue(-3);
        SynchronizedIntTests.assertFalse((boolean)this.si.isPositive());
    }

    public void testIsNotPositive() throws Exception {
        SynchronizedIntTests.assertTrue((boolean)this.si.isNotPositive());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertFalse((boolean)this.si.isNotPositive());
        this.si.setValue(-3);
        SynchronizedIntTests.assertTrue((boolean)this.si.isNotPositive());
    }

    public void testIsNegative() throws Exception {
        SynchronizedIntTests.assertFalse((boolean)this.si.isNegative());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertFalse((boolean)this.si.isNegative());
        this.si.setValue(-3);
        SynchronizedIntTests.assertTrue((boolean)this.si.isNegative());
    }

    public void testIsNotNegative() throws Exception {
        SynchronizedIntTests.assertTrue((boolean)this.si.isNotNegative());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertTrue((boolean)this.si.isNotNegative());
        this.si.setValue(-3);
        SynchronizedIntTests.assertFalse((boolean)this.si.isNotNegative());
    }

    public void testIsMemberOfIntPredicate() throws Exception {
        SynchronizedIntTests.assertTrue((boolean)this.si.isMemberOf(IntPredicateTools.isEven()));
        SynchronizedIntTests.assertFalse((boolean)this.si.isMemberOf(IntPredicateTools.isGreaterThan((int)2)));
        this.si.setValue(this.value);
        SynchronizedIntTests.assertFalse((boolean)this.si.isMemberOf(IntPredicateTools.isEven()));
        SynchronizedIntTests.assertTrue((boolean)this.si.isMemberOf(IntPredicateTools.isGreaterThan((int)2)));
    }

    public void testIsNotMemberOfIntPredicate() throws Exception {
        SynchronizedIntTests.assertFalse((boolean)this.si.isNotMemberOf(IntPredicateTools.isEven()));
        SynchronizedIntTests.assertTrue((boolean)this.si.isNotMemberOf(IntPredicateTools.isGreaterThan((int)2)));
        this.si.setValue(this.value);
        SynchronizedIntTests.assertTrue((boolean)this.si.isNotMemberOf(IntPredicateTools.isEven()));
        SynchronizedIntTests.assertFalse((boolean)this.si.isNotMemberOf(IntPredicateTools.isGreaterThan((int)2)));
    }

    public void testSetValue() throws Exception {
        this.si.setValue(0);
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        SynchronizedIntTests.assertFalse((boolean)this.si.isNotZero());
        SynchronizedIntTests.assertTrue((boolean)this.si.isZero());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertEquals((int)this.value, (int)this.si.getValue());
        SynchronizedIntTests.assertTrue((boolean)this.si.isNotZero());
        SynchronizedIntTests.assertFalse((boolean)this.si.isZero());
    }

    public void testSetZero() throws Exception {
        this.si.setZero();
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        SynchronizedIntTests.assertFalse((boolean)this.si.isNotZero());
        SynchronizedIntTests.assertTrue((boolean)this.si.isZero());
    }

    public void testIncrement() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)1, (int)this.si.increment());
        SynchronizedIntTests.assertEquals((int)1, (int)this.si.getValue());
    }

    public void testIncrementExact() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)1, (int)this.si.incrementExact());
        SynchronizedIntTests.assertEquals((int)1, (int)this.si.getValue());
    }

    public void testDecrement() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)-1, (int)this.si.decrement());
        SynchronizedIntTests.assertEquals((int)-1, (int)this.si.getValue());
    }

    public void testDecrementExact() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)-1, (int)this.si.decrementExact());
        SynchronizedIntTests.assertEquals((int)-1, (int)this.si.getValue());
    }

    public void testHalve() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.halve());
        this.si.setValue(22);
        SynchronizedIntTests.assertEquals((int)11, (int)this.si.halve());
        SynchronizedIntTests.assertEquals((int)11, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)5, (int)this.si.halve());
        SynchronizedIntTests.assertEquals((int)5, (int)this.si.getValue());
    }

    public void testTwice() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.twice());
        this.si.setValue(11);
        SynchronizedIntTests.assertEquals((int)22, (int)this.si.twice());
        SynchronizedIntTests.assertEquals((int)22, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)44, (int)this.si.twice());
        SynchronizedIntTests.assertEquals((int)44, (int)this.si.getValue());
    }

    public void testTwiceExact() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.twiceExact());
        this.si.setValue(11);
        SynchronizedIntTests.assertEquals((int)22, (int)this.si.twiceExact());
        SynchronizedIntTests.assertEquals((int)22, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)44, (int)this.si.twiceExact());
        SynchronizedIntTests.assertEquals((int)44, (int)this.si.getValue());
    }

    public void testAbs() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.abs());
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertEquals((int)this.value, (int)this.si.abs());
        SynchronizedIntTests.assertEquals((int)this.value, (int)this.si.getValue());
        this.si.setValue(-this.value);
        SynchronizedIntTests.assertEquals((int)this.value, (int)this.si.abs());
        SynchronizedIntTests.assertEquals((int)this.value, (int)this.si.getValue());
    }

    public void testNegate() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.negate());
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertEquals((int)(-this.value), (int)this.si.negate());
        SynchronizedIntTests.assertEquals((int)(-this.value), (int)this.si.getValue());
        this.si.setValue(-this.value);
        SynchronizedIntTests.assertEquals((int)this.value, (int)this.si.negate());
        SynchronizedIntTests.assertEquals((int)this.value, (int)this.si.getValue());
    }

    public void testNegateExact() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.negateExact());
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertEquals((int)(-this.value), (int)this.si.negateExact());
        SynchronizedIntTests.assertEquals((int)(-this.value), (int)this.si.getValue());
        this.si.setValue(-this.value);
        SynchronizedIntTests.assertEquals((int)this.value, (int)this.si.negateExact());
        SynchronizedIntTests.assertEquals((int)this.value, (int)this.si.getValue());
    }

    public void testAddInt() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.add(0));
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.add(3));
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertEquals((int)10, (int)this.si.add(3));
        SynchronizedIntTests.assertEquals((int)10, (int)this.si.getValue());
        this.si.setValue(-this.value);
        SynchronizedIntTests.assertEquals((int)-4, (int)this.si.add(3));
        SynchronizedIntTests.assertEquals((int)-4, (int)this.si.getValue());
    }

    public void testAddExactInt() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.addExact(0));
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.addExact(3));
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertEquals((int)10, (int)this.si.addExact(3));
        SynchronizedIntTests.assertEquals((int)10, (int)this.si.getValue());
        this.si.setValue(-this.value);
        SynchronizedIntTests.assertEquals((int)-4, (int)this.si.addExact(3));
        SynchronizedIntTests.assertEquals((int)-4, (int)this.si.getValue());
    }

    public void testSubtractInt() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.subtract(0));
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)-3, (int)this.si.subtract(3));
        SynchronizedIntTests.assertEquals((int)-3, (int)this.si.getValue());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertEquals((int)4, (int)this.si.subtract(3));
        SynchronizedIntTests.assertEquals((int)4, (int)this.si.getValue());
        this.si.setValue(-this.value);
        SynchronizedIntTests.assertEquals((int)-10, (int)this.si.subtract(3));
        SynchronizedIntTests.assertEquals((int)-10, (int)this.si.getValue());
    }

    public void testSubtractExactInt() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.subtractExact(0));
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)-3, (int)this.si.subtractExact(3));
        SynchronizedIntTests.assertEquals((int)-3, (int)this.si.getValue());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertEquals((int)4, (int)this.si.subtractExact(3));
        SynchronizedIntTests.assertEquals((int)4, (int)this.si.getValue());
        this.si.setValue(-this.value);
        SynchronizedIntTests.assertEquals((int)-10, (int)this.si.subtractExact(3));
        SynchronizedIntTests.assertEquals((int)-10, (int)this.si.getValue());
    }

    public void testMultiplyInt() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.multiply(0));
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.multiply(3));
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertEquals((int)21, (int)this.si.multiply(3));
        SynchronizedIntTests.assertEquals((int)21, (int)this.si.getValue());
        this.si.setValue(-this.value);
        SynchronizedIntTests.assertEquals((int)-21, (int)this.si.multiply(3));
        SynchronizedIntTests.assertEquals((int)-21, (int)this.si.getValue());
    }

    public void testMultiplyExactInt() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.multiplyExact(0));
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.multiplyExact(3));
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertEquals((int)21, (int)this.si.multiplyExact(3));
        SynchronizedIntTests.assertEquals((int)21, (int)this.si.getValue());
        this.si.setValue(-this.value);
        SynchronizedIntTests.assertEquals((int)-21, (int)this.si.multiplyExact(3));
        SynchronizedIntTests.assertEquals((int)-21, (int)this.si.getValue());
    }

    public void testDivideInt() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.divide(3));
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertEquals((int)2, (int)this.si.divide(3));
        SynchronizedIntTests.assertEquals((int)2, (int)this.si.getValue());
        this.si.setValue(-this.value);
        SynchronizedIntTests.assertEquals((int)-2, (int)this.si.divide(3));
        SynchronizedIntTests.assertEquals((int)-2, (int)this.si.getValue());
    }

    public void testFloorDivideInt() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.floorDivide(3));
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertEquals((int)2, (int)this.si.floorDivide(3));
        SynchronizedIntTests.assertEquals((int)2, (int)this.si.getValue());
        this.si.setValue(-this.value);
        SynchronizedIntTests.assertEquals((int)-3, (int)this.si.floorDivide(3));
        SynchronizedIntTests.assertEquals((int)-3, (int)this.si.getValue());
    }

    public void testRemainderInt() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.remainder(3));
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertEquals((int)1, (int)this.si.remainder(3));
        SynchronizedIntTests.assertEquals((int)1, (int)this.si.getValue());
        this.si.setValue(-this.value);
        SynchronizedIntTests.assertEquals((int)-1, (int)this.si.remainder(3));
        SynchronizedIntTests.assertEquals((int)-1, (int)this.si.getValue());
    }

    public void testFloorRemainderInt() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.floorRemainder(3));
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertEquals((int)1, (int)this.si.floorRemainder(3));
        SynchronizedIntTests.assertEquals((int)1, (int)this.si.getValue());
        this.si.setValue(-this.value);
        SynchronizedIntTests.assertEquals((int)2, (int)this.si.floorRemainder(3));
        SynchronizedIntTests.assertEquals((int)2, (int)this.si.getValue());
    }

    public void testMinInt() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.min(0));
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.min(3));
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
        this.si.setValue(-this.value);
        SynchronizedIntTests.assertEquals((int)-7, (int)this.si.min(3));
        SynchronizedIntTests.assertEquals((int)-7, (int)this.si.getValue());
    }

    public void testMaxInt() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.max(0));
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertEquals((int)7, (int)this.si.max(3));
        SynchronizedIntTests.assertEquals((int)7, (int)this.si.getValue());
        this.si.setValue(-this.value);
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.max(3));
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
    }

    public void testCommitIntInt() throws Exception {
        SynchronizedIntTests.assertFalse((boolean)this.si.commit(0, -3));
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        SynchronizedIntTests.assertFalse((boolean)this.si.commit(0, 3));
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        SynchronizedIntTests.assertTrue((boolean)this.si.commit(0, 0));
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        this.si.setValue(this.value);
        SynchronizedIntTests.assertTrue((boolean)this.si.commit(3, 7));
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
        this.si.setValue(-this.value);
        SynchronizedIntTests.assertTrue((boolean)this.si.commit(3, -7));
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
    }

    public void testSwapRef() throws Exception {
        SynchronizedInt temp = this.si;
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.swap((ModifiableIntReference)temp));
        SimpleIntReference ref = new SimpleIntReference(42);
        SynchronizedIntTests.assertEquals((int)42, (int)this.si.swap((ModifiableIntReference)ref));
        SynchronizedIntTests.assertEquals((int)42, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)0, (int)ref.getValue());
        this.si.setValue(42);
        ref.setValue(42);
        SynchronizedIntTests.assertEquals((int)42, (int)this.si.swap((ModifiableIntReference)ref));
        SynchronizedIntTests.assertEquals((int)42, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)42, (int)ref.getValue());
    }

    public void testSwapSyncInt() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.swap(this.si));
        SynchronizedInt ref = new SynchronizedInt(42);
        SynchronizedIntTests.assertEquals((int)42, (int)this.si.swap((ModifiableIntReference)ref));
        SynchronizedIntTests.assertEquals((int)42, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)0, (int)ref.getValue());
        this.si.setValue(42);
        ref.setValue(42);
        SynchronizedIntTests.assertEquals((int)42, (int)this.si.swap((ModifiableIntReference)ref));
        SynchronizedIntTests.assertEquals((int)42, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)42, (int)ref.getValue());
        ref.setValue(33);
        SynchronizedIntTests.assertEquals((int)42, (int)ref.swap((ModifiableIntReference)this.si));
        SynchronizedIntTests.assertEquals((int)33, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)42, (int)ref.getValue());
    }

    public void testSwapSyncInt2() throws Exception {
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.swap(this.si));
        SynchronizedInt ref = new SynchronizedInt(42);
        SynchronizedIntTests.assertEquals((int)42, (int)this.si.swap(ref));
        SynchronizedIntTests.assertEquals((int)42, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)0, (int)ref.getValue());
        this.si.setValue(42);
        ref.setValue(42);
        SynchronizedIntTests.assertEquals((int)42, (int)this.si.swap(ref));
        SynchronizedIntTests.assertEquals((int)42, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)42, (int)ref.getValue());
    }

    public void testGetMutexThis() throws Exception {
        SynchronizedIntTests.assertSame((Object)this.si, (Object)this.si.getMutex());
    }

    public void testWaitUntilZero() throws Exception {
        this.verifyWaitUntilZero(-1L);
        SynchronizedIntTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        long time = this.calculateElapsedTime();
        SynchronizedIntTests.assertTrue((String)("t2 finished a bit early (expected value should be > " + TICK + "): " + time), (time > TICK ? 1 : 0) != 0);
    }

    public void testWaitUntilZero2() throws Exception {
        this.verifyWaitUntilZero(0L);
        SynchronizedIntTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        long time = this.calculateElapsedTime();
        SynchronizedIntTests.assertTrue((String)("t2 finished a bit early (expected value should be > " + TICK + "): " + time), (time > TICK ? 1 : 0) != 0);
    }

    public void testWaitUntilZeroTimeout() throws Exception {
        this.verifyWaitUntilZero(TICK);
        SynchronizedIntTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        long time = this.calculateElapsedTime();
        SynchronizedIntTests.assertTrue((String)("t2 finished a bit late (expected value should be < " + THREE_TICKS + "): " + time), (time < THREE_TICKS ? 1 : 0) != 0);
    }

    public void testWaitUntilZeroTimeout2() throws Exception {
        this.verifyWaitUntilZero(THREE_TICKS);
        SynchronizedIntTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
        long time = this.calculateElapsedTime();
        SynchronizedIntTests.assertTrue((String)("t2 finished a bit early (expected value should be >= " + TWO_TICKS + "): " + time), (time >= TWO_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitUntilZero(long t2Timeout) throws Exception {
        this.executeThreads(this.buildSetZeroCommand(), this.buildWaitUntilZeroCommand(t2Timeout));
    }

    private Command buildWaitUntilZeroCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedInt sInt) throws InterruptedException {
                SynchronizedIntTests.this.startTime = System.currentTimeMillis();
                SynchronizedIntTests.this.timeoutOccurred = this.timeoutOccurred(sInt);
                SynchronizedIntTests.this.endTime = System.currentTimeMillis();
            }

            private boolean timeoutOccurred(SynchronizedInt sInt) throws InterruptedException {
                if (timeout < 0L) {
                    sInt.waitUntilZero();
                    return false;
                }
                return !sInt.waitUntilZero(timeout);
            }
        };
    }

    public void testWaitUntilNotPredicate() throws Exception {
        this.si.waitUntilNot(IntPredicateTools.isEqual((int)7));
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
    }

    public void testWaitUntilNotPredicateTimeout() throws Exception {
        this.si.waitUntilNot(IntPredicateTools.isEqual((int)7), TWO_TICKS);
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
    }

    public void testWaitUntilNotEqualInt() throws Exception {
        this.si.waitUntilNotEqual(7);
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
    }

    public void testWaitUntilNotEqualIntTimeout() throws Exception {
        this.si.waitUntilNotEqual(7, TWO_TICKS);
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
    }

    public void testWaitUntilNotZero() throws Exception {
        this.si.setValue(3);
        this.si.waitUntilNotZero();
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
    }

    public void testWaitUntilNotZeroTimeout() throws Exception {
        this.si.setValue(3);
        this.si.waitUntilNotZero(TWO_TICKS);
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
    }

    public void testWaitUntilGreaterThanInt() throws Exception {
        this.si.setValue(3);
        this.si.waitUntilGreaterThan(2);
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
    }

    public void testWaitUntilGreaterThanIntTimeout() throws Exception {
        this.si.setValue(3);
        this.si.waitUntilGreaterThan(2, TWO_TICKS);
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
    }

    public void testWaitUntilGreaterThanOrEqualInt() throws Exception {
        this.si.setValue(3);
        this.si.waitUntilGreaterThanOrEqual(2);
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
        this.si.waitUntilGreaterThanOrEqual(3);
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
    }

    public void testWaitUntilGreaterThanOrEqualIntTimeout() throws Exception {
        this.si.setValue(3);
        this.si.waitUntilGreaterThanOrEqual(2, TWO_TICKS);
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
        this.si.waitUntilGreaterThanOrEqual(3, TWO_TICKS);
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
    }

    public void testWaitUntilLessThanInt() throws Exception {
        this.si.setValue(3);
        this.si.waitUntilLessThan(4);
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
    }

    public void testWaitUntilLessThanIntTimeout() throws Exception {
        this.si.setValue(3);
        this.si.waitUntilLessThan(4, TWO_TICKS);
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
    }

    public void testWaitUntilLessThanOrEqualInt() throws Exception {
        this.si.setValue(3);
        this.si.waitUntilLessThanOrEqual(4);
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
        this.si.waitUntilLessThanOrEqual(3);
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
    }

    public void testWaitUntilLessThanOrEqualIntTimeout() throws Exception {
        this.si.setValue(3);
        this.si.waitUntilLessThanOrEqual(4, TWO_TICKS);
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
        this.si.waitUntilLessThanOrEqual(3, TWO_TICKS);
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
    }

    public void testWaitUntilPositive() throws Exception {
        this.si.setValue(3);
        this.si.waitUntilPositive();
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
    }

    public void testWaitUntilPositiveTimeout() throws Exception {
        this.si.setValue(3);
        this.si.waitUntilPositive(TWO_TICKS);
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
    }

    public void testWaitUntilNotPositive() throws Exception {
        this.si.setValue(-3);
        this.si.waitUntilNotPositive();
        SynchronizedIntTests.assertEquals((int)-3, (int)this.si.getValue());
    }

    public void testWaitUntilNotPositiveTimeout() throws Exception {
        this.si.setValue(-3);
        this.si.waitUntilNotPositive(TWO_TICKS);
        SynchronizedIntTests.assertEquals((int)-3, (int)this.si.getValue());
    }

    public void testWaitUntilNegative() throws Exception {
        this.si.setValue(-3);
        this.si.waitUntilNegative();
        SynchronizedIntTests.assertEquals((int)-3, (int)this.si.getValue());
    }

    public void testWaitUntilNegativeTimeout() throws Exception {
        this.si.setValue(-3);
        this.si.waitUntilNegative(TWO_TICKS);
        SynchronizedIntTests.assertEquals((int)-3, (int)this.si.getValue());
    }

    public void testWaitUntilNotNegative() throws Exception {
        this.si.setValue(3);
        this.si.waitUntilNotNegative();
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
    }

    public void testWaitUntilNotNegativeTimeout() throws Exception {
        this.si.setValue(3);
        this.si.waitUntilNotNegative(TWO_TICKS);
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
    }

    public void testWaitToSetValue() throws Exception {
        this.verifyWaitToSetValue(-1L);
        SynchronizedIntTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedIntTests.assertTrue((boolean)this.si.isNotZero());
        long time = this.calculateElapsedTime();
        SynchronizedIntTests.assertTrue((String)("t2 finished a bit early (expected value should be > " + TICK + "): " + time), (time > TICK ? 1 : 0) != 0);
    }

    public void testWaitToSetValue2() throws Exception {
        this.verifyWaitToSetValue(0L);
        SynchronizedIntTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedIntTests.assertTrue((boolean)this.si.isNotZero());
        long time = this.calculateElapsedTime();
        SynchronizedIntTests.assertTrue((String)("t2 finished a bit early (expected value should be > " + TICK + "): " + time), (time > TICK ? 1 : 0) != 0);
    }

    public void testWaitToSetValueTimeout() throws Exception {
        this.verifyWaitToSetValue(TICK);
        SynchronizedIntTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedIntTests.assertTrue((boolean)this.si.isZero());
        long time = this.calculateElapsedTime();
        SynchronizedIntTests.assertTrue((String)("t2 finished a bit late (expected value should be < " + THREE_TICKS + "): " + time), (time < THREE_TICKS ? 1 : 0) != 0);
    }

    public void testWaitToSetValueTimeout2() throws Exception {
        this.verifyWaitToSetValue(THREE_TICKS);
        SynchronizedIntTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedIntTests.assertFalse((boolean)this.si.isZero());
        long time = this.calculateElapsedTime();
        SynchronizedIntTests.assertTrue((String)("t2 finished a bit early (expected value should be >= " + TWO_TICKS + "): " + time), (time >= TWO_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitToSetValue(long t2Timeout) throws Exception {
        this.executeThreads(this.buildSetZeroCommand(), this.buildWaitToSetValueCommand(t2Timeout));
    }

    private Command buildWaitToSetValueCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedInt sInt) throws InterruptedException {
                SynchronizedIntTests.this.startTime = System.currentTimeMillis();
                SynchronizedIntTests.this.timeoutOccurred = this.timeoutOccurred(sInt);
                SynchronizedIntTests.this.endTime = System.currentTimeMillis();
            }

            private boolean timeoutOccurred(SynchronizedInt sInt) throws InterruptedException {
                if (timeout < 0L) {
                    sInt.waitToSetValue(SynchronizedIntTests.this.value);
                    return false;
                }
                return !sInt.waitToSetValue(SynchronizedIntTests.this.value, timeout);
            }
        };
    }

    public void testWaitToSetZero() throws Exception {
        this.si.setValue(3);
        this.si.waitToSetZero();
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
    }

    public void testWaitToSetZeroTimeout() throws Exception {
        this.si.setValue(3);
        this.si.waitToSetZero(TWO_TICKS);
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.getValue());
    }

    public void testWaitToCommit() throws Exception {
        this.si.setValue(3);
        this.si.waitToCommit(7, 3);
        SynchronizedIntTests.assertEquals((int)7, (int)this.si.getValue());
    }

    public void testWaitToCommitTimeout() throws Exception {
        this.si.setValue(3);
        SynchronizedIntTests.assertTrue((boolean)this.si.waitToCommit(7, 3, TWO_TICKS));
        SynchronizedIntTests.assertEquals((int)7, (int)this.si.getValue());
    }

    public void testWaitToCommitTimeout2() throws Exception {
        this.si.setValue(3);
        SynchronizedIntTests.assertFalse((boolean)this.si.waitToCommit(7, 333, TWO_TICKS));
        SynchronizedIntTests.assertEquals((int)3, (int)this.si.getValue());
    }

    public void testExecute() throws Exception {
        this.si.setValue(0);
        Runnable r1 = this.buildRunnable(this.buildInitializeValueCommand(), this.si, 0L);
        Runnable r2 = this.buildRunnable(this.buildGetValueCommand(), this.si, TICK);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        SynchronizedIntTests.assertEquals((int)42, (int)this.si.getValue());
        SynchronizedIntTests.assertEquals((int)42, (int)this.sIntValue);
        long time = this.calculateElapsedTime();
        SynchronizedIntTests.assertTrue((String)("t2 finished a bit early (expected value should be > " + TWO_TICKS + "): " + time), (time > TWO_TICKS ? 1 : 0) != 0);
    }

    private void executeThreads(Command t1Command, Command t2Command) throws Exception {
        this.si.setValue(this.value);
        Runnable r1 = this.buildRunnable(t1Command, this.si, TWO_TICKS);
        Runnable r2 = this.buildRunnable(t2Command, this.si, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildSetZeroCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedInt sInt) {
                sInt.setZero();
            }
        };
    }

    private Command buildInitializeValueCommand() {
        return new Command(){

            @Override
            public void execute(final SynchronizedInt sInt) throws InterruptedException {
                sInt.execute(new org.eclipse.jpt.common.utility.command.Command(){

                    public void execute() {
                        try {
                            Thread.sleep(5L * TICK);
                        }
                        catch (InterruptedException ex) {
                            throw new RuntimeException(ex);
                        }
                        sInt.setValue(42);
                    }
                });
            }
        };
    }

    private Command buildGetValueCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedInt sInt) throws InterruptedException {
                SynchronizedIntTests.this.startTime = System.currentTimeMillis();
                SynchronizedIntTests.this.sIntValue = sInt.getValue();
                SynchronizedIntTests.this.endTime = System.currentTimeMillis();
            }
        };
    }

    private Runnable buildRunnable(final Command command, final SynchronizedInt sInt, final long sleep) {
        return new MultiThreadedTestCase.TestRunnable(this){

            @Override
            protected void run_() throws InterruptedException {
                if (sleep != 0L) {
                    Thread.sleep(sleep);
                }
                command.execute(sInt);
            }
        };
    }

    private long calculateElapsedTime() {
        return this.endTime - this.startTime;
    }

    public void testCompareTo() throws Exception {
        SynchronizedInt ref = this.si;
        SynchronizedIntTests.assertEquals((int)0, (int)this.si.compareTo((IntReference)ref));
        SimpleIntReference other = new SimpleIntReference(42);
        SynchronizedIntTests.assertTrue((this.si.compareTo((IntReference)other) < 0 ? 1 : 0) != 0);
        SynchronizedIntTests.assertTrue((other.compareTo((Object)this.si) > 0 ? 1 : 0) != 0);
        this.si.setValue(44);
        SynchronizedIntTests.assertTrue((this.si.compareTo((IntReference)other) > 0 ? 1 : 0) != 0);
        SynchronizedIntTests.assertTrue((other.compareTo((Object)this.si) < 0 ? 1 : 0) != 0);
    }

    public void testEquals() {
        SynchronizedInt si2 = new SynchronizedInt();
        SynchronizedIntTests.assertTrue((boolean)this.si.equals((Object)this.si));
        SynchronizedIntTests.assertFalse((boolean)this.si.equals((Object)si2));
    }

    public void testHashCode() {
        SynchronizedIntTests.assertEquals((int)this.si.hashCode(), (int)this.si.hashCode());
    }

    public void testClone() {
        SynchronizedInt clone = this.si.clone();
        SynchronizedIntTests.assertEquals((int)0, (int)clone.getValue());
        SynchronizedIntTests.assertNotSame((Object)clone, (Object)this.si);
        this.si.setValue(42);
        clone = this.si.clone();
        SynchronizedIntTests.assertEquals((int)42, (int)clone.getValue());
        SynchronizedIntTests.assertNotSame((Object)clone, (Object)this.si);
    }

    public void testSerialization() throws Exception {
        this.si.setValue(44);
        SynchronizedInt clone = TestTools.serialize(this.si);
        SynchronizedIntTests.assertNotSame((Object)this.si, (Object)clone);
        SynchronizedIntTests.assertEquals((int)44, (int)clone.getValue());
    }

    public void testToString() {
        SynchronizedIntTests.assertEquals((String)"[0]", (String)this.si.toString());
        this.si.setValue(42);
        SynchronizedIntTests.assertEquals((String)"[42]", (String)this.si.toString());
    }

    private static interface Command {
        public void execute(SynchronizedInt var1) throws InterruptedException;
    }
}

