/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.details;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.SpecifiedTable;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.jpt.jpa.ui.details.JptJpaUiDetailsMessages;
import org.eclipse.jpt.jpa.ui.internal.JpaHelpContextIds;
import org.eclipse.jpt.jpa.ui.internal.details.db.CatalogCombo;
import org.eclipse.jpt.jpa.ui.internal.details.db.SchemaCombo;
import org.eclipse.jpt.jpa.ui.internal.details.db.TableCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class TableComposite
extends Pane<Entity> {
    static final Collection<String> SCHEMA_PICK_LIST_PROPERTIES = Arrays.asList("defaultCatalog", "specifiedCatalog");
    static final Collection<String> TABLE_PICK_LIST_PROPERTIES = Arrays.asList((String[])ArrayTools.addAll((Object[])SCHEMA_PICK_LIST_PROPERTIES.toArray(StringTools.EMPTY_STRING_ARRAY), (Object[])new String[]{"defaultSchema", "specifiedSchema"}));

    public TableComposite(Pane<? extends Entity> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    protected Composite addComposite(Composite parent) {
        Group tableGroupPane = this.addTitledGroup(parent, JptJpaUiDetailsMessages.TABLE_COMPOSITE_TABLE_SECTION, 2, null);
        return tableGroupPane;
    }

    protected void initializeLayout(Composite container) {
        ModifiablePropertyValueModel<SpecifiedTable> subjectHolder = this.buildTableHolder();
        PropertyValueModel<Boolean> enabledModel = this.buildTableEnabledModel();
        this.addLabel(container, JptJpaUiDetailsMessages.TABLE_CHOOSER_LABEL, enabledModel);
        this.addTableCombo((PropertyValueModel<SpecifiedTable>)subjectHolder, enabledModel, container);
        this.addLabel(container, JptJpaUiDetailsMessages.CATALOG_CHOOSER_LABEL, enabledModel);
        this.addCatalogCombo((PropertyValueModel<SpecifiedTable>)subjectHolder, enabledModel, container);
        this.addLabel(container, JptJpaUiDetailsMessages.SCHEMA_CHOOSER_LABEL, enabledModel);
        this.addSchemaCombo((PropertyValueModel<SpecifiedTable>)subjectHolder, enabledModel, container);
    }

    protected ModifiablePropertyValueModel<SpecifiedTable> buildTableHolder() {
        return new PropertyAspectAdapter<Entity, SpecifiedTable>(this.getSubjectHolder(), new String[]{"tableIsUndefined"}){

            protected SpecifiedTable buildValue_() {
                return ((Entity)this.subject).tableIsUndefined() ? null : ((Entity)this.subject).getTable();
            }
        };
    }

    protected PropertyValueModel<Boolean> buildTableEnabledModel() {
        return new PropertyAspectAdapter<Entity, Boolean>(this.getSubjectHolder(), new String[]{"specifiedTableIsAllowed"}){

            protected Boolean buildValue_() {
                return ((Entity)this.subject).specifiedTableIsAllowed();
            }
        };
    }

    private CatalogCombo<SpecifiedTable> addCatalogCombo(PropertyValueModel<SpecifiedTable> tableHolder, PropertyValueModel<Boolean> enabledModel, Composite container) {
        return new CatalogCombo<SpecifiedTable>((Pane)this, tableHolder, enabledModel, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultCatalog");
                propertyNames.add("specifiedCatalog");
            }

            protected String getDefaultValue() {
                return ((SpecifiedTable)this.getSubject()).getDefaultCatalog();
            }

            protected void setValue(String value) {
                ((SpecifiedTable)this.getSubject()).setSpecifiedCatalog(value);
            }

            protected String getValue() {
                return ((SpecifiedTable)this.getSubject()).getSpecifiedCatalog();
            }

            protected String getHelpId() {
                return JpaHelpContextIds.ENTITY_CATALOG;
            }

            public String toString() {
                return "TableComposite.catalogCombo";
            }
        };
    }

    private SchemaCombo<SpecifiedTable> addSchemaCombo(PropertyValueModel<SpecifiedTable> subjectHolder, PropertyValueModel<Boolean> enabledModel, Composite container) {
        return new SchemaCombo<SpecifiedTable>((Pane)this, subjectHolder, enabledModel, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultSchema");
                propertyNames.add("specifiedSchema");
                propertyNames.addAll(SCHEMA_PICK_LIST_PROPERTIES);
            }

            protected void propertyChanged(String propertyName) {
                if (SCHEMA_PICK_LIST_PROPERTIES.contains(propertyName)) {
                    this.repopulateComboBox();
                } else {
                    super.propertyChanged(propertyName);
                }
            }

            protected String getDefaultValue() {
                return ((SpecifiedTable)this.getSubject()).getDefaultSchema();
            }

            protected void setValue(String value) {
                ((SpecifiedTable)this.getSubject()).setSpecifiedSchema(value);
            }

            protected String getValue() {
                return ((SpecifiedTable)this.getSubject()).getSpecifiedSchema();
            }

            @Override
            protected SchemaContainer getDbSchemaContainer_() {
                return ((SpecifiedTable)this.getSubject()).getDbSchemaContainer();
            }

            protected String getHelpId() {
                return JpaHelpContextIds.ENTITY_SCHEMA;
            }

            public String toString() {
                return "TableComposite.schemaCombo";
            }
        };
    }

    private TableCombo<SpecifiedTable> addTableCombo(PropertyValueModel<SpecifiedTable> subjectHolder, PropertyValueModel<Boolean> enabledModel, Composite container) {
        return new TableCombo<SpecifiedTable>((Pane)this, subjectHolder, enabledModel, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("defaultName");
                propertyNames.add("specifiedName");
                propertyNames.addAll(TABLE_PICK_LIST_PROPERTIES);
            }

            protected void propertyChanged(String propertyName) {
                if (TABLE_PICK_LIST_PROPERTIES.contains(propertyName)) {
                    this.repopulateComboBox();
                } else {
                    super.propertyChanged(propertyName);
                }
            }

            protected String getDefaultValue() {
                return ((SpecifiedTable)this.getSubject()).getDefaultName();
            }

            protected void setValue(String value) {
                ((SpecifiedTable)this.getSubject()).setSpecifiedName(value);
            }

            protected String getValue() {
                return ((SpecifiedTable)this.getSubject()).getSpecifiedName();
            }

            @Override
            protected Schema getDbSchema_() {
                return ((SpecifiedTable)this.getSubject()).getDbSchema();
            }

            protected String getHelpId() {
                return JpaHelpContextIds.ENTITY_TABLE;
            }

            public String toString() {
                return "TableComposite.tableCombo";
            }
        };
    }
}

