/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.pagedesigner.utils.JSPUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SelectManyHelper {
    private static final Set<String> JSF_SELECT_TAGS;
    private static final Set<String> HTML_SELECT_TAGS;

    static {
        HashSet<String> tempSet = new HashSet<String>(4);
        tempSet.add("select");
        tempSet.add("optgroup");
        HTML_SELECT_TAGS = Collections.unmodifiableSet(tempSet);
        tempSet = new HashSet(8);
        tempSet.add("selectOneListbox");
        tempSet.add("selectOneMenu");
        tempSet.add("selectManyListbox");
        tempSet.add("selectManyMenu");
        tempSet.add("selectManyCheckbox");
        JSF_SELECT_TAGS = Collections.unmodifiableSet(tempSet);
    }

    public static Object[] getSelectOptions(Element node) {
        if (node == null) {
            return null;
        }
        IDOMModel xmlModel = null;
        if (node instanceof IDOMNode) {
            xmlModel = ((IDOMNode)node).getModel();
        }
        if (xmlModel == null) {
            return null;
        }
        String prefixNode = JSPUtil.getPrefix(xmlModel, "http://java.sun.com/jsf/html");
        if (prefixNode != null && node.getPrefix() != null && node.getPrefix().equals(prefixNode) && JSF_SELECT_TAGS.contains(node.getLocalName())) {
            String prefixItem = JSPUtil.getPrefix(xmlModel, "http://java.sun.com/jsf/core");
            ArrayList<Node> result = new ArrayList<Node>();
            NodeList items = node.getElementsByTagName(prefixItem + ":selectItem");
            int i = 0;
            int n = items.getLength();
            while (i < n) {
                result.add(items.item(i));
                ++i;
            }
            items = node.getElementsByTagName(prefixItem + ":selectItems");
            i = 0;
            n = items.getLength();
            while (i < n) {
                result.add(items.item(i));
                ++i;
            }
            return result.size() > 0 ? result.toArray(new Node[result.size()]) : null;
        }
        if (node.getPrefix() == null && HTML_SELECT_TAGS.contains(node.getNodeName().toLowerCase())) {
            ArrayList<Node> result = new ArrayList<Node>();
            NodeList options = node.getElementsByTagName("option");
            NodeList optionGroups = node.getElementsByTagName("optgroup");
            int i = 0;
            int n = options.getLength();
            while (i < n) {
                result.add(options.item(i));
                ++i;
            }
            i = 0;
            n = optionGroups.getLength();
            while (i < n) {
                result.add(optionGroups.item(i));
                ++i;
            }
            return result.toArray(new Node[result.size()]);
        }
        return null;
    }

    public static String[] getSelectOptionsString(Element node) {
        if (node == null) {
            return null;
        }
        Object[] options = SelectManyHelper.getSelectOptions(node);
        if (options == null || options[0] == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        int n = options.length;
        while (i < n) {
            if (options[i] instanceof Element) {
                Element element = (Element)options[i];
                Attr value = null;
                if (element.getNodeName().indexOf("selectItems") >= 0) {
                    value = element.getAttributeNode("value");
                } else if (element.getNodeName().indexOf("selectItem") >= 0) {
                    value = element.getAttributeNode("itemLabel");
                }
                if (value != null) {
                    result.add(value.getNodeValue());
                }
            }
            ++i;
        }
        return result.toArray(new String[0]);
    }

    public static boolean hasSelectOptions(Element node) {
        if (node == null) {
            return false;
        }
        String uri = CMUtil.getElementNamespaceURI((Element)node);
        if ("http://java.sun.com/jsf/html".equals(uri) && JSF_SELECT_TAGS.contains(node.getLocalName())) {
            IDOMModel model = ((IDOMElement)node).getModel();
            String jsfcorePrefix = JSPUtil.getPrefix(model, "http://java.sun.com/jsf/core");
            if (jsfcorePrefix != null) {
                NodeList nl = node.getElementsByTagName(jsfcorePrefix + ":selectItem");
                NodeList nl1 = node.getElementsByTagName(jsfcorePrefix + ":selectItems");
                return nl.getLength() > 0 || nl1.getLength() > 0;
            }
            return false;
        }
        if ("html".equals(uri) && HTML_SELECT_TAGS.contains(node.getNodeName().toLowerCase())) {
            NodeList nl = node.getElementsByTagName("option");
            NodeList nl1 = node.getElementsByTagName("optgroup");
            return nl.getLength() > 0 || nl1.getLength() > 0;
        }
        return false;
    }

    public static boolean supportSections(Element node) {
        String uri = CMUtil.getElementNamespaceURI((Element)node);
        if ("http://java.sun.com/jsf/html".equals(uri)) {
            return JSF_SELECT_TAGS.contains(node.getLocalName());
        }
        if ("html".equals(uri)) {
            return HTML_SELECT_TAGS.contains(node.getNodeName().toLowerCase());
        }
        return false;
    }
}

