/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.tests.documentation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.ui.JSdocContentAccess;

public class DocumentationTest
extends TestCase {
    private String fContents1 = "/*\n * Attempt content assist on each function, verify that the proposal shows up, that\n * camel case CA works, the the propsoal looks correct, the proposal info is displayed,\n * that occurance support works, that F3 works, that hover help is displayed, and that\n * the function is correctly displayed in the outline.\n * \n * Also test out local functions, check functions that mask global functions. Try out\n * F3 and occurance support on function calls that have different parameter numbers than\n * the declared function.\n */\n\nfunction zooKeeper() {\n\t\n}\n\n/**\n * Some doc about zooKeeper1, can you see it?\n */\nfunction zooKeeper1() {\n\t\n}\n\nfunction zooKeeper2() {\n\treturn \"zoo\";\n}\n\n/**\n * \n * @returns {Boolean}\n */\nfunction zooKeeper3() {\n\treturn a;\n}\n\nfunction zooKeeper4(a, b) {\n\t\n}\n\n/**\n * Some doc about zooKeeper5\n * \n * @param {String} a\n * @param {Number} b\n */\nfunction zooKeeper5(a, b) {\n}\n\nfunction zooKeeper6(a) {\n\treturn true;\n}\n\n/**\n * hi\n * @param {Date} a\n * @returns {Date}\n */\nfunction zooKeeper7(a) {\n\treturn a;\n}\n\nzooKeeper();\nzooKeeper(1);\nzooKeeper1();\nzooKeeper2();\nzooKeeper3();\nzooKeeper4(1, 3);\nzooKeeper5(\"hi\", 3);\nzooKeeper6(1);\nzooKeeper7(new Date());\nzooKeeper7();\n\nfunction local1() {\n\t/**\n\t * hi\n\t */\n\tfunction zooKeeper7() {}\n\tfunction zooKeeper8(a) {}\n\t\n\tzooKeeper7();\n}\n";

    public static Test suite() {
        TestSuite ts = new TestSuite(DocumentationTest.class);
        return ts;
    }

    public DocumentationTest(String testName) {
        super(testName);
    }

    private void assertDocContainsString(IJavaScriptElement element, String s) throws JavaScriptModelException, IOException {
        Reader reader = JSdocContentAccess.getContentReader((IJavaScriptElement)element, (boolean)true);
        StringBuffer doc = new StringBuffer();
        if (reader != null) {
            char[] buf = new char[200];
            int read = 0;
            while ((read = reader.read(buf)) > 0) {
                doc.append(buf, 0, read);
            }
            reader.close();
        }
        DocumentationTest.assertTrue((String)"doc doesn't contain content we were looking for", (doc.toString().indexOf(s) >= 0 ? 1 : 0) != 0);
    }

    private IJavaScriptUnit getUnit(String string) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("DocumentationTest_" + this.getName());
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription("SelectionTest3_" + this.getName());
        description.setNatureIds(new String[]{"org.eclipse.wst.jsdt.core.jsNature"});
        project.create(description, null);
        project.open(null);
        IFile file = project.getFile("testfile.js");
        file.create((InputStream)new ByteArrayInputStream(string.getBytes()), true, null);
        return (IJavaScriptUnit)JavaScriptCore.create((IFile)file);
    }

    public void test01() throws Exception {
        IJavaScriptUnit unit = this.getUnit(this.fContents1);
        int offset = this.fContents1.indexOf("zooKeeper1();\n");
        IJavaScriptElement[] selected = unit.codeSelect(offset, 10);
        DocumentationTest.assertEquals((String)"unexpected number of elements", (int)1, (int)selected.length);
        DocumentationTest.assertEquals((String)"unexpected element", (String)"zooKeeper1", (String)selected[0].getElementName());
        DocumentationTest.assertEquals((String)"unexpected element type", (int)9, (int)selected[0].getElementType());
        this.assertDocContainsString(selected[0], "doc about zooKeeper");
    }

    public void test02() throws Exception {
        IJavaScriptUnit unit = this.getUnit(this.fContents1);
        int offset = this.fContents1.indexOf("zooKeeper3();\n");
        IJavaScriptElement[] selected = unit.codeSelect(offset, 10);
        DocumentationTest.assertEquals((String)"unexpected number of elements", (int)1, (int)selected.length);
        DocumentationTest.assertEquals((String)"unexpected element", (String)"zooKeeper3", (String)selected[0].getElementName());
        DocumentationTest.assertEquals((String)"unexpected element type", (int)9, (int)selected[0].getElementType());
        this.assertDocContainsString(selected[0], "Boolean");
    }

    public void test03() throws Exception {
        IJavaScriptUnit unit = this.getUnit(this.fContents1);
        int offset = this.fContents1.indexOf("zooKeeper5(\"hi");
        IJavaScriptElement[] selected = unit.codeSelect(offset, 10);
        DocumentationTest.assertEquals((String)"unexpected number of elements", (int)1, (int)selected.length);
        DocumentationTest.assertEquals((String)"unexpected element", (String)"zooKeeper5", (String)selected[0].getElementName());
        DocumentationTest.assertEquals((String)"unexpected element type", (int)9, (int)selected[0].getElementType());
        this.assertDocContainsString(selected[0], "Some doc about zooKeeper5");
    }

    public void test04() throws Exception {
        IJavaScriptUnit unit = this.getUnit(this.fContents1);
        int offset = this.fContents1.indexOf("zooKeeper7(");
        IJavaScriptElement[] selected = unit.codeSelect(offset, 10);
        DocumentationTest.assertEquals((String)"unexpected number of elements", (int)1, (int)selected.length);
        DocumentationTest.assertEquals((String)"unexpected element", (String)"zooKeeper7", (String)selected[0].getElementName());
        DocumentationTest.assertEquals((String)"unexpected element type", (int)9, (int)selected[0].getElementType());
        this.assertDocContainsString(selected[0], "Date");
    }
}

