/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.snippets.core.ISnippetCategory;
import org.eclipse.wst.common.snippets.core.ISnippetsEntry;
import org.eclipse.wst.common.snippets.internal.IEntryChangeListener;
import org.eclipse.wst.common.snippets.internal.ISnippetManager;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.SnippetDefinitions;
import org.eclipse.wst.common.snippets.internal.SnippetsPlugin;
import org.eclipse.wst.common.snippets.internal.palette.ModelFactoryForPlugins;
import org.eclipse.wst.common.snippets.internal.palette.ModelFactoryForUser;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteDrawer;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItem;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteRoot;
import org.eclipse.wst.common.snippets.internal.palette.UserModelDumper;
import org.eclipse.wst.common.snippets.internal.palette.WorkspaceModelDumper;
import org.eclipse.wst.common.snippets.internal.team.CategoryFileInfo;
import org.eclipse.wst.common.snippets.internal.util.CommonXML;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SnippetManager
implements ISnippetManager,
PropertyChangeListener {
    private static final String STORAGE_FOLDER_NAME = "storage";
    private static File hiddenStateFile = new File("/hidden.xml");
    private static SnippetManager instance = null;
    private SnippetDefinitions definitions = null;
    protected IEntryChangeListener[] fListeners;
    private SnippetPaletteRoot fRoot;

    public static synchronized SnippetManager getInstance() {
        if (instance == null) {
            instance = new SnippetManager();
            try {
                hiddenStateFile = SnippetsPlugin.getDefault().getStateLocation().append("hidden.xml").toFile();
            }
            catch (Exception exception) {
                hiddenStateFile = new File("/hidden.xml");
            }
            try {
                File storageLocation = SnippetsPlugin.getDefault().getStateLocation().append(STORAGE_FOLDER_NAME).toFile();
                storageLocation.mkdirs();
            }
            catch (SecurityException e) {
                Logger.logException(e);
            }
        }
        return instance;
    }

    @Override
    public void addEntryChangeListener(IEntryChangeListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new IEntryChangeListener[]{listener};
        } else {
            IEntryChangeListener[] newListeners = new IEntryChangeListener[this.fListeners.length + 1];
            newListeners[0] = listener;
            System.arraycopy(this.fListeners, 0, newListeners, 1, this.fListeners.length);
            this.fListeners = newListeners;
        }
    }

    protected ISnippetsEntry findEntry(SnippetDefinitions defs, String id) {
        List<ISnippetCategory> categories = defs.getCategories();
        ISnippetsEntry match = null;
        int i = 0;
        while (match == null && i < categories.size()) {
            SnippetPaletteDrawer category = (SnippetPaletteDrawer)categories.get(i);
            if (category.getId().equals(id)) {
                match = category;
            } else {
                int j = 0;
                while (match == null && j < category.getChildren().size()) {
                    SnippetPaletteItem item = (SnippetPaletteItem)category.getChildren().get(j);
                    if (item.getId().equals(id)) {
                        match = item;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return match;
    }

    @Override
    public ISnippetsEntry findEntry(String id) {
        return this.findEntry(this.getDefinitions(), id);
    }

    private void fireModelChanged(SnippetDefinitions oldDefinitions, SnippetDefinitions newDefinitions) {
        if (this.fListeners == null) {
            return;
        }
        int i = 0;
        while (i < this.fListeners.length) {
            this.fListeners[i].modelChanged(oldDefinitions, newDefinitions);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SnippetDefinitions getDefinitions() {
        if (this.definitions == null) {
            SnippetManager snippetManager = SnippetManager.getInstance();
            synchronized (snippetManager) {
                this.definitions = this.loadDefinitions();
                if (this.fRoot == null) {
                    this.fRoot = new SnippetPaletteRoot(this.definitions);
                }
                String[] hiddenIDs = this.loadHiddenState();
                int i = 0;
                while (i < hiddenIDs.length) {
                    ISnippetsEntry entry = this.findEntry(this.definitions, hiddenIDs[i]);
                    if (entry != null) {
                        if (entry instanceof SnippetPaletteItem) {
                            ((SnippetPaletteItem)entry).setVisible(false);
                        }
                        if (entry instanceof SnippetPaletteDrawer) {
                            ((SnippetPaletteDrawer)entry).setVisible(false);
                        }
                    }
                    ++i;
                }
            }
        }
        return this.definitions;
    }

    public IEntryChangeListener[] getListeners() {
        return this.fListeners;
    }

    public SnippetPaletteRoot getPaletteRoot() {
        if (this.fRoot == null) {
            this.fRoot = new SnippetPaletteRoot(this.getDefinitions());
        }
        return this.fRoot;
    }

    protected SnippetDefinitions loadDefinitions() {
        SnippetPaletteDrawer category;
        SnippetDefinitions defs = new SnippetDefinitions();
        SnippetDefinitions pluginDefs = ModelFactoryForPlugins.getInstance().loadCurrent();
        if (Logger.DEBUG_DEFINITION_PERSISTENCE) {
            System.out.println("SnippetManager loaded " + pluginDefs.getCategories().size() + " categories from plug-ins");
        }
        SnippetDefinitions userDefs = ModelFactoryForUser.getInstance().loadCurrent();
        if (Logger.DEBUG_DEFINITION_PERSISTENCE) {
            System.out.println("SnippetManager loaded " + userDefs.getCategories().size() + " records for categories from user.xml");
        }
        defs.getCategories().addAll(userDefs.getCategories());
        int i = 0;
        while (i < pluginDefs.getCategories().size()) {
            category = (SnippetPaletteDrawer)pluginDefs.getCategories().get(i);
            String id = category.getId();
            ISnippetsEntry existingEntry = this.findEntry(defs, id);
            int existingIndex = defs.getCategories().indexOf(existingEntry);
            if (existingEntry != null && existingIndex > -1) {
                category.setFilters(existingEntry.getFilters());
                defs.getCategories().set(existingIndex, category);
            } else {
                defs.getCategories().add(category);
            }
            ++i;
        }
        Iterator<ISnippetCategory> it = defs.getCategories().iterator();
        while (it.hasNext()) {
            category = (SnippetPaletteDrawer)it.next();
            if (category.getSourceType() == "USER" || !category.getChildren().isEmpty()) continue;
            it.remove();
        }
        return defs;
    }

    protected String[] loadHiddenState() {
        Document document = null;
        String[] results = new String[]{};
        try {
            DocumentBuilder builder = CommonXML.getDocumentBuilder();
            if (builder != null) {
                document = builder.parse(hiddenStateFile);
            } else {
                Logger.log(4, "SnippetManager couldn't obtain a DocumentBuilder");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            document = null;
        }
        catch (IOException e) {
            Logger.logException("SnippetManager could not load hidden state", e);
        }
        catch (SAXException e) {
            Logger.logException("SnippetManager could not load hidden state", e);
        }
        if (document != null) {
            ArrayList<String> names = new ArrayList<String>(0);
            Element hidden = document.getDocumentElement();
            if (hidden != null) {
                NodeList list = hidden.getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    Node childNode = list.item(i);
                    if (childNode.getNodeType() == 1 && childNode.getNodeName().equals("hide")) {
                        Element entry = (Element)childNode;
                        String id = null;
                        if (entry.hasAttribute("category")) {
                            id = entry.getAttribute("category");
                        } else if (entry.hasAttribute("item")) {
                            id = entry.getAttribute("item");
                        }
                        if (id != null && id.length() > 0) {
                            names.add(id);
                        }
                    }
                    ++i;
                }
                results = names.toArray(results);
            }
        }
        if (Logger.DEBUG_DEFINITION_PERSISTENCE) {
            System.out.println("SnippetManager remembered " + results.length + " hidden categories");
        }
        return results;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("Children Changed")) {
            SnippetDefinitions oldDefinitions = this.getDefinitions();
            this.definitions = new SnippetDefinitions();
            this.definitions.setCategories((List)evt.getNewValue());
            this.fireModelChanged(oldDefinitions, this.definitions);
        }
    }

    @Override
    public void removeEntryChangeListener(IEntryChangeListener listener) {
        if (this.fListeners.length == 1) {
            this.fListeners = null;
        } else {
            ArrayList<IEntryChangeListener> newListenersList = new ArrayList<IEntryChangeListener>(Arrays.asList(this.fListeners));
            newListenersList.remove(listener);
            IEntryChangeListener[] newListeners = new IEntryChangeListener[newListenersList.size() - 1];
            newListeners = newListenersList.toArray(newListeners);
            this.fListeners = newListeners;
        }
    }

    public void resetDefinitions() {
        SnippetDefinitions oldDefinitions = this.definitions;
        this.definitions = null;
        if (this.fRoot != null) {
            this.fRoot.setDefinitions(this.getDefinitions());
        }
        this.fireModelChanged(oldDefinitions, this.getDefinitions());
    }

    public synchronized void saveDefinitions() {
        if (this.definitions == null) {
            return;
        }
        this.saveHiddenState();
        if (Logger.DEBUG_DEFINITION_PERSISTENCE) {
            System.out.println("SnippetManager saved hidden state");
        }
        UserModelDumper.getInstance().write(this.getDefinitions());
        if (Logger.DEBUG_DEFINITION_PERSISTENCE) {
            System.out.println("SnippetManager wrote user records");
        }
        List<ISnippetCategory> categories = this.getDefinitions().getCategories();
        ArrayList<CategoryFileInfo> workspaceCategories = new ArrayList<CategoryFileInfo>();
        int i = 0;
        while (i < categories.size()) {
            CategoryFileInfo info;
            ISnippetCategory category = categories.get(i);
            if (category.getSourceType() == "WORKSPACE" && (info = (CategoryFileInfo)category.getSourceDescriptor()) != null && info.getFile() != null) {
                workspaceCategories.add(info);
            }
            ++i;
        }
        i = 0;
        while (i < workspaceCategories.size()) {
            CategoryFileInfo info = (CategoryFileInfo)workspaceCategories.get(i);
            try {
                if (Logger.DEBUG_DEFINITION_PERSISTENCE) {
                    System.out.println("save workspace category: " + info.getCategory().getLabel());
                }
                WorkspaceModelDumper.getInstance().write(info.getCategory(), info.getFile());
            }
            catch (Exception e) {
                Logger.logException(e);
            }
            ++i;
        }
    }

    protected void saveHiddenState() {
        Document document = CommonXML.getDocumentBuilder().getDOMImplementation().createDocument(null, "hidden", null);
        try {
            Element hidden;
            FileOutputStream ostream = new FileOutputStream(hiddenStateFile);
            ArrayList<String> categoryIDs = new ArrayList<String>(0);
            ArrayList<String> itemIDs = new ArrayList<String>(0);
            int i = 0;
            while (i < this.getDefinitions().getCategories().size()) {
                SnippetPaletteDrawer category = (SnippetPaletteDrawer)this.getDefinitions().getCategories().get(i);
                if (!category.isVisible() && !categoryIDs.contains(category.getId())) {
                    categoryIDs.add(category.getId());
                }
                int j = 0;
                while (j < category.getChildren().size()) {
                    SnippetPaletteItem entry = (SnippetPaletteItem)category.getChildren().get(j);
                    if (!entry.isVisible() && !itemIDs.contains(entry.getId())) {
                        itemIDs.add(entry.getId());
                    }
                    ++j;
                }
                ++i;
            }
            int j = 0;
            while (j < categoryIDs.size()) {
                hidden = document.createElement("hide");
                hidden.setAttribute("category", ((String)categoryIDs.get(j)).toString());
                document.getDocumentElement().appendChild(hidden);
                ++j;
            }
            j = 0;
            while (j < itemIDs.size()) {
                hidden = document.createElement("hide");
                hidden.setAttribute("item", ((String)itemIDs.get(j)).toString());
                document.getDocumentElement().appendChild(hidden);
                ++j;
            }
            CommonXML.serialize(document, ostream);
            ostream.close();
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    public IPath getStorageLocation(String id) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.wst.common.snippets");
        return Platform.getStateLocation((Bundle)bundle).append(STORAGE_FOLDER_NAME).addTrailingSeparator().append(id);
    }

    public IStatus moveFilesInStorageFolder(IPath snippetStorage, IPath[] pathList, IProject project) {
        File storageFolder = new File(snippetStorage.toOSString());
        if (!storageFolder.exists() && !storageFolder.mkdirs()) {
            return this.createErrorStatus("Could not create snippet storage folder.", null);
        }
        int i = 0;
        while (i < pathList.length) {
            IFile file = project.getFile(pathList[i]);
            IPath destPath = snippetStorage.append(pathList[i]);
            File destination = new File(destPath.toOSString());
            if (!destination.getParentFile().exists() && !destination.getParentFile().mkdirs()) {
                return this.createErrorStatus("Could not create snippet storage folder.", null);
            }
            try {
                this.copy(file, destination);
            }
            catch (FileNotFoundException e) {
                return this.createErrorStatus(e.getLocalizedMessage(), e);
            }
            catch (IOException e) {
                return this.createErrorStatus(e.getLocalizedMessage(), e);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    public IStatus moveFilesInWorkspace(File[] fileList, IProject target, IPath storagePath) {
        int i = 0;
        while (i < fileList.length) {
            String fileRelativePath = fileList[i].getAbsolutePath().substring(storagePath.toOSString().length());
            IFile ifile = target.getFile((IPath)new Path(fileRelativePath));
            try {
                ifile.create((InputStream)new FileInputStream(fileList[i]), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (FileNotFoundException e) {
                return this.createErrorStatus(e.getLocalizedMessage(), e);
            }
            catch (CoreException e) {
                return this.createErrorStatus(e.getLocalizedMessage(), (Exception)((Object)e));
            }
            ++i;
        }
        return Status.OK_STATUS;
    }

    private void copy(IFile source, File destination) throws FileNotFoundException, IOException, CoreException {
        this.copy(source.getContents(), new FileOutputStream(destination));
    }

    private void copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        try {
            int n = in.read(buffer);
            while (n > 0) {
                out.write(buffer, 0, n);
                n = in.read(buffer);
            }
        }
        finally {
            in.close();
            out.close();
        }
    }

    private IStatus createErrorStatus(String msg, Exception e) {
        return new Status(4, "org.eclipse.wst.common.snippets", msg, (Throwable)e);
    }
}

