/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.base;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.IJSFAppConfigManager;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.JSFAppConfigManagerFactory;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.designtime.resolver.AbstractStructuredDocumentSymbolResolverFactory;
import org.eclipse.jst.jsf.designtime.resolver.CachingSymbolContextResolver;
import org.eclipse.jst.jsf.designtime.resolver.IStructuredDocumentSymbolResolverFactory;
import org.eclipse.jst.jsf.designtime.resolver.ISymbolContextResolver;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.test.util.ConfigurableTestCase;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.jst.jsf.validation.el.tests.ELValidationTestPlugin;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public abstract class BaseTestCase
extends ConfigurableTestCase {
    public static final String PROXY_SETTING_HOST = "proxySettings_Host";
    public static final String PROXY_SETTING_PORT = "proxySettings_Port";
    public static final String JSF_FACET_VERSION = "jsfFacetVersion";
    private final JSFVersion _defaultJSFVersion;
    protected final IStructuredDocumentSymbolResolverFactory _symbolResolverFactory = new MySymbolResolverFactory();
    protected WebProjectTestEnvironment _testEnv;
    protected JDTTestEnvironment _jdtTestEnv;
    private MyConfiguration _configuration;

    public BaseTestCase(JSFVersion defaultJSFVersion) {
        this._defaultJSFVersion = defaultJSFVersion;
    }

    public BaseTestCase(String name, JSFVersion defaultJSFVersion) {
        super(name);
        this._defaultJSFVersion = defaultJSFVersion;
    }

    protected void doStandaloneSetup() {
        super.doStandaloneSetup();
        this._configuration = new MyConfiguration("www-proxy.uk.oracle.com", "80", this._defaultJSFVersion);
    }

    protected void doTestSuiteSetup() {
        super.doTestSuiteSetup();
        this._configuration = new MyConfiguration(this._testConfiguration);
    }

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        if (this._configuration.isProxyEnabled()) {
            JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)this._configuration.getProxyHostName(), (String)this._configuration.getProxyPort());
        }
        String webProjVersion = this._configuration.getJsfVersion() == JSFVersion.V1_0 || this._configuration.getJsfVersion() == JSFVersion.V1_1 ? "2.4" : "2.5";
        this._testEnv = new WebProjectTestEnvironment("ELValidationTest_" + ((Object)((Object)this)).getClass().getName() + "_" + this.getName() + "_" + String.valueOf(this._configuration.getJsfVersion()), JavaFacet.VERSION_1_5, ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion(webProjVersion));
        this._testEnv.createProject(false);
        BaseTestCase.assertNotNull((Object)this._testEnv);
        BaseTestCase.assertNotNull((Object)this._testEnv.getTestProject());
        BaseTestCase.assertTrue((boolean)this._testEnv.getTestProject().isAccessible());
        this.configureJSFEnvironment();
        this._jdtTestEnv = new JDTTestEnvironment((ProjectTestEnvironment)this._testEnv);
        this.configureJDTTestEnvironment(this._jdtTestEnv);
    }

    protected abstract JSFFacetedTestEnvironment configureJSFEnvironment() throws Exception;

    protected void configureJDTTestEnvironment(JDTTestEnvironment jdtTestEnv) throws Exception {
        TestFileResource resource = new TestFileResource();
        resource.load(ELValidationTestPlugin.getDefault().getBundle(), "/testdata/classes/MyEnum1.java.data");
        jdtTestEnv.addSourceFile("src", "beans", "MyEnum1", resource.toString());
        resource = new TestFileResource();
        resource.load(ELValidationTestPlugin.getDefault().getBundle(), "/testdata/classes/MyEnum2.java.data");
        jdtTestEnv.addSourceFile("src", "beans", "MyEnum2", resource.toString());
        resource = new TestFileResource();
        resource.load(ELValidationTestPlugin.getDefault().getBundle(), "/testdata/classes/MyBean.java.data");
        jdtTestEnv.addSourceFile("src", "beans", "MyBean", resource.toString());
        resource = new TestFileResource();
        resource.load(ELValidationTestPlugin.getDefault().getBundle(), "/testdata/classes/MapBean.java.data");
        jdtTestEnv.addSourceFile("src", "beans", "MapBean", resource.toString());
        resource = new TestFileResource();
        resource.load(ELValidationTestPlugin.getDefault().getBundle(), "/testdata/classes/MyBeanSettable.java.data");
        jdtTestEnv.addSourceFile("src", "beans", "MyBeanSettable", resource.toString());
        resource = new TestFileResource();
        resource.load(ELValidationTestPlugin.getDefault().getBundle(), "/testdata/classes/MyBeanSubClass.java.data");
        jdtTestEnv.addSourceFile("src", "beans", "MyBeanSubClass", resource.toString());
        resource = new TestFileResource();
        resource.load(ELValidationTestPlugin.getDefault().getBundle(), "/testdata/classes/BeanWithMapProperties.java.data");
        jdtTestEnv.addSourceFile("src", "beans", "BeanWithMapProperties", resource.toString());
        resource = new TestFileResource();
        resource.load(ELValidationTestPlugin.getDefault().getBundle(), "/testdata/classes/BeanWithListProperties.java.data");
        jdtTestEnv.addSourceFile("src", "beans", "BeanWithListProperties", resource.toString());
        resource = new TestFileResource();
        resource.load(ELValidationTestPlugin.getDefault().getBundle(), "/testdata/classes/ListBean.java.data");
        jdtTestEnv.addSourceFile("src", "beans", "ListBean", resource.toString());
        resource = new TestFileResource();
        resource.load(ELValidationTestPlugin.getDefault().getBundle(), "/testdata/classes/Bundle.properties.data");
        jdtTestEnv.addResourceFile("src", (InputStream)new ByteArrayInputStream(resource.toBytes()), "beans", "Bundle.properties");
    }

    protected void tearDown() throws Exception {
        this._testEnv.getTestProject().close(null);
    }

    public void testSanity() {
        IJavaProject javaProject = this._jdtTestEnv.getJavaProject();
        BaseTestCase.assertNotNull((Object)javaProject);
        try {
            IType type = javaProject.findType("beans.MyBean");
            BaseTestCase.assertNotNull((Object)type);
            type = javaProject.findType("beans.MapBean");
            BaseTestCase.assertNotNull((Object)type);
            type = javaProject.findType("beans.MyBeanSettable");
            BaseTestCase.assertNotNull((Object)type);
            type = javaProject.findType("beans.MyBeanSubClass");
            BaseTestCase.assertNotNull((Object)type);
            type = javaProject.findType("beans.BeanWithMapProperties");
            BaseTestCase.assertNotNull((Object)type);
            type = javaProject.findType("beans.BeanWithListProperties");
            BaseTestCase.assertNotNull((Object)type);
            type = javaProject.findType("beans.ListBean");
            BaseTestCase.assertNotNull((Object)type);
            IPackageFragmentRoot srcRoot = this._jdtTestEnv.getPackageFragmentRoot("src");
            BaseTestCase.assertTrue((boolean)srcRoot.exists());
            IPackageFragment frag = srcRoot.getPackageFragment("beans");
            BaseTestCase.assertTrue((boolean)frag.exists());
            IFolder res = (IFolder)frag.getResource();
            IFile bundleFile = res.getFile("Bundle.properties");
            BaseTestCase.assertTrue((boolean)bundleFile.exists());
            IJSFAppConfigManager cfgManager = JSFAppConfigManagerFactory.getJSFAppConfigManagerInstance((IProject)this._jdtTestEnv.getProjectEnvironment().getTestProject());
            BaseTestCase.assertNotNull((Object)cfgManager);
            List mbeans = cfgManager.getManagedBeans();
            HashMap<String, ManagedBeanType> nameTest = new HashMap<String, ManagedBeanType>();
            for (ManagedBeanType mbean : mbeans) {
                nameTest.put(mbean.getManagedBeanName().getTextContent(), mbean);
            }
            BaseTestCase.assertTrue((boolean)nameTest.containsKey("myBean"));
            BaseTestCase.assertTrue((boolean)nameTest.containsKey("mapBean"));
            BaseTestCase.assertTrue((boolean)nameTest.containsKey("myBeanSettable"));
            BaseTestCase.assertTrue((boolean)nameTest.containsKey("myBeanSubClass"));
            BaseTestCase.assertTrue((boolean)nameTest.containsKey("beanWithMapProperties"));
            BaseTestCase.assertTrue((boolean)nameTest.containsKey("beanWithListProperties"));
            BaseTestCase.assertTrue((boolean)nameTest.containsKey("listBean"));
        }
        catch (JavaModelException jme) {
            BaseTestCase.assertTrue((String)("JDT error: " + jme.getLocalizedMessage()), (boolean)false);
        }
        catch (CoreException ce) {
            BaseTestCase.assertTrue((String)("Problem loading bundle: " + ce.getLocalizedMessage()), (boolean)false);
        }
    }

    private static class MyConfiguration {
        private final String _proxyHostName;
        private final String _proxyPort;
        private final JSFVersion _jsfVersion;

        MyConfiguration(String proxyHostName, String proxyPort, JSFVersion jsfVersion) {
            this._proxyHostName = proxyHostName;
            this._proxyPort = proxyPort;
            this._jsfVersion = jsfVersion;
        }

        MyConfiguration(ConfigurableTestCase.TestConfiguration configuration) {
            this._proxyHostName = (String)configuration.get((Object)BaseTestCase.PROXY_SETTING_HOST);
            this._proxyPort = (String)configuration.get((Object)BaseTestCase.PROXY_SETTING_PORT);
            this._jsfVersion = JSFVersion.valueOfString((String)((String)configuration.get((Object)BaseTestCase.JSF_FACET_VERSION)));
        }

        public boolean isProxyEnabled() {
            return this._proxyHostName != null && this._proxyPort != null;
        }

        public String getProxyHostName() {
            return this._proxyHostName;
        }

        public String getProxyPort() {
            return this._proxyPort;
        }

        public JSFVersion getJsfVersion() {
            return this._jsfVersion;
        }
    }

    private static class MySymbolResolverFactory
    extends AbstractStructuredDocumentSymbolResolverFactory {
        private ISymbolContextResolver _resolver;

        private MySymbolResolverFactory() {
        }

        public ISymbolContextResolver getSymbolContextResolver(IModelContext context) {
            if (this._resolver == null) {
                this._resolver = new CachingSymbolContextResolver((IStructuredDocumentContext)context);
            } else if (!this._resolver.hasSameResolution(context)) {
                this._resolver = new CachingSymbolContextResolver((IStructuredDocumentContext)context);
            }
            return this._resolver;
        }
    }
}

