/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.relations;

import java.util.Hashtable;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;

public abstract class HasReferanceRelation {
    protected static final String SEPARATOR = ";hasReference;";
    protected PersistentType embeddingEntity;
    protected PersistentType embeddable;
    public static final Hashtable<HasReferenceType, String> relTypeToIdPart = new Hashtable();
    private PersistentAttribute embeddedAnnotatedAttribute;

    static {
        relTypeToIdPart.put(HasReferenceType.SINGLE, "1-1;");
        relTypeToIdPart.put(HasReferenceType.COLLECTION, "1-N;");
    }

    public HasReferanceRelation(PersistentType embeddingEntity, PersistentType embeddable) {
        this.embeddingEntity = embeddingEntity;
        this.embeddable = embeddable;
    }

    public HasReferanceRelation(IJPAEditorFeatureProvider fp, Connection conn) {
        Anchor start = conn.getStart();
        Anchor end = conn.getEnd();
        Object startObj = fp.getBusinessObjectForPictogramElement((PictogramElement)((ContainerShape)start.eContainer()));
        Object endObj = fp.getBusinessObjectForPictogramElement((PictogramElement)((ContainerShape)end.eContainer()));
        if (endObj == null || startObj == null) {
            throw new NullPointerException("Some of the connection ends is null");
        }
        if (!(endObj instanceof PersistentType) || !(startObj instanceof PersistentType)) {
            throw new IllegalArgumentException();
        }
        this.embeddingEntity = (PersistentType)startObj;
        this.embeddable = (PersistentType)endObj;
    }

    public PersistentType getEmbeddable() {
        return this.embeddable;
    }

    public PersistentType getEmbeddingEntity() {
        return this.embeddingEntity;
    }

    public String getId() {
        return HasReferanceRelation.generateId(this.embeddingEntity, this.embeddable, this.embeddedAnnotatedAttribute.getName(), this.getReferenceType());
    }

    public static String generateId(PersistentType startJpt, PersistentType endJpt, String embeddedAttributeName, HasReferenceType relType) {
        return "has_reference_relation:" + startJpt.getName() + SEPARATOR + relTypeToIdPart.get((Object)relType) + endJpt.getName() + "-" + embeddedAttributeName;
    }

    public boolean equals(Object otherRel) {
        if (!HasReferanceRelation.class.isInstance(otherRel)) {
            return false;
        }
        return this.getId().equals(((HasReferanceRelation)otherRel).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public abstract HasReferenceType getReferenceType();

    public PersistentAttribute getEmbeddedAnnotatedAttribute() {
        return this.embeddedAnnotatedAttribute;
    }

    public void setEmbeddedAnnotatedAttribute(PersistentAttribute embeddedAnnotatedAttribute) {
        this.embeddedAnnotatedAttribute = embeddedAnnotatedAttribute;
    }

    public static enum HasReferenceType {
        SINGLE,
        COLLECTION;

    }
}

