/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dtmanager.converter.operations.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jst.pagedesigner.dtmanager.converter.operations.AbstractTransformOperation;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IterateOverElementsOperation
extends AbstractTransformOperation {
    private static final String DEFAULT_PREFIX = "prefix";
    private String xPathExpression;
    private String nsURI;
    private String prefixedTokens;

    @Override
    public Element transform(Element srcElement, Element curElement) {
        if (this.getParameters().length < 1) {
            this.getLog().error("Warning.TransformOperationFactory.TooFewParameters", this.getTransformOperationID());
            return null;
        }
        this.xPathExpression = this.getParameters()[0];
        Assert.isNotNull((Object)this.xPathExpression);
        if (this.getParameters().length > 2) {
            this.nsURI = this.getParameters()[1];
            Assert.isNotNull((Object)this.nsURI);
            this.prefixedTokens = this.getParameters()[2];
            Assert.isNotNull((Object)this.prefixedTokens);
        }
        Element retElement = curElement;
        if (srcElement != null) {
            XPath xPath = XPathFactory.newInstance().newXPath();
            try {
                Object resultObject = xPath.evaluate(this.xPathExpression, srcElement, XPathConstants.NODESET);
                if (resultObject instanceof NodeList) {
                    NodeList nodes = (NodeList)resultObject;
                    if (nodes.getLength() < 1 && this.nsURI != null && this.prefixedTokens != null) {
                        xPath.setNamespaceContext(new NSContext(this.nsURI, DEFAULT_PREFIX));
                        resultObject = xPath.evaluate(this.getPrefixedExpression(DEFAULT_PREFIX), srcElement, XPathConstants.NODESET);
                        if (resultObject instanceof NodeList) {
                            nodes = (NodeList)resultObject;
                        }
                    }
                    int i = 0;
                    while (i < nodes.getLength()) {
                        Node node = nodes.item(i);
                        if (node instanceof Element) {
                            retElement = this.executeChildOperations((Element)node, retElement);
                        }
                        ++i;
                    }
                }
            }
            catch (XPathExpressionException xPathExpressionException) {}
        }
        return retElement;
    }

    private String getPrefixedExpression(String prefix) {
        String prefixedExpression = this.xPathExpression;
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.prefixedTokens, ",");
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        for (String token : tokens) {
            prefixedExpression = prefixedExpression.replace(token, prefix + ":" + token);
        }
        return prefixedExpression;
    }

    class NSContext
    implements NamespaceContext {
        private String _namespaceURI;
        private String _prefix;

        public NSContext(String namespaceURI, String prefix) {
            this._namespaceURI = namespaceURI;
            this._prefix = prefix;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this._namespaceURI;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return this._prefix;
        }

        public Iterator getPrefixes(String namespaceURI) {
            return Arrays.asList(this._prefix).iterator();
        }
    }
}

