/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.web.ui.internal;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.wst.project.facet.ProductManager;

public class WebDevelopmentPerspective
implements IPerspectiveFactory {
    public static final String ID = "org.eclipse.wst.web.ui.webDevPerspective";
    protected static final String TOP_LEFT_LOCATION = "topLeft";
    protected static final String BOTTOM_LEFT_LOCATION = "bottomLeft";
    protected static final String BOTTOM_RIGHT_LOCATION = "bottomRight";
    protected static final String TOP_RIGHT_LOCATION = "topRight";
    protected static final String BOTTOM_LOCATION = "bottom";
    private static final String ID_SERVER = "org.eclipse.wst.server.ui.ServersView";
    private static String ID_WST_SNIPPETS_VIEW = "org.eclipse.wst.common.snippets.internal.ui.SnippetsView";
    private static final String ID_TERMINAL_VIEW = "org.eclipse.terminal.view.ui.TerminalsView";
    private static final String ID_SEARCH_VIEW = "org.eclipse.search.ui.views.SearchView";
    private static final String ID_CONSOLE_VIEW = "org.eclipse.ui.console.ConsoleView";
    String fExplorerViewID = "org.eclipse.ui.navigator.ProjectExplorer";

    public WebDevelopmentPerspective() {
        String viewerID = ProductManager.getProperty((String)"idPerspectiveHierarchyView");
        if (viewerID != null && PlatformUI.getWorkbench().getViewRegistry().find(viewerID) != null) {
            this.fExplorerViewID = viewerID;
        }
    }

    private void addViewIfPresent(IFolderLayout layout, String viewID) {
        IViewDescriptor descriptor = PlatformUI.getWorkbench().getViewRegistry().find(viewID);
        if (descriptor != null) {
            layout.addView(viewID);
        } else {
            layout.addPlaceholder(viewID);
        }
    }

    public void createInitialLayout(IPageLayout layout) {
        String editorArea = layout.getEditorArea();
        IFolderLayout topLeft = layout.createFolder(TOP_LEFT_LOCATION, 1, 0.2f, editorArea);
        topLeft.addView(this.fExplorerViewID);
        topLeft.addPlaceholder(ID_SEARCH_VIEW);
        topLeft.addPlaceholder("org.eclipse.jdt.ui.PackagesView");
        IFolderLayout topRight = layout.createFolder(TOP_RIGHT_LOCATION, 2, 0.8f, editorArea);
        topRight.addView("org.eclipse.ui.views.ContentOutline");
        topRight.addPlaceholder("org.eclipse.ui.views.minimap.MinimapView");
        IFolderLayout bottom = layout.createFolder(BOTTOM_LOCATION, 4, 0.8f, editorArea);
        bottom.addView("org.eclipse.ui.views.ProblemView");
        this.addViewIfPresent(bottom, ID_SERVER);
        this.addViewIfPresent(bottom, ID_TERMINAL_VIEW);
        bottom.addView("org.eclipse.ui.views.PropertySheet");
        bottom.addPlaceholder(ID_WST_SNIPPETS_VIEW);
        bottom.addPlaceholder(ID_CONSOLE_VIEW);
        bottom.addPlaceholder("org.eclipse.ui.views.BookmarkView");
        bottom.addPlaceholder("org.eclipse.ui.views.TaskList");
        String allMarkersViewId = "org.eclipse.ui.views.AllMarkersView";
        bottom.addPlaceholder(allMarkersViewId);
        bottom.addPlaceholder("org.eclipse.ui.views.ProgressView");
        layout.addActionSet("org.eclipse.ui.NavigateActionSet");
        layout.addShowViewShortcut("org.eclipse.ui.views.BookmarkView");
        layout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
        layout.addShowViewShortcut("org.eclipse.ui.views.PropertySheet");
        layout.addShowViewShortcut("org.eclipse.ui.navigator.ProjectExplorer");
        layout.addShowViewShortcut(ID_WST_SNIPPETS_VIEW);
        layout.addShowViewShortcut("org.eclipse.ui.views.ProblemView");
        layout.addShowViewShortcut(ID_TERMINAL_VIEW);
        layout.addShowViewShortcut(ID_SEARCH_VIEW);
        layout.addShowViewShortcut(ID_CONSOLE_VIEW);
    }
}

