/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.jst.jsf.common.internal.managedobject.ObjectManager;
import org.eclipse.jst.jsf.common.internal.resource.ResourceSingletonObjectManager;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.eclipse.jst.jsf.designtime.internal.view.model.TagRegistryFactory;
import org.eclipse.jst.jsf.facelet.core.internal.FaceletCoreTraceOptions;
import org.eclipse.jst.jsf.facelet.core.internal.registry.FaceletTagRegistry;
import org.eclipse.jst.jsf.facelet.core.internal.registry.Messages;

public final class FaceletRegistryManager
extends ResourceSingletonObjectManager<FaceletTagRegistry, IProject> {
    private static FaceletRegistryManager INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FaceletRegistryManager getGlobalManager(IWorkspace workspace) {
        if (FaceletCoreTraceOptions.TRACE_REGISTRYMANAGER) {
            FaceletCoreTraceOptions.log("FaceletRegistryManager: Initializing FaceletRegistryManager singleton");
        }
        Class<FaceletRegistryManager> clazz = FaceletRegistryManager.class;
        synchronized (FaceletRegistryManager.class) {
            if (INSTANCE == null) {
                INSTANCE = new FaceletRegistryManager(workspace);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private FaceletRegistryManager(IWorkspace workspace) {
        super(workspace);
    }

    protected FaceletTagRegistry createNewInstance(IProject project) {
        if (FaceletCoreTraceOptions.TRACE_REGISTRYMANAGER) {
            FaceletCoreTraceOptions.log("FaceletRegistryManager: creating new instance for " + project.toString());
        }
        return new FaceletTagRegistry(project);
    }

    protected void runAfterGetInstance(IProject resource) {
        if (FaceletCoreTraceOptions.TRACE_REGISTRYMANAGER) {
            FaceletCoreTraceOptions.log("FaceletRegistryManager: Acquired instance for " + resource.toString());
        }
    }

    protected void runBeforeGetInstance(IProject resource) {
        if (FaceletCoreTraceOptions.TRACE_REGISTRYMANAGER) {
            FaceletCoreTraceOptions.log("FaceletRegistryManager: Getting registry for " + resource.toString());
        }
    }

    public static class MyRegistryFactory
    extends TagRegistryFactory {
        public ITagRegistry createTagRegistry(IProject project) throws TagRegistryFactory.TagRegistryFactoryException {
            try {
                return (ITagRegistry)FaceletRegistryManager.getGlobalManager(project.getWorkspace()).getInstance((IResource)project);
            }
            catch (ObjectManager.ManagedObjectException e) {
                throw new TagRegistryFactory.TagRegistryFactoryException((Throwable)e);
            }
        }

        public boolean isInstance(IProject project) {
            return FaceletRegistryManager.getGlobalManager(project.getWorkspace()).isInstance((IResource)project);
        }

        public String getDisplayName() {
            return Messages.FaceletRegistryManager_REGISTRY_FACTORY_DISPLAYNAME;
        }

        public boolean projectIsValid(IProject project) {
            if (project == null) {
                return false;
            }
            return JSFVersion.guessAtLeast((JSFVersion)JSFVersion.V2_0, (IProject)project);
        }
    }
}

