/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.wsdl.traversal;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLVisitor;
import org.w3c.dom.Element;

public class VisitorAdaptor
implements InvocationHandler {
    private static final Class[] visitorClass = new Class[]{WSDLVisitor.class};
    private static Class[] wsdl = new Class[]{Part.class, Service.class, Types.class, Operation.class, Input.class, Output.class, Fault.class, Binding.class, BindingOperation.class, BindingInput.class, BindingOutput.class, BindingFault.class, Import.class, Element.class, Message.class, Port.class, PortType.class, Definition.class, ExtensibilityElement.class, SOAPBinding.class, SOAPBody.class, SOAPHeader.class, SOAPHeaderFault.class, SOAPFault.class, SOAPOperation.class};
    private final Object visitor;
    private Map methods = new HashMap();

    private VisitorAdaptor(Object o) {
        this.visitor = o;
    }

    private void addMethodBinding(Method wsdlMethod, Method targetMethod) {
        this.methods.put(wsdlMethod, targetMethod);
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] params) {
        try {
            Method target = (Method)this.methods.get(m);
            return target.invoke(this.visitor, params);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private static String getName(Class c) {
        if (c != null) {
            String name = c.getName();
            return name.substring(name.lastIndexOf(".") + 1);
        }
        return null;
    }

    public static WSDLTraversal adapt(Object visitor) {
        WSDLTraversal traversal = new WSDLTraversal();
        if (visitor == null) {
            throw new IllegalArgumentException("Visitor object can not be NULL");
        }
        VisitorAdaptor adaptor = new VisitorAdaptor(visitor);
        Class<?> c = visitor.getClass();
        int i = 0;
        while (i < wsdl.length) {
            try {
                Method m = c.getMethod("visit", wsdl[i], Object.class, WSDLTraversalContext.class);
                adaptor.addMethodBinding(WSDLVisitor.class.getMethod("visit", wsdl[i], Object.class, WSDLTraversalContext.class), m);
                m = WSDLTraversal.class.getMethod("visit" + VisitorAdaptor.getName(wsdl[i]), Boolean.TYPE);
                m.invoke((Object)traversal, Boolean.TRUE);
            }
            catch (Exception exception) {}
            ++i;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        WSDLVisitor wsdlVisitor = (WSDLVisitor)Proxy.newProxyInstance(loader, visitorClass, (InvocationHandler)adaptor);
        traversal.setVisitor(wsdlVisitor);
        return traversal;
    }
}

