/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.wst.jsdt.chromium.Breakpoint;
import org.eclipse.wst.jsdt.chromium.BreakpointTypeExtension;
import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.Messages;
import org.eclipse.wst.jsdt.chromium.debug.core.ReverseSourceLookup;
import org.eclipse.wst.jsdt.chromium.debug.core.ScriptNameManipulator;
import org.eclipse.wst.jsdt.chromium.debug.core.VProjectSourceContainer;
import org.eclipse.wst.jsdt.chromium.debug.core.model.JavascriptVmEmbedder;
import org.eclipse.wst.jsdt.chromium.debug.core.model.LaunchParams;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ResourceManager;
import org.eclipse.wst.jsdt.chromium.debug.core.model.StackFrame;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResource;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResourceId;
import org.eclipse.wst.jsdt.chromium.debug.core.model.VmResourceRef;
import org.eclipse.wst.jsdt.chromium.debug.core.util.AccuratenessProperty;

public class ChromiumSourceDirector
extends AbstractSourceLookupDirector {
    private volatile ResourceManager resourceManager = null;
    private volatile IProject project = null;
    private volatile ReverseSourceLookup reverseSourceLookup = null;
    private volatile JavascriptVmEmbedder javascriptVmEmbedder = null;
    private volatile boolean lookupWarningShown = false;
    private final LaunchParams.LookupMode.Visitor<LookupModeHandler> MODE_TO_HANDLER_VISITOR = new LaunchParams.LookupMode.Visitor<LookupModeHandler>(){

        @Override
        public LookupModeHandler visitExactMatch() {
            return ChromiumSourceDirector.this.exactMatchLookupMode;
        }

        @Override
        public LookupModeHandler visitAutoDetect() {
            return ChromiumSourceDirector.this.autoDetectLookupMode;
        }
    };
    private static final LookupParticipant.Delegate EXACT_MATCH_DELEGATE = new LookupParticipant.Delegate(){

        @Override
        Object[] findSourceElements(Object object, LookupParticipant.SuperClassAccess superClass) throws CoreException {
            Object[] result = superClass.findSourceElements(object);
            if (result.length > 0) {
                ArrayList<Object> filtered = new ArrayList<Object>(result.length);
                Object[] objectArray = result;
                int n = result.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    if (obj instanceof VProjectSourceContainer.LookupResult) {
                        VProjectSourceContainer.LookupResult vprojectResult = (VProjectSourceContainer.LookupResult)obj;
                        ChromiumSourceDirector.expandVProjectResult(vprojectResult, object, filtered);
                    } else {
                        filtered.add(obj);
                    }
                    ++n2;
                }
                result = filtered.toArray();
            }
            return result;
        }
    };
    private static final LookupParticipant.Delegate AUTO_DETECT_DELEGATE = new LookupParticipant.Delegate(){

        @Override
        Object[] findSourceElements(Object object, LookupParticipant.SuperClassAccess superClass) throws CoreException {
            ArrayList<Object> result = new ArrayList<Object>();
            JavascriptVmEmbedder vmEmbedder = superClass.getChromiumSourceDirector().javascriptVmEmbedder;
            ScriptNameManipulator.FilePath scriptName = this.getParsedScriptFileName(object, vmEmbedder.getScriptNameManipulator());
            if (scriptName != null) {
                ISourceContainer[] iSourceContainerArray = superClass.getSourceContainers();
                int n = iSourceContainerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block5: {
                        ISourceContainer container = iSourceContainerArray[n2];
                        try {
                            this.findSourceElements(container, object, scriptName, result);
                        }
                        catch (CoreException e) {
                            ChromiumDebugPlugin.log(e);
                            break block5;
                        }
                        IFile oneFile = this.getSimpleResult(result);
                        if (oneFile != null) {
                            return new Object[]{oneFile};
                        }
                    }
                    ++n2;
                }
            }
            return result.toArray();
        }

        private void findSourceElements(ISourceContainer container, Object object, ScriptNameManipulator.FilePath scriptName, ArrayList<Object> output) throws CoreException {
            Object[] objects = container.findSourceElements(scriptName.getLastComponent());
            if (objects.length == 0) {
                return;
            }
            int outputStartPos = output.size();
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj = objectArray[n2];
                if (obj instanceof IFile) {
                    IFile file = (IFile)obj;
                    if (this.matchFileAccurateness(file, scriptName)) {
                        output.add(obj);
                    }
                } else if (obj instanceof VProjectSourceContainer.LookupResult) {
                    VProjectSourceContainer.LookupResult vprojectResult = (VProjectSourceContainer.LookupResult)obj;
                    ChromiumSourceDirector.expandVProjectResult(vprojectResult, object, output);
                } else {
                    output.add(obj);
                }
                ++n2;
            }
            int outputEndPos = output.size();
            if (outputEndPos - outputStartPos > 1) {
                Collections.sort(output.subList(outputStartPos, outputEndPos), SHORT_NAME_LAST);
            }
        }

        private IFile getSimpleResult(List<Object> objects) {
            if (objects.size() != 1) {
                return null;
            }
            Object oneObject = objects.get(0);
            if (!(oneObject instanceof IFile)) {
                return null;
            }
            IFile file = (IFile)oneObject;
            return file;
        }

        private boolean matchFileAccurateness(IFile file, ScriptNameManipulator.FilePath scriptName) throws CoreException {
            int accurateness = AccuratenessProperty.read(file);
            if (accurateness > 1) {
                IPath path = file.getFullPath();
                int pathPos = path.segmentCount() - 1 - 1;
                Iterator<String> scriptIterator = scriptName.iterator();
                while (accurateness > 1) {
                    String pathComponent;
                    if (pathPos < 0 || !scriptIterator.hasNext()) {
                        return false;
                    }
                    String scriptComponent = scriptIterator.next();
                    if (!scriptComponent.equals(pathComponent = path.segment(pathPos--))) {
                        return false;
                    }
                    --accurateness;
                }
            }
            return true;
        }

        private ScriptNameManipulator.FilePath getParsedScriptFileName(Object object, ScriptNameManipulator nameManipulator) throws CoreException {
            VmResourceId vmResourceId = ChromiumSourceDirector.getVmResourceId(object);
            if (vmResourceId == null) {
                return null;
            }
            String scriptName = vmResourceId.getName();
            if (scriptName == null) {
                return UNKNOWN_NAME;
            }
            return nameManipulator.getFileName(scriptName);
        }
    };
    private static final ScriptNameManipulator.FilePath UNKNOWN_NAME = new ScriptNameManipulator.FilePath(){

        @Override
        public String getLastComponent() {
            return "<unknonwn source>";
        }

        @Override
        public Iterator<String> iterator() {
            return Collections.emptyList().iterator();
        }
    };
    private static final Comparator<Object> SHORT_NAME_LAST = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            int len1 = this.getPathLength(o1);
            int len2 = this.getPathLength(o2);
            return len2 - len1;
        }

        private int getPathLength(Object obj) {
            if (!(obj instanceof IFile)) {
                return Integer.MIN_VALUE;
            }
            IFile file = (IFile)obj;
            return file.getFullPath().segmentCount();
        }
    };
    private static final Breakpoint.Target.Visitor<VmResourceId> BREAKPOINT_RESOURCE_VISITOR = new BreakpointTypeExtension.ScriptRegExpSupport.Visitor<VmResourceId>(){

        public VmResourceId visitScriptName(String scriptName) {
            return new VmResourceId(scriptName, null);
        }

        public VmResourceId visitScriptId(Object scriptId) {
            return new VmResourceId(null, scriptId);
        }

        public VmResourceId visitRegExp(String regExp) {
            return null;
        }

        public VmResourceId visitUnknown(Breakpoint.Target target) {
            return null;
        }
    };
    private final LookupModeHandler exactMatchLookupMode = new LookupModeHandler(){

        @Override
        LookupParticipant.Delegate getDelegate() {
            return EXACT_MATCH_DELEGATE;
        }

        @Override
        void showUnsupportedWarning(JavascriptVmEmbedder javascriptVmEmbedder) {
            ChromiumSourceDirector.this.lookupWarningShown = false;
        }

        @Override
        boolean forceFindDuplicates() {
            return false;
        }

        @Override
        VmResourceRef findVmResourceRef(IFile file) throws CoreException {
            VmResourceId vmResourceId = ChromiumSourceDirector.this.reverseSourceLookup.findVmResource(file);
            if (vmResourceId == null) {
                return null;
            }
            return VmResourceRef.forVmResourceId(vmResourceId);
        }
    };
    private final LookupModeHandler autoDetectLookupMode = new LookupModeHandler(){

        @Override
        LookupParticipant.Delegate getDelegate() {
            return AUTO_DETECT_DELEGATE;
        }

        @Override
        void showUnsupportedWarning(final JavascriptVmEmbedder javascriptVmEmbedder) {
            if (ChromiumSourceDirector.this.lookupWarningShown) {
                return;
            }
            BreakpointTypeExtension breakpointTypeExtension = javascriptVmEmbedder.getJavascriptVm().getBreakpointTypeExtension();
            BreakpointTypeExtension.ScriptRegExpSupport scriptRegExpSupport = breakpointTypeExtension.getScriptRegExpSupport();
            if (scriptRegExpSupport != null) {
                return;
            }
            ChromiumSourceDirector.this.lookupWarningShown = true;
            Display display = Display.getDefault();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Display display = Display.getDefault();
                    MessageBox messageBox = new MessageBox(display.getActiveShell(), 8);
                    messageBox.setText(Messages.ChromiumSourceDirector_WARNING_TITLE);
                    String messagePattern = Messages.ChromiumSourceDirector_WARNING_TEXT_PATTERN;
                    String message = NLS.bind((String)messagePattern, (Object)javascriptVmEmbedder.getJavascriptVm().getVersion());
                    messageBox.setMessage(message);
                    messageBox.open();
                }
            });
        }

        @Override
        boolean forceFindDuplicates() {
            return true;
        }

        @Override
        VmResourceRef findVmResourceRef(IFile file) throws CoreException {
            VmResourceId resourceId = ChromiumSourceDirector.this.resourceManager.getResourceId(file);
            if (resourceId != null) {
                return VmResourceRef.forVmResourceId(resourceId);
            }
            IPath path = file.getFullPath();
            int accurateness = AccuratenessProperty.read(file);
            if (accurateness > path.segmentCount()) {
                accurateness = path.segmentCount();
            }
            int offset = path.segmentCount() - accurateness;
            ArrayList<String> components = new ArrayList<String>(accurateness);
            int i = 0;
            while (i < accurateness) {
                components.add(path.segment(i + offset));
                ++i;
            }
            ScriptNameManipulator scriptNameManipulator = ChromiumSourceDirector.this.javascriptVmEmbedder.getScriptNameManipulator();
            ScriptNameManipulator.ScriptNamePattern pattern = scriptNameManipulator.createPattern(components);
            return VmResourceRef.forRegExpBased(pattern);
        }
    };

    public void initializeParticipants() {
        LookupParticipant participant = new LookupParticipant(this);
        this.addParticipants(new ISourceLookupParticipant[]{participant});
        this.checkSupportedLookupMode();
    }

    public VmResourceRef findVmResourceRef(IFile file) throws CoreException {
        return this.getLookupModeHandler().findVmResourceRef(file);
    }

    public static LaunchParams.LookupMode readLookupMode(ILaunchConfiguration launchConfiguration) throws CoreException {
        String lookupStringValue = launchConfiguration.getAttribute("source_lookup_mode", null);
        LaunchParams.LookupMode value = lookupStringValue == null ? LaunchParams.LookupMode.DEFAULT_VALUE : LaunchParams.LookupMode.STRING_CONVERTER.decode(lookupStringValue);
        return value;
    }

    private LookupModeHandler getLookupModeHandler() {
        LaunchParams.LookupMode mode;
        try {
            mode = ChromiumSourceDirector.readLookupMode(this.getLaunchConfiguration());
        }
        catch (CoreException e) {
            ChromiumDebugPlugin.log(e);
            mode = LaunchParams.LookupMode.DEFAULT_VALUE;
        }
        return mode.accept(this.MODE_TO_HANDLER_VISITOR);
    }

    public boolean isFindDuplicates() {
        return this.getLookupModeHandler().forceFindDuplicates() || super.isFindDuplicates();
    }

    private static String getSourceNameImpl(Object object) throws CoreException {
        VmResourceId vmResourceId = ChromiumSourceDirector.getVmResourceId(object);
        if (vmResourceId == null) {
            return null;
        }
        String name = vmResourceId.getName();
        if (name == null) {
            name = "";
        }
        return name;
    }

    private static VmResourceId getVmResourceId(Object object) throws CoreException {
        if (object instanceof Script) {
            Script script = (Script)object;
            return VmResourceId.forScript(script);
        }
        if (object instanceof StackFrame) {
            StackFrame jsStackFrame = (StackFrame)((Object)object);
            return jsStackFrame.getVmResourceId();
        }
        if (object instanceof Breakpoint) {
            Breakpoint breakpoint = (Breakpoint)object;
            return (VmResourceId)breakpoint.getTarget().accept(BREAKPOINT_RESOURCE_VISITOR);
        }
        if (object instanceof VmResourceId) {
            VmResourceId resourceId = (VmResourceId)object;
            return resourceId;
        }
        return null;
    }

    private static void expandVProjectResult(VProjectSourceContainer.LookupResult lookupResult, Object object, ArrayList<Object> output) throws CoreException {
        VmResource vmResource;
        VmResourceId resourceId = ChromiumSourceDirector.getVmResourceId(object);
        if (resourceId.getId() != null && (vmResource = lookupResult.getVmResource(resourceId)) != null) {
            output.add(vmResource.getVProjectFile());
        }
    }

    public void initializeVProjectContainers(IProject project, ResourceManager resourceManager, JavascriptVmEmbedder javascriptVmEmbedder) {
        this.resourceManager = resourceManager;
        this.project = project;
        this.javascriptVmEmbedder = javascriptVmEmbedder;
        this.reverseSourceLookup = new ReverseSourceLookup((ISourceLookupDirector)this);
        this.checkSupportedLookupMode();
    }

    public ReverseSourceLookup getReverseSourceLookup() {
        return this.reverseSourceLookup;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    IProject getProject() {
        return this.project;
    }

    private void checkSupportedLookupMode() {
        LookupModeHandler lookupMode = this.getLookupModeHandler();
        if (this.javascriptVmEmbedder != null) {
            lookupMode.showUnsupportedWarning(this.javascriptVmEmbedder);
        }
    }

    private static abstract class LookupModeHandler {
        private LookupModeHandler() {
        }

        abstract LookupParticipant.Delegate getDelegate();

        abstract void showUnsupportedWarning(JavascriptVmEmbedder var1);

        abstract boolean forceFindDuplicates();

        abstract VmResourceRef findVmResourceRef(IFile var1) throws CoreException;
    }

    private static class LookupParticipant
    extends AbstractSourceLookupParticipant {
        private final SuperClassAccess superClassAccess = new SuperClassAccess();
        private final ChromiumSourceDirector chromiumSourceDirector;

        LookupParticipant(ChromiumSourceDirector chromiumSourceDirector) {
            this.chromiumSourceDirector = chromiumSourceDirector;
        }

        public String getSourceName(Object object) throws CoreException {
            return ChromiumSourceDirector.getSourceNameImpl(object);
        }

        public Object[] findSourceElements(Object object) throws CoreException {
            Delegate delegate = this.chromiumSourceDirector.getLookupModeHandler().getDelegate();
            return delegate.findSourceElements(object, this.superClassAccess);
        }

        private Object[] findSourceElementsSuper(Object object) throws CoreException {
            return super.findSourceElements(object);
        }

        static abstract class Delegate {
            Delegate() {
            }

            abstract Object[] findSourceElements(Object var1, SuperClassAccess var2) throws CoreException;
        }

        class SuperClassAccess {
            SuperClassAccess() {
            }

            Object[] findSourceElements(Object object) throws CoreException {
                return LookupParticipant.this.findSourceElementsSuper(object);
            }

            ISourceContainer[] getSourceContainers() {
                return LookupParticipant.this.getSourceContainers();
            }

            ChromiumSourceDirector getChromiumSourceDirector() {
                return LookupParticipant.this.chromiumSourceDirector;
            }
        }
    }
}

