/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.jsf.core.dom.JSFDOMUtil;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.CommandResources;
import org.eclipse.jst.pagedesigner.utils.JSPUtil;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;

public class DataTableInsertHeaderCommand
extends DesignerCommand {
    boolean _header;
    private Element _dataTable;

    public DataTableInsertHeaderCommand(IHTMLGraphicalViewer viewer, Element dataTable, boolean header) {
        super(header ? CommandResources.getString("DataTableInsertHeaderCommand.Label.InsertHeader") : CommandResources.getString("DataTableInsertHeaderCommand.Label.InsertFooter"), viewer);
        this._header = header;
        this._dataTable = dataTable;
    }

    public boolean canExecute() {
        if (this._header) {
            boolean hasHeader;
            boolean bl = hasHeader = JSFDOMUtil.findFacet(this._dataTable, "header") != null;
            if (hasHeader) {
                return false;
            }
        } else {
            boolean hasFooter;
            boolean bl = hasFooter = JSFDOMUtil.findFacet(this._dataTable, "footer") != null;
            if (hasFooter) {
                return false;
            }
        }
        return super.canExecute();
    }

    protected void doExecute() {
        String type = this._header ? "header" : "footer";
        Element headerOrFooter = this.createHeaderOrFooter(type);
        if (this._header) {
            this._dataTable.insertBefore(headerOrFooter, this._dataTable.getFirstChild());
        } else {
            this._dataTable.appendChild(headerOrFooter);
        }
        this.formatNode(this._dataTable);
    }

    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._dataTable);
    }

    private Element createHeaderOrFooter(String type) {
        Element facet = this.createFacet();
        Element def = this.createDefaultElement();
        facet.appendChild(def);
        facet.setAttribute("name", type);
        return facet;
    }

    private Element createFacet() {
        String prefix = JSPUtil.getOrCreatePrefix((IDOMModel)this.getModel(), (String)"http://java.sun.com/jsf/core", (String)"f");
        Element ele = this._dataTable.getOwnerDocument().createElement("facet");
        ele.setPrefix(prefix);
        return ele;
    }

    private Element createDefaultElement() {
        String prefix = JSPUtil.getOrCreatePrefix((IDOMModel)this.getModel(), (String)"http://java.sun.com/jsf/html", (String)"h");
        Element ele = this._dataTable.getOwnerDocument().createElement("outputText");
        ele.setPrefix(prefix);
        if (this._header) {
            ele.setAttribute("value", "Table Header");
        } else {
            ele.setAttribute("value", "Table Footer");
        }
        return ele;
    }
}

