/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa2.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.TypeStringExpressionConverter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.ElementCollectionAnnotation2_0;
import org.eclipse.jpt.jpa.core.resource.java.FetchType;

public final class SourceElementCollectionAnnotation2_0
extends SourceAnnotation
implements ElementCollectionAnnotation2_0 {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter(ANNOTATION_NAME);
    private static final DeclarationAnnotationElementAdapter<String> TARGET_CLASS_ADAPTER = SourceElementCollectionAnnotation2_0.buildTargetClassAdapter();
    private final AnnotationElementAdapter<String> targetClassAdapter;
    private String targetClass;
    private TextRange targetClassTextRange;
    private String fullyQualifiedTargetClassName;
    private boolean fqTargetClassNameStale = true;
    private static final DeclarationAnnotationElementAdapter<String> FETCH_ADAPTER = SourceElementCollectionAnnotation2_0.buildFetchAdapter();
    private final AnnotationElementAdapter<String> fetchAdapter;
    private FetchType fetch;
    private TextRange fetchTextRange;

    public SourceElementCollectionAnnotation2_0(JavaResourceAnnotatedElement parent, AnnotatedElement element) {
        super((JavaResourceModel)parent, element, DECLARATION_ANNOTATION_ADAPTER);
        this.targetClassAdapter = new AnnotatedElementAnnotationElementAdapter(element, TARGET_CLASS_ADAPTER);
        this.fetchAdapter = new AnnotatedElementAnnotationElementAdapter(element, FETCH_ADAPTER);
    }

    public String getAnnotationName() {
        return ANNOTATION_NAME;
    }

    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.targetClass = this.buildTargetClass(astAnnotation);
        this.targetClassTextRange = this.buildTargetClassTextRange(astAnnotation);
        this.fetch = this.buildFetch(astAnnotation);
        this.fetchTextRange = this.buildFetchTextRange(astAnnotation);
    }

    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncTargetClass(this.buildTargetClass(astAnnotation));
        this.targetClassTextRange = this.buildTargetClassTextRange(astAnnotation);
        this.syncFetch(this.buildFetch(astAnnotation));
        this.fetchTextRange = this.buildFetchTextRange(astAnnotation);
    }

    public boolean isUnset() {
        return super.isUnset() && this.targetClass == null && this.fetch == null;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.targetClass);
    }

    @Override
    public String getTargetClass() {
        return this.targetClass;
    }

    @Override
    public void setTargetClass(String targetClass) {
        if (ObjectTools.notEquals((Object)this.targetClass, (Object)targetClass)) {
            this.targetClass = targetClass;
            this.fqTargetClassNameStale = true;
            this.targetClassAdapter.setValue((Object)targetClass);
        }
    }

    private void syncTargetClass(String astTargetClass) {
        if (ObjectTools.notEquals((Object)this.targetClass, (Object)astTargetClass)) {
            this.syncTargetClass_(astTargetClass);
        }
    }

    private void syncTargetClass_(String astTargetClass) {
        String old = this.targetClass;
        this.targetClass = astTargetClass;
        this.fqTargetClassNameStale = true;
        this.firePropertyChanged("targetClass", old, astTargetClass);
    }

    private String buildTargetClass(Annotation astAnnotation) {
        return (String)this.targetClassAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getTargetClassTextRange() {
        return this.targetClassTextRange;
    }

    private TextRange buildTargetClassTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(TARGET_CLASS_ADAPTER, astAnnotation);
    }

    @Override
    public String getFullyQualifiedTargetClassName() {
        if (this.fqTargetClassNameStale) {
            this.fullyQualifiedTargetClassName = this.buildFullyQualifiedTargetClassName();
            this.fqTargetClassNameStale = false;
        }
        return this.fullyQualifiedTargetClassName;
    }

    private String buildFullyQualifiedTargetClassName() {
        return this.targetClass == null ? null : this.buildFullyQualifiedTargetClassName_();
    }

    private String buildFullyQualifiedTargetClassName_() {
        return ASTTools.resolveFullyQualifiedName((Expression)this.targetClassAdapter.getExpression(this.buildASTRoot()));
    }

    @Override
    public FetchType getFetch() {
        return this.fetch;
    }

    @Override
    public void setFetch(FetchType fetch) {
        if (ObjectTools.notEquals((Object)((Object)this.fetch), (Object)((Object)fetch))) {
            this.fetch = fetch;
            this.fetchAdapter.setValue((Object)FetchType.toJavaAnnotationValue(fetch));
        }
    }

    private void syncFetch(FetchType astFetch) {
        FetchType old = this.fetch;
        this.fetch = astFetch;
        this.firePropertyChanged("fetch", (Object)old, (Object)astFetch);
    }

    private FetchType buildFetch(Annotation astAnnotation) {
        return FetchType.fromJavaAnnotationValue(this.fetchAdapter.getValue(astAnnotation));
    }

    @Override
    public TextRange getFetchTextRange() {
        return this.fetchTextRange;
    }

    private TextRange buildFetchTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(FETCH_ADAPTER, astAnnotation);
    }

    private static DeclarationAnnotationElementAdapter<String> buildFetchAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "fetch");
    }

    private static DeclarationAnnotationElementAdapter<String> buildTargetClassAdapter() {
        return SourceElementCollectionAnnotation2_0.buildTargetClassAdapter(DECLARATION_ANNOTATION_ADAPTER, "targetClass");
    }

    private static DeclarationAnnotationElementAdapter<String> buildTargetClassAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return SourceElementCollectionAnnotation2_0.buildAnnotationElementAdapter(annotationAdapter, elementName, (ExpressionConverter<String>)TypeStringExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String> converter) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }
}

