/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.ui.preferences;

import java.util.Arrays;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.pagedesigner.PDPlugin;

public class PDPreferences
extends AbstractPreferenceInitializer {
    public static final String SASH_EDITOR_MODE_PREF = PDPreferences.class.getName() + ".sash_editor_mode";
    public static final String CSS_USE_ARTIFICAL_CELL_PADDING = PDPreferences.class.getName() + ".CSSArtificalCellPadding";
    public static final String CSS_ENABLE_ABSOLUTE_POSITIONING = PDPreferences.class.getName() + ".CSSEnableAbsolutePositioning";
    public static final String HIDE_PREVIEW_PAGE_FOR_CONTENT_TYPES = PDPreferences.class.getName() + ".hidePreviewPageForContentTypes";
    public static final boolean DEFAULT_CSS_ENABLE_ABSOLUTE_POSITIONING = false;
    public static final int DEFAULT_CSS_USE_ARTIFICIAL_CELL_PADDING = 4;
    public static final String DEFAULT_HIDE_PREVIEW_PAGE_FOR_CONTENT_TYPES = "";

    public void initializeDefaultPreferences() {
        IPreferenceStore store = PDPreferences.getPreferenceStore();
        store.setDefault(SASH_EDITOR_MODE_PREF, 0);
        store.setDefault(CSS_USE_ARTIFICAL_CELL_PADDING, 4);
        store.setDefault(CSS_ENABLE_ABSOLUTE_POSITIONING, false);
        store.setDefault(HIDE_PREVIEW_PAGE_FOR_CONTENT_TYPES, DEFAULT_HIDE_PREVIEW_PAGE_FOR_CONTENT_TYPES);
    }

    public boolean isCssAbsolutePositioningEnabled() {
        IPreferenceStore store = PDPreferences.getPreferenceStore();
        return store.getBoolean(CSS_ENABLE_ABSOLUTE_POSITIONING);
    }

    public int getCssArtificialCellPadding() {
        IPreferenceStore store = PDPreferences.getPreferenceStore();
        return store.getInt(CSS_USE_ARTIFICAL_CELL_PADDING);
    }

    public static String[] getHiddenPreviewPageContentTypes() {
        String[] hiddenTypes = new String[]{};
        IPreferenceStore store = PDPreferences.getPreferenceStore();
        String hiddenTypesString = store.getString(HIDE_PREVIEW_PAGE_FOR_CONTENT_TYPES);
        if (hiddenTypesString != null && hiddenTypesString.length() > 0) {
            hiddenTypes = hiddenTypesString.split(",");
        }
        return hiddenTypes;
    }

    public static void addHiddenPreviewPageContentType(String contentTypeId) {
        Object[] hiddenContentTypes;
        if (contentTypeId != null && contentTypeId.length() > 0 && Arrays.binarySearch(hiddenContentTypes = PDPreferences.getHiddenPreviewPageContentTypes(), contentTypeId) < 0) {
            String hiddenTypesString = PDPreferences.arrayToString((String[])hiddenContentTypes);
            if (hiddenTypesString.length() > 0) {
                hiddenTypesString = hiddenTypesString.concat(",");
            }
            hiddenTypesString = hiddenTypesString.concat(contentTypeId.trim());
            IPreferenceStore store = PDPreferences.getPreferenceStore();
            store.setValue(HIDE_PREVIEW_PAGE_FOR_CONTENT_TYPES, hiddenTypesString);
        }
    }

    public static void removeHiddenPreviewPageContentType(String contentTypeId) {
        Object[] hiddenContentTypes;
        if (contentTypeId != null && contentTypeId.length() > 0 && Arrays.binarySearch(hiddenContentTypes = PDPreferences.getHiddenPreviewPageContentTypes(), contentTypeId) >= 0) {
            String hiddenTypesString = PDPreferences.arrayToString((String[])hiddenContentTypes);
            hiddenTypesString.replace(contentTypeId, DEFAULT_HIDE_PREVIEW_PAGE_FOR_CONTENT_TYPES);
            hiddenTypesString.replace(",,", ",");
            IPreferenceStore store = PDPreferences.getPreferenceStore();
            store.setValue(HIDE_PREVIEW_PAGE_FOR_CONTENT_TYPES, hiddenTypesString);
        }
    }

    private static IPreferenceStore getPreferenceStore() {
        return PDPlugin.getDefault().getPreferenceStore();
    }

    private static String arrayToString(String[] array) {
        String string = DEFAULT_HIDE_PREVIEW_PAGE_FOR_CONTENT_TYPES;
        if (array != null && array.length > 0) {
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < array.length) {
                if (i > 0) {
                    builder.append(',');
                }
                builder.append(array[i]);
                ++i;
            }
            string = builder.toString();
        }
        return string;
    }
}

