/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.runtime;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.wst.jsdt.core.runtime.IJSRuntimeInstall;
import org.eclipse.wst.jsdt.core.tests.internal.runtime.TestJSRuntimeProvider1;
import org.eclipse.wst.jsdt.core.tests.internal.runtime.TestJSRuntimeProvider2;
import org.eclipse.wst.jsdt.internal.core.runtime.JSRuntimeInstallRegistryReader;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class JSRuntimeInstallRegistryReaderTest {
    private static final String RUNTIME_TYPE_1 = "js.runtime.test.type";
    private static final String RUNTIME_TYPE_2 = "js.runtime.test.type.2";
    private static final String RUNTIME_TYPE_NAME_1 = "jsruntimetesttype";
    private static final String RUNTIME_TYPE_NAME_2 = "jsruntimetesttype2";

    private Set<String> getExpectedRuntimesIds() {
        HashSet<String> s = new HashSet<String>();
        s.add(TestJSRuntimeProvider1.FAKE_RUNTIME_ID_1);
        s.add(TestJSRuntimeProvider1.FAKE_RUNTIME_ID_2);
        s.add(TestJSRuntimeProvider2.FAKE_RUNTIME_ID_3);
        return s;
    }

    @Test
    public void test_01_extensionReading() {
        Collection runtimes = JSRuntimeInstallRegistryReader.getJSRuntimeInstalls();
        Set<String> expectedRuntimesIds = this.getExpectedRuntimesIds();
        for (IJSRuntimeInstall runtime : runtimes) {
            String runtimeTypeName;
            String runtimeTypeId;
            String installLocation;
            String runtimeArgs;
            String runtimeName;
            if (runtime.getId().equals(TestJSRuntimeProvider1.FAKE_RUNTIME_ID_1)) {
                runtimeName = TestJSRuntimeProvider1.FAKE_RUNTIME_NAME_1;
                runtimeArgs = TestJSRuntimeProvider1.FAKE_RUNTIME_ARGS_1;
                installLocation = TestJSRuntimeProvider1.FAKE_RUNTIME_INSTALL_LOCATION_1;
                runtimeTypeId = RUNTIME_TYPE_1;
                runtimeTypeName = RUNTIME_TYPE_NAME_1;
            } else if (runtime.getId().equals(TestJSRuntimeProvider1.FAKE_RUNTIME_ID_2)) {
                runtimeName = TestJSRuntimeProvider1.FAKE_RUNTIME_NAME_2;
                runtimeArgs = TestJSRuntimeProvider1.FAKE_RUNTIME_ARGS_2;
                installLocation = TestJSRuntimeProvider1.FAKE_RUNTIME_INSTALL_LOCATION_2;
                runtimeTypeId = RUNTIME_TYPE_1;
                runtimeTypeName = RUNTIME_TYPE_NAME_1;
            } else {
                if (!runtime.getId().equals(TestJSRuntimeProvider2.FAKE_RUNTIME_ID_3)) continue;
                runtimeName = TestJSRuntimeProvider2.FAKE_RUNTIME_NAME_3;
                runtimeArgs = TestJSRuntimeProvider2.FAKE_RUNTIME_ARGS_3;
                installLocation = TestJSRuntimeProvider2.FAKE_RUNTIME_INSTALL_LOCATION_3;
                runtimeTypeId = RUNTIME_TYPE_2;
                runtimeTypeName = RUNTIME_TYPE_NAME_2;
            }
            Assert.assertEquals((Object)runtimeName, (Object)runtime.getName());
            Assert.assertArrayEquals((Object[])runtimeArgs.split(" "), (Object[])runtime.getJSRuntimeArguments());
            Assert.assertEquals((Object)installLocation, (Object)runtime.getInstallLocation().getAbsolutePath());
            Assert.assertEquals((Object)runtimeTypeId, (Object)runtime.getRuntimeType().getId());
            Assert.assertEquals((Object)runtimeTypeName, (Object)runtime.getRuntimeType().getName());
            expectedRuntimesIds.remove(runtime.getId());
        }
        Assert.assertEquals((long)0L, (long)expectedRuntimesIds.size());
    }
}

