/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.jpql;

import java.util.Collections;
import java.util.HashSet;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.predicate.CriterionPredicate;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.tools.ContentAssistExtension;
import org.eclipse.persistence.jpa.jpql.tools.ContentAssistProposals;

public class DefaultContentAssistExtension
implements ContentAssistExtension {
    private JpaProject jpaProject;
    private static final char TABLE_QUALIFIER = '`';
    protected static final TransformerAdapter<String, String> TABLE_NAME_TRANSFORMER = new TableNameTransformer();

    public DefaultContentAssistExtension(JpaProject jpaProject) {
        this.jpaProject = jpaProject;
    }

    protected boolean acceptClass(IType type, String className, ContentAssistProposals.ClassType classType, String prefix, boolean hasDot) throws Exception {
        if (!this.isClassFiltered(className, prefix, hasDot)) {
            return !type.isAnonymous() && classType == ContentAssistProposals.ClassType.INSTANTIABLE ? type.isClass() : type.isEnum() && !type.isMember();
        }
        return false;
    }

    public Iterable<String> classNames(String prefix, ContentAssistProposals.ClassType classType) {
        IJavaProject javaProject = this.jpaProject.getJavaProject();
        HashSet<String> classNames = new HashSet<String>();
        boolean emptyPrefix = prefix.length() == 0;
        int index = !emptyPrefix ? prefix.lastIndexOf(46) : -1;
        boolean hasDot = index > -1;
        try {
            IPackageFragment[] iPackageFragmentArray = javaProject.getPackageFragments();
            int n = iPackageFragmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean packageAccepted;
                IPackageFragment packageFragment = iPackageFragmentArray[n2];
                String packageName = packageFragment.getElementName();
                boolean bl = packageAccepted = !hasDot || packageName.regionMatches(true, 0, prefix, 0, index);
                if (packageAccepted) {
                    IJavaElement[] iJavaElementArray = packageFragment.getChildren();
                    int n3 = iJavaElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IJavaElement javaElement = iJavaElementArray[n4];
                        switch (javaElement.getElementType()) {
                            case 5: {
                                ICompilationUnit compilationUnit = (ICompilationUnit)javaElement;
                                IJavaElement[] iJavaElementArray2 = compilationUnit.getChildren();
                                int n5 = iJavaElementArray2.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    IJavaElement cuChild = iJavaElementArray2[n6];
                                    if (cuChild.getElementType() == 7) {
                                        IType type = (IType)cuChild;
                                        String className = type.getFullyQualifiedName();
                                        if (emptyPrefix || this.acceptClass(type, className, classType, prefix, hasDot)) {
                                            classNames.add(className);
                                        }
                                    }
                                    ++n6;
                                }
                                break;
                            }
                            case 6: {
                                IClassFile classFile = (IClassFile)javaElement;
                                IType type = classFile.getType();
                                String className = type.getFullyQualifiedName();
                                if (!emptyPrefix && !this.acceptClass(type, className, classType, prefix, hasDot)) break;
                                classNames.add(className);
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        return classNames;
    }

    public Iterable<String> columnNames(String tableName, String prefix) {
        Schema schema = this.getSchema();
        if (schema == null) {
            return Collections.emptyList();
        }
        Table table = schema.getTableNamed(tableName);
        if (table == null) {
            return Collections.emptyList();
        }
        if (prefix.length() == 0) {
            return table.getSortedColumnIdentifiers();
        }
        return IterableTools.filter((Iterable)table.getSortedColumnIdentifiers(), (Predicate)new ExpressionStartsWithIgnoreCase(prefix));
    }

    protected Schema getSchema() {
        Database database = this.jpaProject.getDataSource().getDatabase();
        return database == null ? null : database.getDefaultSchema();
    }

    protected boolean isClassFiltered(String className, String prefix, boolean hasDot) {
        int index;
        if (!hasDot && (index = className.lastIndexOf(46)) > -1) {
            className = className.substring(index + 1, className.length());
        }
        if (className.lastIndexOf(36) > -1) {
            return true;
        }
        return !StringTools.startsWithIgnoreCase((String)className, (String)prefix);
    }

    protected Iterable<String> tableNames(Schema schema) {
        return IterableTools.transform((Iterable)schema.getSortedTableIdentifiers(), TABLE_NAME_TRANSFORMER);
    }

    public Iterable<String> tableNames(String prefix) {
        Schema schema = this.getSchema();
        return schema == null ? IterableTools.emptyIterable() : IterableTools.filter(this.tableNames(schema), (Predicate)new StringTools.StartsWithIgnoreCase(prefix));
    }

    public static class ExpressionStartsWithIgnoreCase
    extends CriterionPredicate<String, String> {
        public ExpressionStartsWithIgnoreCase(String prefix) {
            super((Object)prefix);
        }

        public boolean evaluate(String string) {
            return ExpressionTools.startWithIgnoreCase((String)string, (String)((String)this.criterion));
        }
    }

    public static class TableNameTransformer
    extends TransformerAdapter<String, String> {
        public String transform(String tableName) {
            if (tableName.charAt(0) == '`') {
                tableName = StringTools.undelimit((String)tableName, (int)1);
            }
            return tableName;
        }
    }
}

