/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.model;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceAlreadyExists;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.tests.util.FileUtil;
import org.eclipse.wst.xml.core.tests.util.ProjectUnzipUtility;

public class TestModelManager
extends TestCase {
    private boolean isSetup = false;
    private final String fProjectName = "DOCUMENT-LOADER";
    private final String fZipFileName = "xml-document-loader-tests.zip";

    public TestModelManager() {
        super("TestModelManager");
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (!this.isSetup) {
            this.doSetup();
            this.isSetup = true;
        }
    }

    private void doSetup() throws Exception {
        Location platformLocation = Platform.getInstanceLocation();
        ProjectUnzipUtility unzipUtil = new ProjectUnzipUtility();
        File zipFile = FileUtil.makeFileFor("projecttestfiles", "xml-document-loader-tests.zip", "projecttestfiles");
        unzipUtil.unzipAndImport(zipFile, platformLocation.getURL().getFile());
        unzipUtil.initJavaProject("DOCUMENT-LOADER");
    }

    private IStructuredModel getStructuredModelForEdit() {
        IFile f = this.getFile();
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getModelForEdit(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return model;
    }

    private IFile getFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("DOCUMENT-LOADER/files/simple.xml"));
    }

    private IModelManager getMM() {
        return StructuredModelManager.getModelManager();
    }

    public void testCopyModel() {
        IStructuredModel model = null;
        try {
            model = this.getStructuredModelForEdit();
            try {
                IStructuredModel modelCopy = this.getMM().copyModelForEdit(model.getId(), "newId");
                TestModelManager.assertNotNull((String)"copied model was null", (Object)modelCopy);
            }
            catch (ResourceInUse e) {
                e.printStackTrace();
            }
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testCreateNewInstance() throws IOException {
        IStructuredModel model = null;
        try {
            model = this.getStructuredModelForEdit();
            IStructuredModel newInstance = this.getMM().createNewInstance(model);
            TestModelManager.assertTrue((String)("failed to create new instance of: " + String.valueOf(model)), (model != newInstance ? 1 : 0) != 0);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testCreateNewStructuredDocumentFor() throws IOException, CoreException {
        IStructuredModel model = null;
        try {
            IFile file = this.getFile();
            model = this.getStructuredModelForEdit();
            boolean resourceExists = false;
            try {
                this.getMM().createNewStructuredDocumentFor(file);
            }
            catch (ResourceAlreadyExists resourceAlreadyExists) {
                resourceExists = true;
            }
            TestModelManager.assertTrue((String)"should have gotten ResourceAlreadyExits exception", (boolean)resourceExists);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testCreateStructuredDocumentFor() throws IOException, ResourceAlreadyExists, CoreException {
        Object model = null;
        try {
            IFile file = this.getFile();
            IStructuredDocument sDoc = this.getMM().createStructuredDocumentFor(file);
            TestModelManager.assertNotNull((String)"failed to create structured document", (Object)sDoc);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testGetExistingModelFromFile() throws IOException, CoreException {
        IFile f = this.getFile();
        IStructuredModel model = null;
        IStructuredModel existingModel = null;
        try {
            model = this.getStructuredModelForEdit();
            existingModel = StructuredModelManager.getModelManager().getExistingModelForEdit(f);
            TestModelManager.assertNotNull((String)"failed to get existing model", (Object)existingModel);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
            if (existingModel != null) {
                existingModel.releaseFromEdit();
            }
        }
    }

    public void testGetExistingModelFromDocument() {
        IStructuredModel model = null;
        IStructuredModel gottenModel = null;
        try {
            model = this.getStructuredModelForEdit();
            IStructuredDocument doc = model.getStructuredDocument();
            gottenModel = this.getMM().getExistingModelForEdit((IDocument)doc);
            TestModelManager.assertTrue((String)"models should be the same instance", (model == gottenModel ? 1 : 0) != 0);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
            if (gottenModel != null) {
                gottenModel.releaseFromEdit();
            }
        }
    }

    public void testGetModelFromFile() throws IOException, CoreException {
        IFile f = this.getFile();
        IStructuredModel model = null;
        try {
            model = StructuredModelManager.getModelManager().getModelForEdit(f);
            TestModelManager.assertNotNull((String)"failed to get model", (Object)model);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testGetModelFromDocument() {
        IStructuredModel model = null;
        IStructuredModel gottenModel = null;
        try {
            model = this.getStructuredModelForEdit();
            IStructuredDocument doc = model.getStructuredDocument();
            gottenModel = this.getMM().getModelForEdit(doc);
            TestModelManager.assertTrue((String)"models should be the same instance", (model == gottenModel ? 1 : 0) != 0);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
            if (gottenModel != null) {
                gottenModel.releaseFromEdit();
            }
        }
    }

    public void testIsShared() {
        IStructuredModel model = null;
        IStructuredModel model2 = null;
        try {
            model = this.getStructuredModelForEdit();
            model2 = this.getStructuredModelForEdit();
            boolean isShared = this.getMM().isShared((Object)model.getId());
            TestModelManager.assertTrue((String)"model should be shared", (boolean)isShared);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
            if (model2 != null) {
                model2.releaseFromEdit();
            }
        }
    }

    public void testReinitialize() throws IOException {
        IStructuredModel model = null;
        try {
            model = this.getStructuredModelForEdit();
            this.getMM().reinitialize(model);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testReleaseModel() throws IOException {
    }

    public void testSaveModel() throws UnsupportedEncodingException, CoreException, IOException {
        IStructuredModel model = null;
        try {
            model = this.getStructuredModelForEdit();
            model.save();
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void testSaveModelIfNotShared() {
    }
}

