/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.jca.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.RARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.internal.validation.J2EEValidationHelper;
import org.eclipse.jst.j2ee.jca.modulecore.util.ConnectorArtifactEdit;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;

public class ConnectorHelper
extends J2EEValidationHelper {
    protected RARFile rarFile;

    public ConnectorHelper() {
        this.registerModel("CONNECTOR_VALIDATION", "loadRarFile");
    }

    public EObject loadRarFile() {
        IVirtualComponent comp = ComponentCore.createComponent((IProject)this.getProject());
        ArtifactEdit edit = ComponentUtilities.getArtifactEditForRead((IVirtualComponent)comp);
        try {
            RARFile rARFile = this.rarFile = (RARFile)((ConnectorArtifactEdit)edit).asArchive(false);
            return rARFile;
        }
        catch (OpenFailureException e1) {
            Logger.getLogger().log((Throwable)e1);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
        return null;
    }

    public String getPortableName(IResource resource) {
        if (!(resource instanceof IFile)) {
            return null;
        }
        return "rar.xml";
    }

    public void cleanup(WorkbenchReporter reporter) {
        if (this.rarFile != null) {
            this.rarFile.close();
            this.rarFile = null;
        }
        super.cleanup(reporter);
    }
}

