/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dom;

import org.eclipse.jst.pagedesigner.dom.DOMRefPosition;
import org.eclipse.jst.pagedesigner.dom.DOMUtil;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.w3c.dom.Node;

public class DOMRange {
    IDOMPosition _start;
    IDOMPosition _end;

    public DOMRange(IDOMPosition p1, IDOMPosition p2) {
        this._start = p1;
        this._end = p2;
    }

    public IDOMPosition getStartPosition() {
        return this._start;
    }

    public IDOMPosition getEndPosition() {
        return this._end;
    }

    public boolean isEmpty() {
        return this._start.getContainerNode() == this._end.getContainerNode() && this._start.getOffset() == this._end.getOffset();
    }

    public boolean isOrdered() {
        Node common = DOMUtil.findCommonAncester(this._start.getContainerNode(), this._end.getContainerNode());
        if (common == null) {
            return true;
        }
        IDOMPosition s = this.moveUp(this._start, common);
        IDOMPosition e = this.moveUp(this._end, common);
        return e.getOffset() >= s.getOffset();
    }

    private IDOMPosition moveUp(IDOMPosition p, Node ancester) {
        while (p.getContainerNode() != ancester) {
            p = new DOMRefPosition(p.getContainerNode(), false);
        }
        return p;
    }
}

