/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.jsf.core.dom.JSFDOMUtil;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.CommandResources;
import org.eclipse.jst.pagedesigner.jsf.ui.elementedit.util.PanelGridUtil;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.eclipse.jst.pagedesigner.utils.JSPUtil;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PanelGridInsertColumnCommand
extends DesignerCommand {
    private int _columnIndex;
    private Element _panelGridEle;

    public PanelGridInsertColumnCommand(IHTMLGraphicalViewer viewer, Element panelGrid, int columnIndex) {
        super(CommandResources.getString("PanelGridInsertColumnCommand.Label.InsertColumn"), viewer);
        this._panelGridEle = panelGrid;
        this._columnIndex = columnIndex;
    }

    public boolean canExecute() {
        if (this._columnIndex < 0) {
            return false;
        }
        return super.canExecute();
    }

    protected void doExecute() {
        int uiRows;
        int columns = DOMUtil.getIntAttributeIgnoreCase((Element)this._panelGridEle, (String)"columns", (int)1);
        if (columns < 1) {
            columns = 1;
        }
        int startPoint = 0;
        if (this._columnIndex > columns) {
            return;
        }
        startPoint = this._columnIndex == columns ? this._columnIndex - 1 : this._columnIndex;
        List children = JSFDOMUtil.getUIComponentChildren(this._panelGridEle);
        ArrayList toMove = new ArrayList();
        int i = startPoint;
        while (i < children.size()) {
            if (this._columnIndex < columns) {
                toMove.add(children.get(i));
            } else {
                int tmp = i + 1;
                if (tmp == children.size()) {
                    toMove.add(null);
                } else {
                    toMove.add(children.get(i + 1));
                }
            }
            i += columns;
        }
        int lastRowCells = children.size() % columns == 0 ? columns : children.size() % columns;
        PanelGridUtil util = new PanelGridUtil(this._panelGridEle);
        int adds = uiRows = util.getUIRowCount();
        if (this._columnIndex > lastRowCells) {
            adds += this._columnIndex - lastRowCells;
        }
        int i2 = 0;
        int size = adds;
        while (i2 < size) {
            Node child = this.createDefaultNode();
            int toMoveSize = toMove.size();
            Node node = null;
            if (i2 < toMoveSize) {
                node = (Node)toMove.get(i2);
            }
            this._panelGridEle.insertBefore(child, node);
            ++i2;
        }
        this._panelGridEle.setAttribute("columns", String.valueOf(columns + 1));
        this.formatNode(this._panelGridEle);
    }

    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._panelGridEle);
    }

    private Node createDefaultNode() {
        String prefix = JSPUtil.getOrCreatePrefix((IDOMModel)this.getModel(), (String)"http://java.sun.com/jsf/html", (String)"h");
        Element child = this._panelGridEle.getOwnerDocument().createElement("outputText");
        child.setPrefix(prefix);
        return child;
    }
}

