/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.dialogfield;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public final class LayoutUtil {
    private static final int BUTTON_HEIGHT_ADJUSTMENT = 5;

    public static void setGrabHorizontal(Control control, boolean grab) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).grabExcessHorizontalSpace = grab;
        }
    }

    public static void setWidthHint(Control control, int widthHint) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).widthHint = widthHint;
        }
    }

    static void setHorizontalIndent(Control control, int horizontalIndent) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).horizontalIndent = horizontalIndent;
        }
    }

    public static void setHorizontalGrabbing(Control control) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            ((GridData)ld).grabExcessHorizontalSpace = true;
        }
    }

    static int getButtonWidthHint(Button button) {
        if (button.getFont().equals((Object)JFaceResources.getDefaultFont())) {
            button.setFont(JFaceResources.getDialogFont());
        }
        GC gc = new GC((Drawable)button);
        gc.setFont(button.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int length = button.getText().length();
        int widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)(length < 2 ? 2 : length));
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    static int getButtonHeightHint(FormToolkit toolkit, Text text) {
        if (toolkit != null) {
            return text.computeSize((int)-1, (int)-1, (boolean)true).y + 5;
        }
        return text.computeSize((int)-1, (int)-1, (boolean)true).y;
    }

    private LayoutUtil() {
    }
}

