/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.internal.utility.JavaElementTools;
import org.eclipse.jpt.common.core.internal.utility.PackageFragmentRootTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.refactoring.AbstractJpaDeleteTypeParticipant;
import org.eclipse.jpt.jpa.core.refactoring.JptJpaCoreRefactoringMessages;
import org.eclipse.jpt.jpa.core.resource.ResourceMappingFile;
import org.eclipse.ltk.core.refactoring.participants.ISharableParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.text.edits.DeleteEdit;

public class JpaDeletePackageOrFolderParticipant
extends AbstractJpaDeleteTypeParticipant
implements ISharableParticipant {
    protected final Collection<IFolder> folders = new ArrayList<IFolder>();
    protected final Collection<IPackageFragment> packageFragments = new ArrayList<IPackageFragment>();
    protected static final Transformer<IPackageFragment, Iterable<IFile>> PACKAGE_FRAGMENT_NON_JAVA_FILES_TRANSFORMER = new PackageFragmentNonJavaFilesTransformer();

    public String getName() {
        return JptJpaCoreRefactoringMessages.JPA_DELETE_PACKAGE_OR_FOLDER_REFACTORING_PARTICIPANT_NAME;
    }

    protected boolean initialize(Object element) {
        if (this.getProcessor() instanceof RenameProcessor) {
            return false;
        }
        this.addElement(element, (RefactoringArguments)this.getArguments());
        return true;
    }

    public void addElement(Object element, RefactoringArguments arguments) {
        if (element instanceof IFolder) {
            IJavaElement javaElement = JavaCore.create((IFolder)((IFolder)element));
            if (javaElement != null) {
                if (javaElement.getElementType() == 3) {
                    this.addPackageFragmentRoot((IPackageFragmentRoot)javaElement);
                } else {
                    this.addPackageFragment((IPackageFragment)javaElement);
                }
            } else {
                this.addFolder((IFolder)element);
            }
        } else {
            this.addPackageFragment((IPackageFragment)element);
        }
    }

    protected void addFolder(IFolder folder) {
        this.folders.add(folder);
    }

    protected void addPackageFragmentRoot(IPackageFragmentRoot root) {
        if (PackageFragmentRootTools.isSourceFolder((IPackageFragmentRoot)root)) {
            IJavaElement[] iJavaElementArray = JavaElementTools.getChildren((IParent)root);
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement child = iJavaElementArray[n2];
                this.addPackageFragment((IPackageFragment)child);
                ++n2;
            }
        }
    }

    protected void addPackageFragment(IPackageFragment packageFragment) {
        this.packageFragments.add(packageFragment);
        HashSet<IType> allDeletedTypes = new HashSet<IType>();
        JpaDeletePackageOrFolderParticipant.addAffectedTypes(allDeletedTypes, packageFragment);
        for (IType deletedType : allDeletedTypes) {
            this.addType(deletedType);
        }
    }

    static void addAffectedTypes(Collection<IType> types, IPackageFragment fragment) {
        try {
            if (fragment.containsJavaResources()) {
                ICompilationUnit[] cunits = fragment.getCompilationUnits();
                IType type = null;
                int i = 0;
                while (i < cunits.length) {
                    type = cunits[i].findPrimaryType();
                    if (type != null) {
                        types.add(type);
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.instance().logError(ex);
        }
    }

    @Override
    protected Iterable<DeleteEdit> createPersistenceXmlDeleteEdits(PersistenceUnit persistenceUnit) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.createPersistenceXmlDeleteEdits(persistenceUnit), IterableTools.children(this.getMappingFilesOnClasspath(persistenceUnit.getJpaProject()), (Transformer)new PersistenceUnitDeleteEditsTransformer(persistenceUnit))});
    }

    protected Iterable<IFile> getMappingFilesOnClasspath(JpaProject jpaProject) {
        IJavaProject javaProject = jpaProject.getJavaProject();
        JpaPlatform jpaPlatform = jpaProject.getJpaPlatform();
        return IterableTools.filter((Iterable)IterableTools.concatenate((Iterable[])new Iterable[]{this.getPossibleMappingFilesInFolders(), this.getPossibleMappingFilesInPackageFragments()}), (Predicate)new FileIsMappingFileOnClasspath(javaProject, jpaPlatform));
    }

    protected Iterable<IFile> getPossibleMappingFilesInFolders() {
        ArrayList<IFile> files = new ArrayList<IFile>();
        FolderResourceProxyVisitor visitor = new FolderResourceProxyVisitor(files);
        for (IFolder folder : this.folders) {
            visitor.visitFolder(folder);
        }
        return files;
    }

    protected Iterable<IFile> getPossibleMappingFilesInPackageFragments() {
        return IterableTools.children(this.packageFragments, PACKAGE_FRAGMENT_NON_JAVA_FILES_TRANSFORMER);
    }

    protected static Iterable<IFile> getNonJavaFiles(IPackageFragment packageFragment) {
        Object[] resources;
        ArrayList<IFile> files = new ArrayList<IFile>();
        Object[] objectArray = resources = JpaDeletePackageOrFolderParticipant.getNonJavaResources(packageFragment);
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Object resource = objectArray[n2];
            if (resource instanceof IFile) {
                files.add((IFile)resource);
            }
            ++n2;
        }
        return files;
    }

    protected static Object[] getNonJavaResources(IPackageFragment packageFragment) {
        try {
            return packageFragment.getNonJavaResources();
        }
        catch (JavaModelException e) {
            JptJpaCorePlugin.instance().logError(e);
            return ObjectTools.EMPTY_OBJECT_ARRAY;
        }
    }

    public static class FileIsMappingFileOnClasspath
    extends PredicateAdapter<IFile> {
        private final IJavaProject javaProject;
        private final JpaPlatform jpaPlatform;

        public FileIsMappingFileOnClasspath(IJavaProject javaProject, JpaPlatform jpaPlatform) {
            this.javaProject = javaProject;
            this.jpaPlatform = jpaPlatform;
        }

        public boolean evaluate(IFile file) {
            if (this.javaProject.isOnClasspath((IResource)file)) {
                IContentType contentType = this.jpaPlatform.getContentType(file);
                return contentType != null && contentType.isKindOf(ResourceMappingFile.Root.CONTENT_TYPE);
            }
            return false;
        }
    }

    protected class FolderResourceProxyVisitor
    implements IResourceProxyVisitor {
        private Collection<IFile> files;

        protected FolderResourceProxyVisitor(Collection<IFile> files) {
            this.files = files;
        }

        protected void visitFolder(IFolder folder) {
            try {
                folder.accept((IResourceProxyVisitor)this, 0);
            }
            catch (CoreException ex) {
                throw new RuntimeException(ex);
            }
        }

        public boolean visit(IResourceProxy resource) {
            switch (resource.getType()) {
                case 2: {
                    return true;
                }
                case 1: {
                    this.files.add((IFile)resource.requestResource());
                    return false;
                }
            }
            return false;
        }
    }

    protected static class PackageFragmentNonJavaFilesTransformer
    extends TransformerAdapter<IPackageFragment, Iterable<IFile>> {
        protected PackageFragmentNonJavaFilesTransformer() {
        }

        public Iterable<IFile> transform(IPackageFragment packageFragment) {
            return JpaDeletePackageOrFolderParticipant.getNonJavaFiles(packageFragment);
        }
    }

    class PersistenceUnitDeleteEditsTransformer
    extends TransformerAdapter<IFile, Iterable<DeleteEdit>> {
        private final PersistenceUnit persistenceUnit;

        PersistenceUnitDeleteEditsTransformer(PersistenceUnit persistenceUnit) {
            this.persistenceUnit = persistenceUnit;
        }

        public Iterable<DeleteEdit> transform(IFile file) {
            return this.persistenceUnit.createDeleteMappingFileEdits(file);
        }
    }
}

