/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.predicate;

import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;

public class FieldPredicate<V>
implements Predicate<V> {
    private final String fieldName;

    public FieldPredicate(String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException();
        }
        this.fieldName = fieldName;
    }

    @Override
    public boolean evaluate(V variable) {
        return this.evaluate_(variable);
    }

    private Boolean evaluate_(V variable) {
        return (Boolean)ObjectTools.get(variable, this.fieldName);
    }

    public boolean equals(Object o) {
        if (!(o instanceof FieldPredicate)) {
            return false;
        }
        FieldPredicate other = (FieldPredicate)o;
        return ObjectTools.equals(this.fieldName, other.fieldName);
    }

    public int hashCode() {
        return this.fieldName.hashCode();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.fieldName);
    }
}

