/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.converter.jsfhtml;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.core.internal.tld.IJSFConstants;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.pagedesigner.converter.AbstractTagConverter;
import org.eclipse.jst.pagedesigner.converter.ConvertPosition;
import org.eclipse.jst.pagedesigner.converter.ConverterUtil;
import org.eclipse.jst.pagedesigner.converter.JSFConverterUtil;
import org.eclipse.jst.pagedesigner.jsf.core.dom.JSFDOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataTableTagConverter
extends AbstractTagConverter {
    private static final String FACET_NAME_HEADER = "header";

    public DataTableTagConverter(Element host) {
        super(host);
    }

    protected Element doConvertRefresh() {
        Element hostEle = this.getHostElement();
        Element tableEle = this.createElement("table");
        JSFConverterUtil.copyAllAttributes((Element)hostEle, (Element)tableEle, null);
        ConverterUtil.copyAttribute((Element)hostEle, (String)"styleClass", (Element)tableEle, (String)"class");
        tableEle.removeAttribute("styleClass");
        List columns = this.findUIColumns(hostEle);
        this.convertTHeader(hostEle, tableEle, columns, true);
        this.convertTBody(hostEle, tableEle, columns);
        this.convertTHeader(hostEle, tableEle, columns, false);
        return tableEle;
    }

    private List findUIColumns(Element hostEle) {
        ArrayList<Element> result = new ArrayList<Element>();
        Node child = hostEle.getFirstChild();
        if (child != null) {
            while (child != null) {
                Element ele;
                TagIdentifier tagId;
                if (child instanceof Element && IJSFConstants.TAG_IDENTIFIER_COLUMN.isSameTagType(tagId = TagIdentifierFactory.createDocumentTagWrapper((Element)(ele = (Element)child)))) {
                    result.add(ele);
                }
                child = child.getNextSibling();
            }
        }
        return result;
    }

    protected void convertTBody(Element hostEle, Element tableEle, List columns) {
        StringTokenizer tokenizer;
        Element tbodyEle = this.createElement("tbody");
        tableEle.appendChild(tbodyEle);
        Element trEle = this.createElement("tr");
        tbodyEle.appendChild(trEle);
        String rowClasses = tableEle.getAttribute("rowClasses");
        if (rowClasses != null && (tokenizer = new StringTokenizer(rowClasses, ", ")).hasMoreTokens()) {
            trEle.setAttribute("class", tokenizer.nextToken());
        }
        String columnClassesAttr = hostEle.getAttribute("columnClasses");
        ArrayList<String> columnClasses = new ArrayList<String>();
        if (columnClassesAttr != null) {
            StringTokenizer tokenizer2 = new StringTokenizer(columnClassesAttr, ", ");
            while (tokenizer2.hasMoreTokens()) {
                columnClasses.add(tokenizer2.nextToken());
            }
        }
        int i = 0;
        int size = columns.size();
        while (i < size) {
            Element column = (Element)columns.get(i);
            this.addChild(column, new ConvertPosition((Node)trEle, i));
            ++i;
        }
    }

    protected void convertTHeader(Element hostEle, Element tableEle, List columns, boolean header) {
        Element facetEle = JSFDOMUtil.findFacet(hostEle, header ? FACET_NAME_HEADER : "footer");
        boolean hasColHeader = false;
        int i = 0;
        int size = columns.size();
        while (i < size) {
            Element uicolumnEle = (Element)columns.get(i);
            Element columnFacet = JSFDOMUtil.findFacet(uicolumnEle, header ? FACET_NAME_HEADER : "footer");
            if (columnFacet != null) {
                hasColHeader = true;
                break;
            }
            ++i;
        }
        if (facetEle == null && !hasColHeader) {
            return;
        }
        Element theadEle = this.createElement(header ? "thead" : "tfoot");
        tableEle.appendChild(theadEle);
        if (facetEle != null) {
            Element trEle = this.createElement("tr");
            theadEle.appendChild(trEle);
            Element thEle = this.createElement(header ? "th" : "td");
            trEle.appendChild(thEle);
            ConverterUtil.copyAttribute((Element)hostEle, (String)(header ? "headerClass" : "footerClass"), (Element)thEle, (String)"class");
            if (columns.size() > 0) {
                thEle.setAttribute("colspan", String.valueOf(columns.size()));
            }
            this.addChild(facetEle, new ConvertPosition((Node)thEle, 0));
        }
        if (hasColHeader) {
            Element trEle = this.createElement("tr");
            theadEle.appendChild(trEle);
            int i2 = 0;
            int size2 = columns.size();
            while (i2 < size2) {
                Element uicolumnEle = (Element)columns.get(i2);
                Element columnFacet = JSFDOMUtil.findFacet(uicolumnEle, header ? FACET_NAME_HEADER : "footer");
                Element thEle = this.createElement(header ? "th" : "td");
                trEle.appendChild(thEle);
                if (columnFacet != null) {
                    this.addChild(columnFacet, new ConvertPosition((Node)thEle, 0));
                }
                ConverterUtil.copyAttribute((Element)hostEle, (String)(header ? "headerClass" : "footerClass"), (Element)thEle, (String)"class");
                ++i2;
            }
        }
    }

    public boolean isMultiLevel() {
        return true;
    }

    public boolean isWidget() {
        return false;
    }

    public boolean needBorderDecorator() {
        return false;
    }

    public boolean needTableDecorator() {
        return true;
    }
}

