/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.internal.contentoutline;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.json.core.document.IJSONDocument;
import org.eclipse.wst.json.core.document.IJSONNode;
import org.eclipse.wst.json.ui.internal.JSONUIMessages;

class RefreshStructureJob
extends Job {
    static final boolean DEBUG;
    private static final long UPDATE_DELAY = 300L;
    private final List<IJSONNode> fRefreshes;
    private final List fUpdates;
    private final List fUpdateProperties;
    Set fRefreshViewers = new HashSet(3);
    Set fUpdateViewers = new HashSet(3);

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/refreshStructure");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public RefreshStructureJob() {
        super(JSONUIMessages.refreshoutline_0);
        this.setPriority(30);
        this.setSystem(true);
        this.fRefreshes = new ArrayList<IJSONNode>(5);
        this.fUpdates = new ArrayList(5);
        this.fUpdateProperties = new ArrayList(5);
    }

    private synchronized void addUpdateRequest(IJSONNode newNodeRequest, String[] updateProperties) {
        this.fUpdates.add(newNodeRequest);
        this.fUpdateProperties.add(updateProperties);
    }

    private synchronized void addUpdateViewer(StructuredViewer viewer) {
        this.fUpdateViewers.add(viewer);
    }

    private synchronized void addRefreshRequest(IJSONNode newNodeRequest) {
        int size = this.fRefreshes.size();
        int i = 0;
        while (i < size) {
            IJSONNode existingNodeRequest = this.fRefreshes.get(i);
            if (existingNodeRequest.equals(newNodeRequest)) {
                return;
            }
            if (this.contains(existingNodeRequest, newNodeRequest)) {
                return;
            }
            if (this.contains(newNodeRequest, existingNodeRequest)) {
                this.fRefreshes.set(i, newNodeRequest);
                return;
            }
            ++i;
        }
        this.fRefreshes.add(newNodeRequest);
    }

    private synchronized void addRefreshViewer(StructuredViewer viewer) {
        this.fRefreshViewers.add(viewer);
    }

    protected void canceling() {
        this.fUpdates.clear();
        this.fUpdateViewers.clear();
        super.canceling();
    }

    private boolean contains(IJSONNode root, IJSONNode possible) {
        if (DEBUG) {
            System.out.println("==============================================================================================================");
            System.out.println("recursive call w/ root: " + root.getNodeName() + " and possible: " + possible);
            System.out.println("--------------------------------------------------------------------------------------------------------------");
        }
        if (root == null) {
            if (DEBUG) {
                System.out.println("returning false: root is null");
            }
            return false;
        }
        if (possible instanceof IJSONDocument) {
            if (DEBUG) {
                System.out.println("returning false: possible is Document node");
            }
            return false;
        }
        if (root instanceof IJSONDocument) {
            if (DEBUG) {
                System.out.println("returning true: root is Document node");
            }
            return true;
        }
        IJSONNode current = possible;
        while (current != null && current.getNodeType() != -1) {
            if (root.equals(current)) {
                if (DEBUG) {
                    System.out.println("   !!! found: " + possible.getNodeName() + " in subelement of: " + root.getNodeName());
                }
                return true;
            }
            current = current.getParentNode();
        }
        return false;
    }

    private void doRefresh(final IJSONNode node, final StructuredViewer[] viewers) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DEBUG) {
                    System.out.println("refresh on: [" + node.getNodeName() + "]");
                }
                int i = 0;
                while (i < viewers.length) {
                    if (!viewers[i].getControl().isDisposed()) {
                        if (node.getNodeType() == -1) {
                            viewers[i].refresh(true);
                        } else {
                            viewers[i].refresh((Object)node, true);
                        }
                    } else if (DEBUG) {
                        System.out.println("   !!! skipped refreshing disposed viewer: " + viewers[i]);
                    }
                    ++i;
                }
            }
        });
    }

    private void doUpdate(final StructuredViewer[] viewers, final IJSONNode node, final String[] properties) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DEBUG) {
                    System.out.println("refresh on: [" + node.getNodeName() + "]");
                }
                int i = 0;
                while (i < viewers.length) {
                    if (!viewers[i].getControl().isDisposed()) {
                        viewers[i].update((Object)node, properties);
                    } else if (DEBUG) {
                        System.out.println("   !!! skipped refreshing disposed viewer: " + viewers[i]);
                    }
                    ++i;
                }
            }
        });
    }

    private synchronized Object[] getRefreshRequests() {
        IJSONNode[] toRefresh = this.fRefreshes.toArray(new IJSONNode[this.fRefreshes.size()]);
        this.fRefreshes.clear();
        StructuredViewer[] viewers = this.fRefreshViewers.toArray(new StructuredViewer[this.fRefreshViewers.size()]);
        this.fRefreshViewers.clear();
        return new Object[]{toRefresh, viewers};
    }

    private synchronized Object[] getUpdateRequests() {
        IJSONNode[] toUpdate = this.fUpdates.toArray(new IJSONNode[this.fUpdates.size()]);
        this.fUpdates.clear();
        StructuredViewer[] viewers = this.fUpdateViewers.toArray(new StructuredViewer[this.fUpdateViewers.size()]);
        this.fUpdateViewers.clear();
        String[][] properties = (String[][])this.fUpdateProperties.toArray((T[])new String[this.fUpdateProperties.size()][]);
        this.fUpdateProperties.clear();
        return new Object[]{toUpdate, viewers, properties};
    }

    public void refresh(StructuredViewer viewer, IJSONNode node) {
        if (node == null) {
            return;
        }
        this.addRefreshViewer(viewer);
        this.addRefreshRequest(node);
        this.schedule(300L);
    }

    public void update(StructuredViewer viewer, IJSONNode node, String[] properties) {
        if (node == null) {
            return;
        }
        this.addUpdateViewer(viewer);
        this.addUpdateRequest(node, properties);
        this.schedule(300L);
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        try {
            this.performUpdates();
            this.performRefreshes(monitor);
        }
        finally {
            monitor.done();
        }
        return status;
    }

    private void performRefreshes(IProgressMonitor monitor) {
        Object[] requests = this.getRefreshRequests();
        IJSONNode[] nodes = (IJSONNode[])requests[0];
        StructuredViewer[] viewers = (StructuredViewer[])requests[1];
        int i = 0;
        while (i < nodes.length) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.doRefresh(nodes[i], viewers);
            ++i;
        }
    }

    private void performUpdates() {
        Object[] requests = this.getUpdateRequests();
        IJSONNode[] nodes = (IJSONNode[])requests[0];
        StructuredViewer[] viewers = (StructuredViewer[])requests[1];
        String[][] properties = (String[][])requests[2];
        int i = 0;
        while (i < nodes.length) {
            this.doUpdate(viewers, nodes[i], properties[i]);
            ++i;
        }
    }
}

