/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIMessages;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.jst.ws.internal.jaxws.ui.dialogs.HandlerChainSelectionDialog;
import org.eclipse.jst.ws.internal.jaxws.ui.dialogs.NewHandlerChainDialog;
import org.eclipse.jst.ws.internal.jaxws.ui.filters.NewHandlerChainViewerFilter;
import org.eclipse.jst.ws.internal.jaxws.ui.wizards.ConfigureHandlerWizard;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AddHandlerChainPage
extends WizardPage {
    private IStatus ok_status = new Status(0, "org.eclipse.jst.ws.jaxws.ui", "");
    private IStatus addNewHandlerChainStatus = Status.OK_STATUS;
    private IStatus editHandlerChainStatus = Status.OK_STATUS;
    private IType type;
    private Button createHandlerChainButton;
    private Text newHandlerChainText;
    private Button browseNewHandlerChainButton;
    private Button editHandlerChainButton;
    private Text exisitingHandlerChainText;
    private Button browseExistingHandlerChainButton;
    private boolean fileCreated;

    protected AddHandlerChainPage(IType type) {
        super("add.handlerchain.wizard.page");
        this.type = type;
        this.setTitle(JAXWSUIMessages.JAXWS_ADD_HANDLER_WIZARD_PAGE_TITLE);
        this.setDescription(JAXWSUIMessages.JAXWS_ADD_HANDLER_WIZARD_PAGE_DESCRIPTION);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = nColumns;
        composite.setLayout((Layout)gridLayout);
        this.createHandlerChainButton = new Button(composite, 16);
        this.createHandlerChainButton.setText(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 4;
        this.createHandlerChainButton.setLayoutData((Object)gridData);
        this.createHandlerChainButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                AddHandlerChainPage.this.enableNewHandlerChainFileWidgets(button.getSelection());
                AddHandlerChainPage.this.enableEditHandlerChainFileWidgets(!button.getSelection());
                AddHandlerChainPage.this.updateConfigureHandlerStatus();
            }
        });
        Label createNewHandlerLabel = new Label(composite, 0);
        createNewHandlerLabel.setText(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_FILE_PATH1);
        this.newHandlerChainText = new Text(composite, 2052);
        this.newHandlerChainText.setFont(composite.getFont());
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        this.newHandlerChainText.setLayoutData((Object)gridData);
        this.newHandlerChainText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                AddHandlerChainPage.this.updateConfigureHandlerStatus();
            }
        });
        this.browseNewHandlerChainButton = new Button(composite, 8);
        this.browseNewHandlerChainButton.setText(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_BROWSE1);
        gridData = new GridData(0x1000008, 4, false, false);
        this.browseNewHandlerChainButton.setLayoutData((Object)gridData);
        this.browseNewHandlerChainButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewHandlerChainDialog dialog = new NewHandlerChainDialog(AddHandlerChainPage.this.getShell(), (ILabelProvider)new JavaElementLabelProvider(), (ITreeContentProvider)new StandardJavaElementContentProvider());
                dialog.setInput(JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
                dialog.addFilter(new NewHandlerChainViewerFilter(AddHandlerChainPage.this.type.getJavaProject(), true, true));
                if (dialog.open() == 0) {
                    AddHandlerChainPage.this.newHandlerChainText.setText(dialog.getFilePath());
                    AddHandlerChainPage.this.updateConfigureHandlerStatus();
                }
            }
        });
        this.editHandlerChainButton = new Button(composite, 16);
        this.editHandlerChainButton.setText(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CHOOSE);
        gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 4;
        this.editHandlerChainButton.setLayoutData((Object)gridData);
        Label addToHandlerLabel = new Label(composite, 0);
        addToHandlerLabel.setText(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_FILE_PATH3);
        this.editHandlerChainButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddHandlerChainPage.this.updateConfigureHandlerStatus();
            }
        });
        this.exisitingHandlerChainText = new Text(composite, 2052);
        this.exisitingHandlerChainText.setFont(composite.getFont());
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalSpan = 2;
        this.exisitingHandlerChainText.setLayoutData((Object)gridData);
        this.exisitingHandlerChainText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                AddHandlerChainPage.this.updateConfigureHandlerStatus();
            }
        });
        this.browseExistingHandlerChainButton = new Button(composite, 8);
        this.browseExistingHandlerChainButton.setText(JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_BROWSE2);
        gridData = new GridData(4, 4, false, false);
        this.browseExistingHandlerChainButton.setLayoutData((Object)gridData);
        this.browseExistingHandlerChainButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HandlerChainSelectionDialog dialog = new HandlerChainSelectionDialog(AddHandlerChainPage.this.getShell(), (ILabelProvider)new JavaElementLabelProvider(), (ITreeContentProvider)new StandardJavaElementContentProvider());
                dialog.setInput(JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
                dialog.addFilter(new NewHandlerChainViewerFilter(AddHandlerChainPage.this.type.getJavaProject(), false, true));
                if (dialog.open() == 0) {
                    Object[] result = dialog.getResult();
                    IResource resource = (IResource)result[0];
                    AddHandlerChainPage.this.exisitingHandlerChainText.setText(resource.getFullPath().toOSString());
                    AddHandlerChainPage.this.updateConfigureHandlerStatus();
                }
            }
        });
        this.setInitialSelection();
        this.setControl((Control)composite);
    }

    private void setInitialSelection() {
        Path handlerChainPath = new Path(this.type.getResource().getParent().getFullPath().addTrailingSeparator() + "handler-chain.xml");
        IFile handlerChain = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)handlerChainPath);
        if (handlerChain.exists()) {
            this.editHandlerChainButton.setSelection(true);
            this.exisitingHandlerChainText.setText(handlerChainPath.toString());
            this.enableNewHandlerChainFileWidgets(false);
            this.enableEditHandlerChainFileWidgets(true);
        } else {
            this.createHandlerChainButton.setSelection(true);
            this.newHandlerChainText.setText(handlerChainPath.toString());
            this.enableNewHandlerChainFileWidgets(true);
            this.enableEditHandlerChainFileWidgets(false);
        }
        this.updateConfigureHandlerStatus();
    }

    public void setFileCreated(boolean fileCreated) {
        this.fileCreated = fileCreated;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.fileCreated) {
            ((ConfigureHandlerWizard)this.getWizard()).deleteFile((IPath)new Path(this.getNewHandlerChainPath()));
        }
    }

    private void enableEditHandlerChainFileWidgets(boolean enable) {
        this.exisitingHandlerChainText.setEnabled(enable);
        this.browseExistingHandlerChainButton.setEnabled(enable);
    }

    private void enableNewHandlerChainFileWidgets(boolean enable) {
        this.newHandlerChainText.setEnabled(enable);
        this.browseNewHandlerChainButton.setEnabled(enable);
    }

    public boolean isCreateHandlerChain() {
        return this.createHandlerChainButton.getSelection();
    }

    public boolean isEditHandlerChain() {
        return this.editHandlerChainButton.getSelection();
    }

    public String getNewHandlerChainPath() {
        return this.newHandlerChainText.getText();
    }

    public String getExistingHandlerChainPath() {
        return this.exisitingHandlerChainText.getText();
    }

    private void updateConfigureHandlerStatus() {
        try {
            this.validateNewHandlerChainField();
            this.validateExistingHandlerChainField();
            if (this.addNewHandlerChainStatus.getSeverity() != 0 || this.editHandlerChainStatus.getSeverity() != 0) {
                this.setErrorMessage(this.findMostSevere().getMessage());
                this.setPageComplete(false);
            } else {
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
    }

    private IStatus findMostSevere() {
        if (this.addNewHandlerChainStatus.getSeverity() > this.editHandlerChainStatus.getSeverity()) {
            return this.addNewHandlerChainStatus;
        }
        if (this.editHandlerChainStatus.getSeverity() > this.addNewHandlerChainStatus.getSeverity()) {
            return this.editHandlerChainStatus;
        }
        if (this.addNewHandlerChainStatus.getSeverity() == this.editHandlerChainStatus.getSeverity()) {
            return this.addNewHandlerChainStatus;
        }
        return this.addNewHandlerChainStatus;
    }

    private IStatus validateNewHandlerChainField() throws JavaModelException {
        if (this.isCreateHandlerChain()) {
            this.editHandlerChainStatus = this.ok_status;
            String newHandlerChainPath = this.getNewHandlerChainPath().trim();
            if (newHandlerChainPath.length() == 0) {
                this.addNewHandlerChainStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_NEW_HANDLER_PATH_EMTPY);
                return this.addNewHandlerChainStatus;
            }
            if (!newHandlerChainPath.endsWith(".xml")) {
                this.addNewHandlerChainStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_INVALID_NAME);
                return this.addNewHandlerChainStatus;
            }
            Path path = new Path(newHandlerChainPath);
            if (path.segmentCount() >= 2) {
                IPackageFragmentRoot[] packageFragmentRoots;
                String[] segmenets = path.segments();
                if (!segmenets[0].equals(this.type.getJavaProject().getElementName())) {
                    this.addNewHandlerChainStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.bind((String)JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_FILE_PROJECT, (Object)this.type.getJavaProject().getElementName()));
                    return this.addNewHandlerChainStatus;
                }
                boolean inSourceFolder = false;
                IPackageFragmentRoot[] iPackageFragmentRootArray = packageFragmentRoots = this.type.getJavaProject().getPackageFragmentRoots();
                int n = packageFragmentRoots.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                    if (segmenets[1].equals(packageFragmentRoot.getElementName())) {
                        inSourceFolder = true;
                        break;
                    }
                    ++n2;
                }
                if (!inSourceFolder) {
                    this.addNewHandlerChainStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.bind((String)JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_FILE_PROJECT, (Object)this.type.getJavaProject().getElementName()));
                    return this.addNewHandlerChainStatus;
                }
                if (path.lastSegment() != null && path.lastSegment().equals(".xml")) {
                    this.addNewHandlerChainStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_EMPTY_FILE_NAME);
                    return this.addNewHandlerChainStatus;
                }
            } else {
                this.addNewHandlerChainStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.bind((String)JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_FILE_PROJECT, (Object)this.type.getJavaProject().getElementName()));
                return this.addNewHandlerChainStatus;
            }
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (res != null && res.exists()) {
                this.addNewHandlerChainStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.bind((String)JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_FILE_EXISTS, (Object)res.getName()));
                return this.addNewHandlerChainStatus;
            }
            this.addNewHandlerChainStatus = this.ok_status;
            return this.addNewHandlerChainStatus;
        }
        this.addNewHandlerChainStatus = this.ok_status;
        return this.addNewHandlerChainStatus;
    }

    private IStatus validateExistingHandlerChainField() {
        if (this.isEditHandlerChain()) {
            this.addNewHandlerChainStatus = this.ok_status;
            String existingHandlerChainPath = this.getExistingHandlerChainPath().trim();
            if (existingHandlerChainPath.length() == 0) {
                this.editHandlerChainStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_EXISTING_HANDLER_PATH_EMTPY);
                return this.editHandlerChainStatus;
            }
            if (!existingHandlerChainPath.endsWith(".xml")) {
                this.editHandlerChainStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_INVALID_NAME);
                return this.editHandlerChainStatus;
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            Path path = new Path(existingHandlerChainPath);
            if (path.segmentCount() >= 2 && path.lastSegment() != null && path.lastSegment().equals(".xml")) {
                this.addNewHandlerChainStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_CREATE_DIALOG_EMPTY_FILE_NAME);
                return this.addNewHandlerChainStatus;
            }
            if (path.segmentCount() >= 2 && path.segment(0).equals(this.type.getJavaProject().getElementName()) && workspace.getRoot().getFile((IPath)path).exists()) {
                this.editHandlerChainStatus = this.ok_status;
                return this.editHandlerChainStatus;
            }
            this.editHandlerChainStatus = new Status(4, "org.eclipse.jst.ws.jaxws.ui", JAXWSUIMessages.bind((String)JAXWSUIMessages.JAXWS_HANDLER_CONFIGURATION_EDIT_FILE_NOT_FOUND, (Object)existingHandlerChainPath));
            return this.editHandlerChainStatus;
        }
        this.editHandlerChainStatus = this.ok_status;
        return this.editHandlerChainStatus;
    }
}

