/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.jsfappconfig;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.common.internal.componentcore.AbstractVirtualComponentQuery;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class AnnotationPackageFragmentRoot {
    private final IPackageFragmentRoot root;
    private final IJavaProject jProject;
    private final IPath webInfLibPath;
    private final IPath webInfClassesPath;

    public AnnotationPackageFragmentRoot(IPackageFragmentRoot root) {
        if (root != null && root.exists() && !root.isExternal()) {
            IPath webContentPath;
            IContainer webContentFolder;
            IVirtualFolder webContent;
            IProject project;
            this.root = root;
            IPath tempWebInfLibPath = null;
            IPath tempWebInfClassesPath = null;
            this.jProject = root.getJavaProject();
            if (this.jProject != null && (project = this.jProject.getProject()) != null && (webContent = new AbstractVirtualComponentQuery.DefaultVirtualComponentQuery().getWebContentFolder(project)) != null && (webContentFolder = webContent.getUnderlyingFolder()) != null && webContentFolder.exists() && (webContentPath = webContentFolder.getFullPath()) != null) {
                tempWebInfLibPath = webContentPath.append("WEB-INF/lib");
                tempWebInfClassesPath = webContentPath.append("WEB-INF/classes");
            }
            this.webInfClassesPath = tempWebInfClassesPath;
            this.webInfLibPath = tempWebInfLibPath;
        } else {
            this.root = null;
            this.webInfClassesPath = null;
            this.webInfLibPath = null;
            this.jProject = null;
        }
    }

    public final boolean canContainAnnotatedComponents() {
        if (this.root == null || !this.root.exists() || this.webInfClassesPath == null || this.webInfLibPath == null) {
            return false;
        }
        IPath rootPath = this.root.getPath();
        if (rootPath != null) {
            return this.isWebInfClasses(this.root) || this.isFacesArchive(rootPath);
        }
        return false;
    }

    private final boolean isWebInfClasses(IPackageFragmentRoot root_) {
        try {
            IClasspathEntry cpe = root_.getResolvedClasspathEntry();
            return cpe.getEntryKind() == 3;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private final boolean isFacesArchive(IPath rootPath) {
        if (this.webInfLibPath.isPrefixOf(rootPath)) {
            try {
                Object[] nonJavaResources = this.root.getNonJavaResources();
                if (nonJavaResources != null) {
                    Object[] objectArray = nonJavaResources;
                    int n = nonJavaResources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJarEntryResource jarEntry;
                        Object nonJavaResource = objectArray[n2];
                        if (nonJavaResource instanceof IJarEntryResource && !(jarEntry = (IJarEntryResource)nonJavaResource).isFile()) {
                            String entryName = jarEntry.getName();
                            if ("META-INF".equals(entryName)) {
                                IJarEntryResource[] metaInfContents;
                                IJarEntryResource[] iJarEntryResourceArray = metaInfContents = jarEntry.getChildren();
                                int n3 = metaInfContents.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IJarEntryResource resource = iJarEntryResourceArray[n4];
                                    if (resource.isFile() && "faces-config.xml".equals(resource.getName())) {
                                        return true;
                                    }
                                    ++n4;
                                }
                            } else if (entryName != null && jarEntry.getName().charAt(0) == '.') {
                                return this.hasDotFacesConfigFile(jarEntry);
                            }
                        }
                        ++n2;
                    }
                }
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return false;
    }

    private final boolean hasDotFacesConfigFile(IJarEntryResource jarEntry) {
        IJarEntryResource[] contents;
        IJarEntryResource[] iJarEntryResourceArray = contents = jarEntry.getChildren();
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            IJarEntryResource resource = iJarEntryResourceArray[n2];
            if (resource.isFile() ? ".faces-config.xml".equals(resource.getName()) : this.hasDotFacesConfigFile(resource)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

