/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.actions.single;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.actions.single.ChangeAttributeAction;
import org.eclipse.jst.pagedesigner.css2.CSSUtil;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;

public class StyleClassSupport {
    private static final String DEFAULT = PDPlugin.getResourceString("StyleClassSupport.Default");

    public static void createStyleClassActions(IMenuManager classmenu, IDOMElement ele) {
        String styleClassAttr = StyleClassSupport.getStyleClassAttributeName(ele);
        if (styleClassAttr == null) {
            return;
        }
        String styleClass = StyleClassSupport.getStyleClass(ele);
        boolean needAdditional = true;
        ChangeAttributeAction action = new ChangeAttributeAction(DEFAULT, ele, styleClassAttr, null);
        if (styleClass == null || styleClass.length() == 0) {
            action.setChecked(true);
            needAdditional = false;
        }
        classmenu.add((IAction)action);
        String[] classes = CSSUtil.getCSSClasses(ele.getOwnerDocument());
        if (classes.length > 0) {
            classmenu.add((IContributionItem)new Separator());
        }
        int i = 0;
        while (i < classes.length) {
            ChangeAttributeAction action2 = new ChangeAttributeAction(classes[i], ele, styleClassAttr, classes[i]);
            if (classes[i].equalsIgnoreCase(styleClass)) {
                action2.setChecked(true);
                needAdditional = false;
            }
            classmenu.add((IAction)action2);
            ++i;
        }
        if (needAdditional) {
            ChangeAttributeAction action2 = new ChangeAttributeAction(styleClass, ele, styleClassAttr, styleClass);
            action2.setChecked(true);
            classmenu.add((IAction)action2);
        }
    }

    public static String getStyleClass(IDOMElement ele) {
        String styleClassAttr = StyleClassSupport.getStyleClassAttributeName(ele);
        if (styleClassAttr != null) {
            return ele.getAttribute(styleClassAttr);
        }
        return null;
    }

    public static String getStyleClassAttributeName(IDOMElement ele) {
        CMElementDeclaration decl = CMUtil.getElementDeclaration((Element)ele);
        if (decl == null) {
            return null;
        }
        String taguri = CMUtil.getTagURI((CMElementDeclaration)decl);
        if (taguri == null || "html".equals(taguri)) {
            if (decl.getAttributes().getNamedItem("class") != null) {
                return "class";
            }
            return null;
        }
        if (decl.getAttributes().getNamedItem("styleClass") != null) {
            return "styleClass";
        }
        if (decl.getAttributes().getNamedItem("class") != null) {
            return "class";
        }
        return null;
    }
}

