/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.el.tests.util;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.jst.jsf.validation.el.tests.ELValidationTestPlugin;
import org.eclipse.jst.jsf.validation.el.tests.util.CreateTestCaseForJSP;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;

public class FindELRegions
extends TestCase {
    private static final String[] jspFiles = new String[]{"arithmeticAdd", "arithmeticDivide", "arithmeticMinus", "arithmeticModulo", "arithmeticMultiply", "assignability", "badSyntax", "beansProperties", "beanSubClass", "builtinSymbols", "complexArithmetic1", "complexComparison", "emptyOperator", "expressionTypeChecking", "greaterThan", "greaterThanEq", "htmlSyntax", "jspFunctions", "lessThan", "lessThanEq", "listBeans", "loadBundleExpressions", "logicalAND", "logicalEquals", "logicalNOT", "logicalNotEquals", "logicalOR", "methodBinding", "test", "unaryMinus", "variableNaming"};
    private static final IFile[] files = new IFile[jspFiles.length];
    private static final IStructuredModel[] models = new IStructuredModel[jspFiles.length];
    private WebProjectTestEnvironment _testEnv;

    protected void setUp() throws Exception {
        super.setUp();
        this._testEnv = new WebProjectTestEnvironment("ELValidationTest_" + this.getName());
        this._testEnv.createProject(false);
        FindELRegions.assertNotNull((Object)this._testEnv);
        FindELRegions.assertNotNull((Object)this._testEnv.getTestProject());
        FindELRegions.assertTrue((boolean)this._testEnv.getTestProject().isAccessible());
        int i = 0;
        while (i < jspFiles.length) {
            FindELRegions.files[i] = (IFile)this._testEnv.loadResourceInWebRoot(ELValidationTestPlugin.getDefault().getBundle(), "/testdata/jsps/" + jspFiles[i] + ".jsp.data", "/WEB-INF/" + jspFiles[i] + ".jsp");
            FindELRegions.models[i] = StructuredModelManager.getModelManager().getModelForRead(files[i]);
            ++i;
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        int i = 0;
        while (i < jspFiles.length) {
            models[i].releaseFromRead();
            ++i;
        }
    }

    public void testGenReport() {
        int i = 0;
        while (i < models.length) {
            this.printRegionsForModel(i);
            ++i;
        }
    }

    private void printRegionsForModel(int i) {
        IStructuredDocument document = models[i].getStructuredDocument();
        CreateTestCaseForJSP.ELRegionHandler handler = new CreateTestCaseForJSP.ELRegionHandler(){

            @Override
            public void handleRegion(ITextRegionCollection parentRegion, ITextRegion elRegion) {
                int contentStart = parentRegion.getStartOffset(elRegion);
                String elTextStr = "\"" + parentRegion.getText(elRegion) + "\"";
                System.out.println("assertEquals(" + elTextStr + ", getELText(_structuredDocument," + contentStart + "));");
            }
        };
        CreateTestCaseForJSP.processJSP(document, handler);
    }
}

