/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.core.xpath.tests;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import junit.framework.TestCase;
import org.eclipse.wst.xml.xpath.core.util.XSLTXPathHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TestXSLXPathHelper
extends TestCase {
    public void testInvalidXPath() {
        try {
            XSLTXPathHelper.compile((String)"starts-with('123', '123', '123)");
            TestXSLXPathHelper.fail((String)"Compiled successfully");
        }
        catch (XPathExpressionException xPathExpressionException) {}
    }

    public void testValidXPath() throws Exception {
        try {
            XSLTXPathHelper.compile((String)"concat('123', '123')");
        }
        catch (XPathExpressionException ex) {
            TestXSLXPathHelper.fail((String)"Failed to compile.");
            throw new Exception(ex.getMessage());
        }
    }

    public void testcreateXPathFromNode() throws Exception {
        DOMImplementation domImpl = this.createDOMImpl();
        Document document = domImpl.createDocument(null, "test", null);
        TestXSLXPathHelper.assertEquals((String)"Unexpected XPath value", (String)"/test", (String)XSLTXPathHelper.calculateXPathToNode((Node)document.getFirstChild()));
    }

    private DOMImplementation createDOMImpl() throws ParserConfigurationException {
        DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = documentFactory.newDocumentBuilder();
        DOMImplementation domImpl = builder.getDOMImplementation();
        return domImpl;
    }

    public void testCreateXPathFromNodeMultiple() throws Exception {
        DOMImplementation domImpl = this.createDOMImpl();
        Document document = domImpl.createDocument(null, "test", null);
        Element rootelem = document.getDocumentElement();
        Element elem1 = document.createElement("testNode1");
        Element elem2 = document.createElement("testNode1");
        rootelem.appendChild(elem1);
        rootelem.appendChild(elem2);
        TestXSLXPathHelper.assertEquals((String)"Unexepected XPath value", (String)"/test/testNode1[2]", (String)XSLTXPathHelper.calculateXPathToNode((Node)elem2));
    }

    public void testCreateXPathFromNodeAttribute() throws Exception {
        DOMImplementation domImpl = this.createDOMImpl();
        Document document = domImpl.createDocument(null, "test", null);
        Element rootelem = document.getDocumentElement();
        Element elem1 = document.createElement("testNode1");
        Element elem2 = document.createElement("testNode1");
        rootelem.appendChild(elem1);
        rootelem.appendChild(elem2);
        Attr attribute = document.createAttribute("attr");
        attribute.setValue("some value");
        elem2.setAttributeNode(attribute);
        TestXSLXPathHelper.assertEquals((String)"Unexpected XPath value", (String)"/test/testNode1[2]/@attr", (String)XSLTXPathHelper.calculateXPathToNode((Node)attribute));
    }
}

