/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.model.ecore.resource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.axis.model.common.notify.Adapter;
import org.apache.axis.model.common.notify.Notification;
import org.apache.axis.model.common.notify.NotificationChain;
import org.apache.axis.model.common.notify.impl.AdapterImpl;
import org.apache.axis.model.common.notify.impl.NotificationChainImpl;
import org.apache.axis.model.common.notify.impl.NotificationImpl;
import org.apache.axis.model.common.notify.impl.NotifierImpl;
import org.apache.axis.model.common.notify.impl.NotifyingListImpl;
import org.apache.axis.model.common.util.AbstractTreeIterator;
import org.apache.axis.model.common.util.EList;
import org.apache.axis.model.common.util.TreeIterator;
import org.apache.axis.model.common.util.URI;
import org.apache.axis.model.common.util.WrappedException;
import org.apache.axis.model.ecore.EObject;
import org.apache.axis.model.ecore.InternalEObject;
import org.apache.axis.model.ecore.resource.Resource;
import org.apache.axis.model.ecore.resource.ResourceSet;
import org.apache.axis.model.ecore.resource.URIConverter;
import org.apache.axis.model.ecore.resource.impl.URIConverterImpl;
import org.apache.axis.model.ecore.util.EcoreUtil;
import org.apache.axis.model.ecore.util.InternalEList;

public class ResourceImpl
extends NotifierImpl
implements Resource,
Resource.Internal {
    private static URIConverter defaultURIConverter;
    protected Map defaultSaveOptions;
    protected Map defaultLoadOptions;
    protected ResourceSet resourceSet;
    protected URI uri;
    protected ContentsEList contents;
    protected EList errors;
    protected EList warnings;
    protected boolean isModified;
    protected boolean isLoaded;
    protected boolean isLoading;
    protected Adapter modificationTrackingAdapter;
    protected Map intrinsicIDToEObjectMap;

    protected static URIConverter getDefaultURIConverter() {
        if (defaultURIConverter == null) {
            defaultURIConverter = new URIConverterImpl();
        }
        return defaultURIConverter;
    }

    protected static Map mergeMaps(Map map1, Map map2) {
        if (map1 == null || map1.isEmpty()) {
            return map2;
        }
        if (map2 == null || map2.isEmpty()) {
            return map1;
        }
        HashMap mergedMap = new HashMap(map2);
        mergedMap.putAll(map1);
        return mergedMap;
    }

    public ResourceImpl() {
    }

    public ResourceImpl(URI uri) {
        this();
        this.uri = uri;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public NotificationChain basicSetResourceSet(ResourceSet resourceSet, NotificationChain notifications) {
        ResourceSet oldResourceSet = this.resourceSet;
        if (oldResourceSet != null) {
            notifications = ((InternalEList)oldResourceSet.getResources()).basicRemove(this, notifications);
        }
        this.resourceSet = resourceSet;
        if (this.eNotificationRequired()) {
            if (notifications == null) {
                notifications = new NotificationChainImpl(2);
            }
            notifications.add(new NotificationImpl(1, (Object)oldResourceSet, resourceSet){

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID(Class expectedClass) {
                    return 0;
                }
            });
        }
        return notifications;
    }

    public URI getURI() {
        return this.uri;
    }

    public void setURI(URI uri) {
        URI oldURI = this.uri;
        this.uri = uri;
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(1, (Object)oldURI, uri){

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID(Class expectedClass) {
                    return 1;
                }
            };
            this.eNotify(notification);
        }
    }

    public EList getContents() {
        if (this.contents == null) {
            this.contents = new ContentsEList();
        }
        return this.contents;
    }

    public TreeIterator getAllContents() {
        return new AbstractTreeIterator(this, false){

            public Iterator getChildren(Object object) {
                return object == ResourceImpl.this ? ResourceImpl.this.getContents().iterator() : ((EObject)object).eContents().iterator();
            }
        };
    }

    protected TreeIterator getAllProperContents(EObject eObject) {
        return EcoreUtil.getAllProperContents(eObject, false);
    }

    protected TreeIterator getAllProperContents(List contents) {
        return new EcoreUtil.ContentTreeIterator(contents, false){

            public Iterator getChildren(Object object) {
                return object == this.object ? ((List)object).iterator() : new EcoreUtil.ProperContentIterator((EObject)object);
            }
        };
    }

    public EList getErrors() {
        if (this.errors == null) {
            this.errors = new NotifyingListImpl(){

                protected boolean isNotificationRequired() {
                    return ResourceImpl.this.eNotificationRequired();
                }

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID() {
                    return 6;
                }
            };
        }
        return this.errors;
    }

    public EList getWarnings() {
        if (this.warnings == null) {
            this.warnings = new NotifyingListImpl(){

                protected boolean isNotificationRequired() {
                    return ResourceImpl.this.eNotificationRequired();
                }

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID() {
                    return 7;
                }
            };
        }
        return this.warnings;
    }

    protected boolean useZip() {
        return false;
    }

    protected String getURIFragmentRootSegment(EObject eObject) {
        EList contents = this.getContents();
        return contents.size() > 1 ? Integer.toString(contents.indexOf(eObject)) : "";
    }

    public String getURIFragment(EObject eObject) {
        String id = EcoreUtil.getID(eObject);
        if (id != null) {
            return id;
        }
        InternalEObject internalEObject = (InternalEObject)eObject;
        if (internalEObject.eDirectResource() == this) {
            return "/" + this.getURIFragmentRootSegment(eObject);
        }
        ArrayList<String> uriFragmentPath = new ArrayList<String>();
        InternalEObject container = internalEObject.eInternalContainer();
        while (container != null) {
            uriFragmentPath.add(container.eURIFragmentSegment(internalEObject.eContainingFeature(), internalEObject));
            internalEObject = container;
            if (container.eDirectResource() == this) break;
            container = internalEObject.eInternalContainer();
        }
        StringBuffer result = new StringBuffer("/");
        result.append(this.getURIFragmentRootSegment(internalEObject));
        int i = uriFragmentPath.size() - 1;
        while (i >= 0) {
            result.append('/');
            result.append(uriFragmentPath.get(i));
            --i;
        }
        return result.toString();
    }

    protected EObject getEObjectForURIFragmentRootSegment(String uriFragmentRootSegment) {
        EList contents;
        int position = 0;
        if (uriFragmentRootSegment.length() > 0) {
            try {
                position = Integer.parseInt(uriFragmentRootSegment);
            }
            catch (NumberFormatException exception) {
                throw new WrappedException(exception);
            }
        }
        if (position < (contents = this.getContents()).size()) {
            return (EObject)contents.get(position);
        }
        return null;
    }

    public EObject getEObject(String uriFragment) {
        int length = uriFragment.length();
        if (length > 0) {
            int index;
            if (uriFragment.charAt(0) == '/') {
                ArrayList<String> uriFragmentPath = new ArrayList<String>(4);
                int start = 1;
                int i = 1;
                while (i < length) {
                    if (uriFragment.charAt(i) == '/') {
                        uriFragmentPath.add(start == i ? "" : uriFragment.substring(start, i));
                        start = i + 1;
                    }
                    ++i;
                }
                uriFragmentPath.add(uriFragment.substring(start));
                return this.getEObject(uriFragmentPath);
            }
            if (uriFragment.charAt(length - 1) == '?' && (index = uriFragment.lastIndexOf(63, length - 2)) > 0) {
                uriFragment = uriFragment.substring(0, index);
            }
        }
        return this.getEObjectByID(uriFragment);
    }

    protected EObject getEObject(List uriFragmentPath) {
        int size = uriFragmentPath.size();
        EObject eObject = this.getEObjectForURIFragmentRootSegment(size == 0 ? "" : (String)uriFragmentPath.get(0));
        int i = 1;
        while (i < size && eObject != null) {
            eObject = ((InternalEObject)eObject).eObjectForURIFragmentSegment((String)uriFragmentPath.get(i));
            ++i;
        }
        return eObject;
    }

    public Map getIntrinsicIDToEObjectMap() {
        return this.intrinsicIDToEObjectMap;
    }

    public void setIntrinsicIDToEObjectMap(Map intrinsicIDToEObjectMap) {
        this.intrinsicIDToEObjectMap = intrinsicIDToEObjectMap;
    }

    protected EObject getEObjectByID(String id) {
        EObject eObject;
        Map map = this.getIntrinsicIDToEObjectMap();
        if (map != null && (eObject = (EObject)map.get(id)) != null) {
            return eObject;
        }
        EObject result = null;
        TreeIterator i = this.getAllProperContents(this.getContents());
        while (i.hasNext()) {
            EObject eObject2 = (EObject)i.next();
            String eObjectId = EcoreUtil.getID(eObject2);
            if (eObjectId == null) continue;
            if (map != null) {
                map.put(eObjectId, eObject2);
            }
            if (!eObjectId.equals(id)) continue;
            result = eObject2;
            if (map == null) break;
        }
        return result;
    }

    public void attached(EObject eObject) {
        if (this.isAttachedDetachedHelperRequired()) {
            this.attachedHelper(eObject);
            TreeIterator tree = this.getAllProperContents(eObject);
            while (tree.hasNext()) {
                this.attachedHelper((EObject)tree.next());
            }
        }
    }

    protected boolean isAttachedDetachedHelperRequired() {
        return this.isTrackingModification() || this.getIntrinsicIDToEObjectMap() != null;
    }

    protected void attachedHelper(EObject eObject) {
        String id;
        Map map;
        if (this.isTrackingModification()) {
            eObject.eAdapters().add(this.modificationTrackingAdapter);
        }
        if ((map = this.getIntrinsicIDToEObjectMap()) != null && (id = EcoreUtil.getID(eObject)) != null) {
            map.put(id, eObject);
        }
    }

    protected final void addModificationTrackingAdapters(EObject eObject) {
    }

    public void detached(EObject eObject) {
        if (this.isAttachedDetachedHelperRequired()) {
            this.detachedHelper(eObject);
            TreeIterator tree = this.getAllProperContents(eObject);
            while (tree.hasNext()) {
                this.detachedHelper((EObject)tree.next());
            }
        }
    }

    protected void detachedHelper(EObject eObject) {
        String id;
        Map map = this.getIntrinsicIDToEObjectMap();
        if (map != null && (id = EcoreUtil.getID(eObject)) != null) {
            map.remove(id);
        }
        if (this.isTrackingModification()) {
            eObject.eAdapters().remove(this.modificationTrackingAdapter);
        }
    }

    protected final void removeModificationTrackingAdapters(EObject eObject) {
    }

    protected URIConverter getURIConverter() {
        return this.getResourceSet() == null ? ResourceImpl.getDefaultURIConverter() : this.getResourceSet().getURIConverter();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(Map options) throws IOException {
        URIConverter uriConverter = this.getURIConverter();
        OutputStream outputStream = uriConverter.createOutputStream(this.getURI());
        try {
            this.save(outputStream, options);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            outputStream.close();
            throw throwable;
        }
        {
            Object var5_6 = null;
        }
        outputStream.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(Map options) throws IOException {
        if (this.isLoaded) return;
        URIConverter uriConverter = this.getURIConverter();
        InputStream inputStream = uriConverter.createInputStream(this.getURI());
        try {
            this.load(inputStream, options);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.close();
            throw throwable;
        }
        {
            Object var5_6 = null;
        }
        inputStream.close();
    }

    protected ZipEntry newContentZipEntry() {
        return new ZipEntry("ResourceContents");
    }

    public final void save(OutputStream outputStream, Map options) throws IOException {
        URIConverter.Cipher cipher;
        if (this.errors != null) {
            this.errors.clear();
        }
        if (this.warnings != null) {
            this.warnings.clear();
        }
        URIConverter.Cipher cipher2 = cipher = (options = ResourceImpl.mergeMaps(options, this.defaultSaveOptions)) != null ? (URIConverter.Cipher)options.get("CIPHER") : null;
        if (cipher != null) {
            try {
                outputStream = cipher.encrypt(outputStream);
            }
            catch (Exception e) {
                throw new Resource.IOWrappedException(e);
            }
        }
        ZipOutputStream zipOutputStream = null;
        if (this.useZip() || options != null && Boolean.TRUE.equals(options.get("ZIP"))) {
            zipOutputStream = new ZipOutputStream(outputStream){

                public void finish() throws IOException {
                    super.finish();
                    this.def.end();
                }

                public void flush() {
                }

                public void close() throws IOException {
                    try {
                        super.flush();
                    }
                    catch (IOException iOException) {}
                    super.close();
                }
            };
            zipOutputStream.putNextEntry(this.newContentZipEntry());
            outputStream = zipOutputStream;
        }
        this.doSave(outputStream, options);
        if (cipher != null) {
            try {
                cipher.finish(outputStream);
            }
            catch (Exception e) {
                throw new Resource.IOWrappedException(e);
            }
        }
        this.setModified(false);
        if (zipOutputStream != null) {
            zipOutputStream.finish();
        }
    }

    protected void doSave(OutputStream outputStream, Map options) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected boolean isContentZipEntry(ZipEntry zipEntry) {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void load(InputStream inputStream, Map options) throws IOException {
        block14: {
            if (this.isLoaded) return;
            Notification notification = this.setLoaded(true);
            this.isLoading = true;
            if (this.errors != null) {
                this.errors.clear();
            }
            if (this.warnings != null) {
                this.warnings.clear();
            }
            try {
                URIConverter.Cipher cipher;
                if (this.useZip() || options != null && Boolean.TRUE.equals(options.get("ZIP"))) {
                    ZipInputStream zipInputStream = new ZipInputStream(inputStream);
                    while (zipInputStream.available() != 0) {
                        ZipEntry zipEntry = zipInputStream.getNextEntry();
                        if (!this.isContentZipEntry(zipEntry)) continue;
                        inputStream = zipInputStream;
                        break;
                    }
                }
                URIConverter.Cipher cipher2 = cipher = (options = ResourceImpl.mergeMaps(options, this.defaultLoadOptions)) != null ? (URIConverter.Cipher)options.get("CIPHER") : null;
                if (cipher != null) {
                    try {
                        inputStream = cipher.decrypt(inputStream);
                    }
                    catch (Exception e) {
                        throw new Resource.IOWrappedException(e);
                    }
                }
                this.doLoad(inputStream, options);
                if (cipher != null) {
                    try {
                        cipher.finish(inputStream);
                    }
                    catch (Exception e) {
                        throw new Resource.IOWrappedException(e);
                    }
                }
                Object var7_10 = null;
                this.isLoading = false;
                if (notification == null) break block14;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.isLoading = false;
                if (notification != null) {
                    this.eNotify(notification);
                }
                this.setModified(false);
                throw throwable;
            }
            this.eNotify(notification);
        }
        this.setModified(false);
    }

    protected void doLoad(InputStream inputStream, Map options) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public boolean isLoading() {
        return this.isLoading;
    }

    protected void unloaded(InternalEObject internalEObject) {
        internalEObject.eSetProxyURI(this.uri.appendFragment(this.getURIFragment(internalEObject)));
        internalEObject.eAdapters().clear();
    }

    protected Notification setLoaded(boolean isLoaded) {
        boolean oldIsLoaded = this.isLoaded;
        this.isLoaded = isLoaded;
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(1, oldIsLoaded, isLoaded){

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID(Class expectedClass) {
                    return 4;
                }
            };
            return notification;
        }
        return null;
    }

    protected void doUnload() {
        TreeIterator allContents = this.getAllProperContents(new ArrayList(this.getContents()));
        if (!this.getContents().isEmpty()) {
            this.getContents().clear();
        }
        this.getErrors().clear();
        this.getWarnings().clear();
        while (allContents.hasNext()) {
            this.unloaded((InternalEObject)allContents.next());
        }
    }

    public final void unload() {
        if (this.isLoaded) {
            Notification notification = this.setLoaded(false);
            this.doUnload();
            if (notification != null) {
                this.eNotify(notification);
            }
        }
    }

    public boolean isTrackingModification() {
        return this.modificationTrackingAdapter != null;
    }

    public void setTrackingModification(boolean isTrackingModification) {
        boolean oldIsTrackingModification;
        boolean bl = oldIsTrackingModification = this.modificationTrackingAdapter != null;
        if (oldIsTrackingModification != isTrackingModification) {
            if (isTrackingModification) {
                this.modificationTrackingAdapter = this.createModificationTrackingAdapter();
                TreeIterator i = this.getAllProperContents(this.getContents());
                while (i.hasNext()) {
                    EObject eObject = (EObject)i.next();
                    eObject.eAdapters().add(this.modificationTrackingAdapter);
                }
            } else {
                Adapter oldModificationTrackingAdapter = this.modificationTrackingAdapter;
                this.modificationTrackingAdapter = null;
                TreeIterator i = this.getAllProperContents(this.getContents());
                while (i.hasNext()) {
                    EObject eObject = (EObject)i.next();
                    eObject.eAdapters().remove(oldModificationTrackingAdapter);
                }
            }
        }
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(1, oldIsTrackingModification, isTrackingModification){

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID(Class expectedClass) {
                    return 5;
                }
            };
            this.eNotify(notification);
        }
    }

    protected Adapter createModificationTrackingAdapter() {
        return new ModificationTrackingAdapter();
    }

    public boolean isModified() {
        return this.isModified;
    }

    public void setModified(boolean isModified) {
        boolean oldIsModified = this.isModified;
        this.isModified = isModified;
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(1, oldIsModified, isModified){

                public Object getNotifier() {
                    return ResourceImpl.this;
                }

                public int getFeatureID(Class expectedClass) {
                    return 3;
                }
            };
            this.eNotify(notification);
        }
    }

    public String toKeyString() {
        StringBuffer result = new StringBuffer("Key type: ");
        result.append(this.getClass().toString());
        return result.toString();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '@' + Integer.toHexString(this.hashCode()) + " uri='" + this.uri + "'";
    }

    protected class ContentsEList
    extends NotifyingListImpl
    implements InternalEList {
        protected ContentsEList() {
        }

        public Object getNotifier() {
            return ResourceImpl.this;
        }

        public int getFeatureID() {
            return 2;
        }

        protected boolean isNotificationRequired() {
            return ResourceImpl.this.eNotificationRequired();
        }

        protected boolean useEquals() {
            return false;
        }

        protected boolean hasInverse() {
            return true;
        }

        protected boolean isUnique() {
            return true;
        }

        public NotificationChain inverseAdd(Object object, NotificationChain notifications) {
            InternalEObject eObject = (InternalEObject)object;
            notifications = eObject.eSetResource(ResourceImpl.this, notifications);
            ResourceImpl.this.attached(eObject);
            return notifications;
        }

        public NotificationChain inverseRemove(Object object, NotificationChain notifications) {
            InternalEObject eObject = (InternalEObject)object;
            if (ResourceImpl.this.isLoaded) {
                ResourceImpl.this.detached(eObject);
            }
            return eObject.eSetResource(null, notifications);
        }

        public Iterator basicIterator() {
            return super.basicIterator();
        }

        public ListIterator basicListIterator() {
            return super.basicListIterator();
        }

        public ListIterator basicListIterator(int index) {
            return super.basicListIterator(index);
        }

        public List basicList() {
            return super.basicList();
        }

        protected Object[] newData(int capacity) {
            return new EObject[capacity];
        }

        protected void didAdd(int index, Object object) {
            super.didAdd(index, object);
            if (index == this.size - 1) {
                this.loaded();
            }
            this.modified();
        }

        protected void didRemove(int index, Object object) {
            super.didRemove(index, object);
            this.modified();
        }

        protected void didSet(int index, Object newObject, Object oldObject) {
            super.didSet(index, newObject, oldObject);
            this.modified();
        }

        protected void didClear(int oldSize, Object[] oldData) {
            if (oldSize == 0) {
                this.loaded();
            } else {
                super.didClear(oldSize, oldData);
            }
        }

        protected void loaded() {
            Notification notification;
            if (!ResourceImpl.this.isLoaded() && (notification = ResourceImpl.this.setLoaded(true)) != null) {
                ResourceImpl.this.eNotify(notification);
            }
        }

        protected void modified() {
            if (ResourceImpl.this.isTrackingModification()) {
                ResourceImpl.this.setModified(true);
            }
        }
    }

    protected class ModificationTrackingAdapter
    extends AdapterImpl {
        protected ModificationTrackingAdapter() {
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getEventType()) {
                case 1: 
                case 2: 
                case 7: {
                    if (notification.isTouch()) break;
                    ResourceImpl.this.setModified(true);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    ResourceImpl.this.setModified(true);
                }
            }
        }
    }
}

