/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.core.internal.validation.eclipse;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.xml.core.internal.validation.core.NestedValidatorContext;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.eclipse.wst.xsd.core.internal.validation.eclipse.ValidatorWrapper;
import org.eclipse.wst.xsd.validation.tests.internal.XSDValidationTestsPlugin;

public class ValidatorTest
extends TestCase {
    ValidatorWrapper validator = new ValidatorWrapper();

    public static Test suite() {
        return new TestSuite(ValidatorTest.class);
    }

    public void testAddInfoToMessage() {
        String COLUMN_NUMBER_ATTRIBUTE = "columnNumber";
        String SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE = "squiggleSelectionStrategy";
        String SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE = "squiggleNameOrValue";
        ValidationMessage validationMessage = new ValidationMessage("", 1, 1, "");
        Message message = new Message();
        this.validator.addInfoToMessage(validationMessage, (IMessage)message);
        ValidatorTest.assertNull((String)("COLUMN_NUMBER_ATTRIBUTE was not null for a ValidationMessage with a null key. COLUMN_NUMBER_ATTRIBUTE = " + message.getAttribute(COLUMN_NUMBER_ATTRIBUTE)), (Object)message.getAttribute(COLUMN_NUMBER_ATTRIBUTE));
        ValidatorTest.assertNull((String)("SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE was not null for a ValidationMessage with a null key. SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE = " + message.getAttribute(SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE)), (Object)message.getAttribute(SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE));
        ValidatorTest.assertNull((String)("SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE was not null for a ValidationMessage with a null key. SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE = " + message.getAttribute(SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE)), (Object)message.getAttribute(SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE));
        ValidationMessage validationMessage2 = new ValidationMessage("", 1, 1, "", "s4s-elt-character", null);
        Message message2 = new Message();
        this.validator.addInfoToMessage(validationMessage2, (IMessage)message2);
        ValidatorTest.assertEquals((String)("COLUMN_NUMBER_ATTRIBUTE was correctly set to 1 for a ValidationMessage with the key s4s-elt-character. COLUMN_NUMBER_ATTRIBUTE = " + message2.getAttribute(COLUMN_NUMBER_ATTRIBUTE)), (Object)new Integer(1), (Object)message2.getAttribute(COLUMN_NUMBER_ATTRIBUTE));
        ValidatorTest.assertEquals((String)("SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE was not TEXT. SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE = " + message2.getAttribute(SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE)), (Object)"TEXT", (Object)message2.getAttribute(SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE));
        ValidatorTest.assertEquals((String)("SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE was not an empty string for a ValidationMessage with the key s4s-elt-character. SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE = " + message2.getAttribute(SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE)), (Object)"", (Object)message2.getAttribute(SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE));
        ValidationMessage validationMessage3 = new ValidationMessage("'MyName'", 1, 1, "", "src-resolve", null);
        Message message3 = new Message();
        this.validator.addInfoToMessage(validationMessage3, (IMessage)message3);
        ValidatorTest.assertEquals((String)("COLUMN_NUMBER_ATTRIBUTE was correctly set to 1 for a ValidationMessage with the key src-resolve. COLUMN_NUMBER_ATTRIBUTE = " + message3.getAttribute(COLUMN_NUMBER_ATTRIBUTE)), (Object)new Integer(1), (Object)message3.getAttribute(COLUMN_NUMBER_ATTRIBUTE));
        ValidatorTest.assertEquals((String)("SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE was not VALUE_OF_ATTRIBUTE_WITH_GIVEN_VALUE. SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE = " + message3.getAttribute(SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE)), (Object)"VALUE_OF_ATTRIBUTE_WITH_GIVEN_VALUE", (Object)message3.getAttribute(SQUIGGLE_SELECTION_STRATEGY_ATTRIBUTE));
        ValidatorTest.assertEquals((String)("SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE was not set to MyName for a ValidationMessage with the key src-resolve. SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE = " + message3.getAttribute(SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE)), (Object)"MyName", (Object)message3.getAttribute(SQUIGGLE_NAME_OR_VALUE_ATTRIBUTE));
    }

    public void testValidate() {
        try {
            ValidationReport report2;
            ValidationReport report1;
            block31: {
                InputStream is;
                String uri;
                String PLUGIN_ABSOLUTE_PATH;
                block29: {
                    PLUGIN_ABSOLUTE_PATH = XSDValidationTestsPlugin.getInstallURL();
                    uri = "file:///" + PLUGIN_ABSOLUTE_PATH + "testresources/samples/Paths/Dash-InPath/DashInPathValid.xsd";
                    report1 = this.validator.validate(uri, null, new NestedValidatorContext());
                    report2 = null;
                    is = null;
                    try {
                        try {
                            is = new URL(uri).openStream();
                            report2 = this.validator.validate(uri, is, new NestedValidatorContext());
                        }
                        catch (Exception e) {
                            ValidatorTest.fail((String)("A problem occurred while validating a valid file with an inputstream: " + e));
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block29;
                        }
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                ValidatorTest.assertTrue((String)"Validation using a URI did not product a valid validation result.", (boolean)report1.isValid());
                ValidatorTest.assertEquals((String)"Validation using URI and using inputstream of the same file produces different numbers of errors.", (int)report1.getValidationMessages().length, (int)report2.getValidationMessages().length);
                uri = "file:///" + PLUGIN_ABSOLUTE_PATH + "testresources/samples/Paths/Dash-InPath/DashInPathInvalid.xsd";
                report1 = this.validator.validate(uri, null, new NestedValidatorContext());
                report2 = null;
                is = null;
                try {
                    try {
                        is = new URL(uri).openStream();
                        report2 = this.validator.validate(uri, is, new NestedValidatorContext());
                    }
                    catch (Exception e) {
                        ValidatorTest.fail((String)("A problem occurred while validating an invalid file with an inputstream: " + e));
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block31;
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            ValidatorTest.assertFalse((String)"Validation using a URI did not product an invalid validation result.", (boolean)report1.isValid());
            ValidatorTest.assertEquals((String)"Validation using URI and using inputstream of the same file produces different numbers of errors.", (int)report1.getValidationMessages().length, (int)report2.getValidationMessages().length);
        }
        catch (Exception e) {
            ValidatorTest.fail((String)("Unable to locate plug-in location: " + e));
        }
    }
}

