/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.tests.contentassist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.web.ui.tests.contentassist.ContentAssistTestUtilities;
import org.eclipse.wst.jsdt.web.ui.tests.internal.TestProjectSetup;

public class ProposalInfoTest_Edited
extends TestCase {
    private static final String TEST_NAME = "Test Edited JavaScript Content Assist Proposal Info";
    private static TestProjectSetup fTestProjectSetup;

    public ProposalInfoTest_Edited() {
        super(TEST_NAME);
    }

    public ProposalInfoTest_Edited(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite(ProposalInfoTest_Edited.class, TEST_NAME);
        fTestProjectSetup = new TestProjectSetup((Test)ts, "JSDTWebContentAssist", "WebContent", false){

            @Override
            public void additionalSetUp() throws Exception {
                this.editFile("ProposalInfo.js", 1, 9, 5, "Earth");
                this.editFile("ProposalInfo.js", 8, 10, 5, "NC");
                this.editFile("ProposalInfo.js", 18, 13, 4, "Edit");
            }
        };
        return fTestProjectSetup;
    }

    public void testProposalInfo_AfterEdit_Expression_NotStarted() throws Exception {
        String[][] expectedProposals = new String[][]{{"HelloWorld() - Global", "HelloAmerica(State, City) - Global"}};
        String[][] expectedInfo = new String[][]{{"Hello Earth", "NC"}};
        ContentAssistTestUtilities.runProposalInfoTest(fTestProjectSetup, "ProposalInfo.html", 7, 0, expectedProposals, expectedInfo);
    }

    public void testProposalInfo_AfterEdit_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"HelloWorld() - Global", "HelloAmerica(State, City)  - Global"}};
        String[][] expectedInfo = new String[][]{{"Hello Earth", "Wake"}};
        ContentAssistTestUtilities.runProposalInfoTest(fTestProjectSetup, "ProposalInfo.html", 9, 3, expectedProposals, expectedInfo);
    }

    public void _testProposalInfo_AfterEdit_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"nodeOne : String - Global"}};
        String[][] expectedInfo = new String[][]{{"nodeOne = Edit"}};
        ContentAssistTestUtilities.runProposalInfoTest(fTestProjectSetup, "ProposalInfo.html", 11, 3, expectedProposals, expectedInfo);
    }
}

