/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.osgi.framework.Bundle;

public class ProxyFindSupport {
    private static final String BUILDPROPERTIES = "build.properties";
    private static final String PROXYJARS = "proxy.jars";

    public static URL[] platformFindAll(Bundle bundle, IPath filenameWithinBundle, boolean asLocal) {
        Bundle[] fragments = Platform.getFragments((Bundle)bundle);
        ArrayList<URL> urls = new ArrayList<URL>((fragments == null ? 0 : fragments.length) + 1);
        String filename = filenameWithinBundle.toString();
        URL url = ProxyFindSupport.internalFindFromBundleOnly(bundle, filename, asLocal);
        if (url != null) {
            urls.add(url);
        }
        if (fragments != null) {
            int i = 0;
            while (i < fragments.length) {
                Bundle fragment = fragments[i];
                url = ProxyFindSupport.internalFindFromBundleOnly(fragment, filename, asLocal);
                if (url != null) {
                    urls.add(url);
                }
                ++i;
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static URL internalFindFromBundleOnly(Bundle bundle, String filenameWithinBundle, boolean asLocal) {
        try {
            URL pvm = bundle.getEntry(filenameWithinBundle);
            if (pvm != null) {
                return asLocal ? FileLocator.toFileURL((URL)pvm) : pvm;
            }
        }
        catch (IOException iOException) {}
        if (ProxyPlugin.getPlugin().isDevMode()) {
            return ProxyFindSupport.findDev(bundle, filenameWithinBundle, asLocal);
        }
        return null;
    }

    public static URL platformFind(Bundle bundle, IPath filenameWithinBundle, boolean asLocal) {
        try {
            URL pvm = FileLocator.find((Bundle)bundle, (IPath)filenameWithinBundle, null);
            if (pvm != null) {
                return asLocal ? FileLocator.toFileURL((URL)pvm) : pvm;
            }
        }
        catch (IOException iOException) {}
        if (ProxyPlugin.getPlugin().isDevMode()) {
            return ProxyFindSupport.findDev(bundle, filenameWithinBundle.toString(), asLocal);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static URL findDev(Bundle bundle, String filenameWithinBundle, boolean asLocal) {
        String pathString;
        Properties props;
        InputStream ios;
        block13: {
            try {
                URL bp = bundle.getEntry(BUILDPROPERTIES);
                if (bp == null) break block13;
                ios = null;
                try {
                    URL pvm;
                    ios = bp.openStream();
                    props = new Properties();
                    props.load(ios);
                    pathString = props.getProperty("output." + filenameWithinBundle.toString());
                    if (pathString != null && (pvm = bundle.getEntry(pathString)) != null) {
                        URL uRL = asLocal ? FileLocator.toFileURL((URL)pvm) : pvm;
                        return uRL;
                    }
                }
                finally {
                    if (ios != null) {
                        ios.close();
                    }
                }
            }
            catch (IOException iOException) {}
        }
        try {
            URL pvm = bundle.getEntry(PROXYJARS);
            if (pvm == null) return null;
            ios = null;
            try {
                ios = pvm.openStream();
                props = new Properties();
                props.load(ios);
                pathString = props.getProperty(filenameWithinBundle.toString());
                if (pathString == null) return null;
                URL url = FileLocator.resolve((URL)bundle.getEntry("/"));
                if (!url.getProtocol().equals("file")) return null;
                File file = new File(url.getFile()).getParentFile();
                file = new File(file, pathString);
                URL uRL = file.toURL();
                return uRL;
            }
            finally {
                if (ios != null) {
                    ios.close();
                }
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public static URL[] platformFind(Bundle bundle) {
        return null;
    }
}

