/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal;

import org.eclipse.wst.wsdl.validation.internal.IWSDLValidator;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidatorDelegate;
import org.eclipse.wst.wsdl.validation.internal.logging.LoggerFactory;

public class ClassloaderWSDLValidatorDelegate
extends WSDLValidatorDelegate {
    private String validatorClassname = null;
    private ClassLoader classLoader = null;

    public ClassloaderWSDLValidatorDelegate(String validatorClassname) {
        this.validatorClassname = validatorClassname;
    }

    public ClassloaderWSDLValidatorDelegate(String validatorClassname, ClassLoader classLoader) {
        this(validatorClassname);
        this.classLoader = classLoader;
    }

    @Override
    protected IWSDLValidator loadValidator() {
        IWSDLValidator validator = null;
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
        try {
            Class<?> validatorClass = this.classLoader != null ? this.classLoader.loadClass(this.validatorClassname) : Class.forName(this.validatorClassname);
            validator = (IWSDLValidator)validatorClass.newInstance();
        }
        catch (Throwable t) {
            LoggerFactory.getInstance().getLogger().log("Unable to load validator " + this.validatorClassname, 0, t);
        }
        return validator;
    }

    @Override
    public String getValidatorName() {
        return this.validatorClassname;
    }
}

