/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.io;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.jpt.common.utility.internal.io.InvalidInputStream;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;

public class InvalidInputStreamTests
extends TestCase {
    private InputStream invalidInputStream;

    public InvalidInputStreamTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.invalidInputStream = InvalidInputStream.instance();
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testAvailable() throws IOException {
        InvalidInputStreamTests.assertEquals((int)0, (int)this.invalidInputStream.available());
    }

    public void testClose() throws IOException {
        this.invalidInputStream.close();
    }

    public void testMark() {
        this.invalidInputStream.mark(100);
    }

    public void testMarkSupported() {
        InvalidInputStreamTests.assertFalse((boolean)this.invalidInputStream.markSupported());
    }

    public void testRead() throws IOException {
        boolean exCaught = false;
        try {
            this.invalidInputStream.read();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        InvalidInputStreamTests.assertTrue((boolean)exCaught);
    }

    public void testReadByteArray() throws IOException {
        byte[] b = new byte[10];
        boolean exCaught = false;
        try {
            this.invalidInputStream.read(b);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        InvalidInputStreamTests.assertTrue((boolean)exCaught);
    }

    public void testReadByteArrayIntInt() throws IOException {
        byte[] b = new byte[10];
        boolean exCaught = false;
        try {
            this.invalidInputStream.read(b, 3, 2);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        InvalidInputStreamTests.assertTrue((boolean)exCaught);
    }

    public void testReset() {
        boolean exCaught = false;
        try {
            this.invalidInputStream.reset();
        }
        catch (IOException iOException) {
            exCaught = true;
        }
        InvalidInputStreamTests.assertTrue((boolean)exCaught);
    }

    public void testSkip() throws IOException {
        boolean exCaught = false;
        try {
            this.invalidInputStream.skip(44L);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            exCaught = true;
        }
        InvalidInputStreamTests.assertTrue((boolean)exCaught);
    }
}

