/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.datamodel.properties.IJ2EEComponentExportDataModelProperties;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.wizard.J2EEWizardNLS;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.j2ee.ui.archive.IArchiveExportParticipantPanelFactory;
import org.eclipse.jst.j2ee.ui.archive.internal.ArchiveExportParticipantPanelsExtensionPoint;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public abstract class J2EEExportPage
extends DataModelWizardPage {
    public static boolean isWindows = SWT.getPlatform().toLowerCase().startsWith("win");
    protected IStructuredSelection currentResourceSelection;
    private static final int SIZING_TEXT_FIELD_WIDTH = 305;
    protected static final String STORE_LABEL = "J2EE_EXPORT_";
    protected static final String OVERWRITE_LABEL = "OVERWRITE";
    protected static final String SOURCE_LABEL = "SOURCE";
    protected static final String defBrowseButtonLabel = J2EEUIMessages.getResourceString("93");
    protected String LABEL_DESTINATION = J2EEUIMessages.getResourceString("62");
    protected String LABEL_RUNTIME = J2EEUIMessages.getResourceString("103");
    private Combo resourceNameCombo;
    private Combo destinationNameCombo;
    private Button optimizeForRuntimeCheckbox;
    private Combo runtimeNameCombo;
    private Button destinationBrowseButton;
    protected Button overwriteExistingFilesCheckbox;
    private Button sourceFilesCheckbox;

    public J2EEExportPage(IDataModel model, String pageName, IStructuredSelection selection) {
        super(model, pageName);
        this.currentResourceSelection = selection;
        Object element = this.currentResourceSelection.getFirstElement();
        IProject project = ProjectUtilities.getProject((Object)element);
        if (project != null) {
            String projectName = project.getName();
            DataModelPropertyDescriptor[] validProjectNames = model.getValidPropertyDescriptors("IJ2EEComponentExportDataModelProperties.PROJECT_NAME");
            boolean projectNameSet = false;
            int i = 0;
            while (i < validProjectNames.length && !projectNameSet) {
                if (projectName.equals(validProjectNames[i].getPropertyDescription())) {
                    projectNameSet = true;
                    model.setProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME", (Object)projectName);
                }
                ++i;
            }
            if (!projectNameSet && validProjectNames.length > 0) {
                IProject[] earProjects = EarUtilities.getReferencingEARProjects((IProject)project);
                if (earProjects.length > 0) {
                    model.setProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME", (Object)earProjects[0].getName());
                } else {
                    model.setProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME", (Object)validProjectNames[0].getPropertyDescription());
                }
            }
        }
    }

    protected String[] getValidationPropertyNames() {
        return null;
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.createSourceAndDestinationGroup(composite);
        this.createRuntimeGroup(composite);
        this.createOptionsGroup(composite);
        this.setupInfopop((Control)composite);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private void createSourceAndDestinationGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        this.createExportComponentGroup(composite);
        this.createDestinationGroup(composite);
    }

    protected void createExportComponentGroup(Composite parent) {
        Label projectLabel = new Label(parent, 0);
        projectLabel.setText(this.getComponentLabel());
        this.resourceNameCombo = new Combo(parent, 2052);
        GridData data = new GridData(768);
        data.widthHint = 305;
        this.resourceNameCombo.setLayoutData((Object)data);
        this.synchHelper.synchCombo(this.resourceNameCombo, "IJ2EEComponentExportDataModelProperties.PROJECT_NAME", null);
        new Label(parent, 0);
    }

    protected abstract String getComponentLabel();

    protected void createDestinationGroup(Composite parent) {
        Label destinationLabel = new Label(parent, 0);
        destinationLabel.setText(this.LABEL_DESTINATION);
        this.destinationNameCombo = new Combo(parent, 2052);
        this.destinationNameCombo.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchCombo(this.destinationNameCombo, "IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION", null);
        this.destinationBrowseButton = new Button(parent, 8);
        this.destinationBrowseButton.setText(defBrowseButtonLabel);
        this.destinationBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                J2EEExportPage.this.handleDestinationBrowseButtonPressed();
            }
        });
        this.destinationBrowseButton.setEnabled(true);
    }

    protected void createRuntimeGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(this.LABEL_RUNTIME);
        this.optimizeForRuntimeCheckbox = new Button((Composite)group, 32);
        this.optimizeForRuntimeCheckbox.setText(J2EEWizardNLS.J2EEExportPage_Optimize_for_a_specific_server_runt_);
        this.synchHelper.synchCheckbox(this.optimizeForRuntimeCheckbox, "IJ2EEComponentExportDataModelProperties.OPTIMIZE_FOR_SPECIFIC_RUNTIME", null);
        GridData gd = new GridData();
        gd.verticalIndent = 2;
        this.optimizeForRuntimeCheckbox.setLayoutData((Object)gd);
        this.runtimeNameCombo = new Combo((Composite)group, 2060);
        this.runtimeNameCombo.setLayoutData((Object)new GridData(768));
        this.synchHelper.synchCombo(this.runtimeNameCombo, "IJ2EEComponentExportDataModelProperties.RUNTIME", null);
        final EnhancedComposite extComposite = new EnhancedComposite((Composite)group, 0);
        extComposite.setLayoutData(new GridData(768));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        layout.marginHeight = 1;
        extComposite.setLayout((Layout)layout);
        this.getDataModel().addListener(new IDataModelListener(){

            public void propertyChanged(DataModelEvent event) {
                if (event.getPropertyName().equals("IJ2EEComponentExportDataModelProperties.RUNTIME") && event.getFlag() == 1) {
                    J2EEExportPage.this.refreshExtensionsComposite(extComposite, true);
                } else if (event.getPropertyName().equals("IJ2EEComponentExportDataModelProperties.OPTIMIZE_FOR_SPECIFIC_RUNTIME") && event.getFlag() == 1) {
                    boolean optimize = (Boolean)event.getProperty();
                    extComposite.setEnabled(optimize);
                }
            }
        });
        this.refreshExtensionsComposite(extComposite, false);
    }

    private void refreshExtensionsComposite(Composite extComposite, boolean forceRefresh) {
        Control[] controlArray = extComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        List extensions = (List)this.getDataModel().getProperty("IJ2EEComponentExportDataModelProperties.RUNTIME_SPECIFIC_PARTICIPANTS");
        if (extensions != null) {
            EnhancedComposite innerComposite = null;
            for (IJ2EEComponentExportDataModelProperties.IArchiveExportParticipantData extension : extensions) {
                IArchiveExportParticipantPanelFactory panelFactory;
                String id = extension.getId();
                ArchiveExportParticipantPanelsExtensionPoint.PanelFactoryInfo panelExtInfo = ArchiveExportParticipantPanelsExtensionPoint.getExtension(id);
                if (panelExtInfo == null || (panelFactory = panelExtInfo.loadPanelFactory()) == null) continue;
                if (innerComposite == null) {
                    innerComposite = new EnhancedComposite(extComposite, 0);
                    innerComposite.setLayoutData(new GridData(1808));
                    GridLayout innerCompositeLayout = new GridLayout(1, false);
                    innerCompositeLayout.marginWidth = 0;
                    innerCompositeLayout.marginHeight = 0;
                    innerComposite.setLayout((Layout)innerCompositeLayout);
                }
                try {
                    panelFactory.createPanel(innerComposite, extension.getDataModel());
                }
                catch (Exception e) {
                    J2EEUIPlugin.logError(-1, e.getMessage(), e);
                }
            }
        }
        if (forceRefresh) {
            extComposite.getShell().layout(true, true);
        }
    }

    protected void createOptionsGroup(Composite parent) {
        Composite optionsGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        optionsGroup.setLayout((Layout)layout);
        this.createSourceFilesCheckbox(optionsGroup);
        this.createOverwriteExistingFilesCheckbox(optionsGroup);
        if (this.shouldShowProjectFilesCheckbox()) {
            this.createProjectFilesCheckbox(optionsGroup);
        }
    }

    protected void createOverwriteExistingFilesCheckbox(Composite optionsGroup) {
        this.overwriteExistingFilesCheckbox = new Button(optionsGroup, 16416);
        this.overwriteExistingFilesCheckbox.setText(J2EEUIMessages.getResourceString("63"));
        this.overwriteExistingFilesCheckbox.setEnabled(true);
        this.synchHelper.synchCheckbox(this.overwriteExistingFilesCheckbox, "IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING", null);
    }

    protected void createSourceFilesCheckbox(Composite optionsGroup) {
        this.sourceFilesCheckbox = new Button(optionsGroup, 16416);
        this.sourceFilesCheckbox.setText(J2EEUIMessages.getResourceString("64"));
        this.synchHelper.synchCheckbox(this.sourceFilesCheckbox, "IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES", null);
    }

    protected boolean shouldShowProjectFilesCheckbox() {
        return false;
    }

    protected void createProjectFilesCheckbox(Composite composite) {
    }

    protected void setupBasedOnInitialSelections() {
        if (this.currentResourceSelection.isEmpty() || this.setupBasedOnRefObjectSelection()) {
            return;
        }
        ArrayList<IResource> selections = new ArrayList<IResource>();
        for (IResource currentResource : this.currentResourceSelection) {
            if (!currentResource.isAccessible()) continue;
            selections.add(currentResource);
        }
        if (selections.isEmpty()) {
            return;
        }
    }

    protected String getProjectImportLabel() {
        return null;
    }

    protected void handleDestinationBrowseButtonPressed() {
        String filename;
        FileDialog dialog = new FileDialog(this.destinationNameCombo.getShell(), 8192);
        Object fileName = this.getDataModel().getStringProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME");
        String[] filters = this.getFilterExpression();
        if (!isWindows && filters.length != 0 && filters[0] != null && filters[0].indexOf(46) != -1) {
            fileName = (String)fileName + filters[0].substring(filters[0].indexOf(46));
        }
        dialog.setFileName((String)fileName);
        if (isWindows) {
            dialog.setFilterExtensions(filters);
        }
        if ((filename = dialog.open()) != null) {
            this.destinationNameCombo.setText(filename);
        }
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_LABEL + this.getFileNamesStoreID());
            if (sourceNames == null) {
                return;
            }
            int i = 0;
            while (i < sourceNames.length) {
                if (sourceNames[i] == null) {
                    sourceNames[i] = "";
                }
                ++i;
            }
            this.destinationNameCombo.setItems(sourceNames);
            boolean overwrite = settings.getBoolean("J2EE_EXPORT_OVERWRITE");
            this.model.setBooleanProperty("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING", overwrite);
            boolean includeSource = settings.getBoolean("J2EE_EXPORT_SOURCE");
            this.model.setBooleanProperty("IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES", includeSource);
        }
    }

    public void storeDefaultSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_LABEL + this.getFileNamesStoreID());
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            String newName = this.destinationNameCombo.getText();
            ArrayList<String> newNames = new ArrayList<String>();
            int i = 0;
            while (i < sourceNames.length && i < 5) {
                if (sourceNames[i].trim().length() > 0 && !newName.equals(sourceNames[i])) {
                    newNames.add(sourceNames[i]);
                }
                ++i;
            }
            newNames.add(0, this.destinationNameCombo.getText());
            sourceNames = new String[newNames.size()];
            newNames.toArray(sourceNames);
            settings.put(STORE_LABEL + this.getFileNamesStoreID(), sourceNames);
            settings.put("J2EE_EXPORT_OVERWRITE", this.model.getBooleanProperty("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING"));
            settings.put("J2EE_EXPORT_SOURCE", this.model.getBooleanProperty("IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES"));
        }
    }

    protected String getFileNamesStoreID() {
        return this.getComponentID();
    }

    @Deprecated
    protected String getCompnentID() {
        return null;
    }

    protected String getComponentID() {
        return this.getCompnentID();
    }

    protected String[] getFilterExpression() {
        return new String[0];
    }

    protected void enter() {
        super.enter();
        this.restoreWidgetValues();
    }

    protected abstract boolean isMetaTypeSupported(Object var1);

    protected boolean setupBasedOnRefObjectSelection() {
        if (this.currentResourceSelection.size() != 1) {
            return false;
        }
        Object o = this.currentResourceSelection.getFirstElement();
        if (!this.isMetaTypeSupported(o)) {
            return false;
        }
        EObject ref = (EObject)o;
        IProject resource = ProjectUtilities.getProject((EObject)ref);
        if (resource != null) {
            this.resourceNameCombo.setText(resource.getName().toString());
        }
        return true;
    }

    protected IDialogSettings getDialogSettings() {
        return J2EEUIPlugin.getDefault().getDialogSettings();
    }

    private static class EnhancedComposite
    extends Composite {
        public EnhancedComposite(Composite parent, int style) {
            super(parent, style);
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            Control[] controlArray = this.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.setEnabled(enabled);
                ++n2;
            }
        }
    }
}

