/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.tests.document;

import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.wst.sse.core.internal.text.CharSequenceReader;

public class TestCharSequenceReader
extends TestCase {
    String fStandardString = "test123";

    public TestCharSequenceReader() {
    }

    public TestCharSequenceReader(String name) {
        super(name);
    }

    public void testStandardBeginning() {
        CharSequenceReader reader = new CharSequenceReader((CharSequence)this.fStandardString, 0, 3);
        char char1 = (char)reader.read();
        TestCharSequenceReader.assertTrue((char1 == 't' ? 1 : 0) != 0);
        char char2 = (char)reader.read();
        TestCharSequenceReader.assertTrue((char2 == 'e' ? 1 : 0) != 0);
        char char3 = (char)reader.read();
        TestCharSequenceReader.assertTrue((char3 == 's' ? 1 : 0) != 0);
        int eof = reader.read();
        TestCharSequenceReader.assertTrue((eof == -1 ? 1 : 0) != 0);
    }

    public void testStandardMiddle() {
        CharSequenceReader reader = new CharSequenceReader((CharSequence)this.fStandardString, 2, 3);
        char char1 = (char)reader.read();
        TestCharSequenceReader.assertTrue((char1 == 's' ? 1 : 0) != 0);
        char char2 = (char)reader.read();
        TestCharSequenceReader.assertTrue((char2 == 't' ? 1 : 0) != 0);
        char char3 = (char)reader.read();
        TestCharSequenceReader.assertTrue((char3 == '1' ? 1 : 0) != 0);
        int eof = reader.read();
        TestCharSequenceReader.assertTrue((eof == -1 ? 1 : 0) != 0);
    }

    public void testStandardEnd() {
        CharSequenceReader reader = new CharSequenceReader((CharSequence)this.fStandardString, 4, 3);
        char char1 = (char)reader.read();
        TestCharSequenceReader.assertTrue((char1 == '1' ? 1 : 0) != 0);
        char char2 = (char)reader.read();
        TestCharSequenceReader.assertTrue((char2 == '2' ? 1 : 0) != 0);
        char char3 = (char)reader.read();
        TestCharSequenceReader.assertTrue((char3 == '3' ? 1 : 0) != 0);
        int eof = reader.read();
        TestCharSequenceReader.assertTrue((eof == -1 ? 1 : 0) != 0);
    }

    public void testStandardOutOfRange() {
        CharSequenceReader reader = new CharSequenceReader((CharSequence)this.fStandardString, 50, 3);
        int eof = reader.read();
        TestCharSequenceReader.assertTrue((eof == -1 ? 1 : 0) != 0);
    }

    public void testStandardPartiallyOutOfRange() {
        CharSequenceReader reader = new CharSequenceReader((CharSequence)this.fStandardString, 5, 3);
        char char1 = (char)reader.read();
        TestCharSequenceReader.assertTrue((char1 == '2' ? 1 : 0) != 0);
        char char2 = (char)reader.read();
        TestCharSequenceReader.assertTrue((char2 == '3' ? 1 : 0) != 0);
        int eof = reader.read();
        TestCharSequenceReader.assertTrue((eof == -1 ? 1 : 0) != 0);
    }

    public void testBufferBegining() throws IOException {
        CharSequenceReader reader = new CharSequenceReader((CharSequence)this.fStandardString, 0, 3);
        String targetString = "tes";
        char[] charbuffer = new char[2];
        StringBuffer stringBuffer = new StringBuffer();
        int nRead = 0;
        while (nRead != -1) {
            nRead = reader.read(charbuffer);
            if (nRead <= 0) continue;
            stringBuffer.append(charbuffer, 0, nRead);
        }
        String testString = stringBuffer.toString();
        TestCharSequenceReader.assertEquals((String)targetString, (String)testString);
    }

    public void testBufferEnd() throws IOException {
        CharSequenceReader reader = new CharSequenceReader((CharSequence)this.fStandardString, 4, 3);
        String targetString = "123";
        char[] charbuffer = new char[2];
        StringBuffer stringBuffer = new StringBuffer();
        int nRead = 0;
        while (nRead != -1) {
            nRead = reader.read(charbuffer);
            if (nRead <= 0) continue;
            stringBuffer.append(charbuffer, 0, nRead);
        }
        String testString = stringBuffer.toString();
        TestCharSequenceReader.assertEquals((String)targetString, (String)testString);
    }

    public void testBufferEndEnlarged() throws IOException {
        CharSequenceReader reader = new CharSequenceReader((CharSequence)this.fStandardString, 4, 3);
        String targetString = "123";
        char[] charbuffer = new char[200];
        StringBuffer stringBuffer = new StringBuffer();
        int nRead = 0;
        while (nRead != -1) {
            nRead = reader.read(charbuffer);
            if (nRead <= 0) continue;
            stringBuffer.append(charbuffer, 0, nRead);
        }
        String testString = stringBuffer.toString();
        TestCharSequenceReader.assertEquals((String)targetString, (String)testString);
    }

    public void testBufferBeginingEnlarged() throws IOException {
        CharSequenceReader reader = new CharSequenceReader((CharSequence)this.fStandardString, 0, 3);
        String targetString = "tes";
        char[] charbuffer = new char[200];
        StringBuffer stringBuffer = new StringBuffer();
        int nRead = 0;
        while (nRead != -1) {
            nRead = reader.read(charbuffer);
            if (nRead <= 0) continue;
            stringBuffer.append(charbuffer, 0, nRead);
        }
        String testString = stringBuffer.toString();
        TestCharSequenceReader.assertEquals((String)targetString, (String)testString);
    }

    public void testBufferBeginingReduced() throws IOException {
        CharSequenceReader reader = new CharSequenceReader((CharSequence)this.fStandardString, 0, 3);
        String targetString = "te";
        char[] charbuffer = new char[2];
        StringBuffer stringBuffer = new StringBuffer();
        int nRead = 0;
        nRead = reader.read(charbuffer, 0, 2);
        if (nRead > 0) {
            stringBuffer.append(charbuffer, 0, nRead);
        }
        String testString = stringBuffer.toString();
        TestCharSequenceReader.assertEquals((String)targetString, (String)testString);
        targetString = "s";
        stringBuffer = new StringBuffer();
        nRead = 0;
        nRead = reader.read(charbuffer, 0, 2);
        if (nRead > 0) {
            stringBuffer.append(charbuffer, 0, nRead);
        }
        testString = stringBuffer.toString();
        TestCharSequenceReader.assertEquals((String)targetString, (String)testString);
    }
}

