/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions;

import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import org.eclipse.wst.ws.internal.explorer.platform.actions.LinkAction;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLMainNode;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLNode;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.perspective.WSDLPerspective;

public class RefreshWSDLAction
extends LinkAction {
    public RefreshWSDLAction(Controller controller) {
        super(controller);
    }

    public static String getActionLink(int nodeID, int toolID, int viewID, int viewToolID) {
        StringBuffer actionLink = new StringBuffer("wsdl/actions/WSDLRefreshActionJSP.jsp?");
        actionLink.append("nodeId");
        actionLink.append('=');
        actionLink.append(nodeID);
        actionLink.append('&');
        actionLink.append("toolId");
        actionLink.append('=');
        actionLink.append(toolID);
        actionLink.append('&');
        actionLink.append("viewId");
        actionLink.append('=');
        actionLink.append(viewID);
        actionLink.append('&');
        actionLink.append("viewToolId");
        actionLink.append('=');
        actionLink.append(viewToolID);
        return actionLink.toString();
    }

    @Override
    protected boolean processLinkParameters(HttpServletRequest request) {
        int nodeID;
        NodeManager nodeManager = this.controller_.getWSDLPerspective().getNodeManager();
        String nodeIDString = request.getParameter("nodeId");
        try {
            nodeID = Integer.parseInt(nodeIDString);
        }
        catch (NumberFormatException numberFormatException) {
            nodeID = nodeManager.getSelectedNodeId();
        }
        Node node = nodeManager.getNode(nodeID);
        while (node != null && !(node instanceof WSDLMainNode)) {
            if (node instanceof WSDLNode) {
                this.propertyTable_.put("nodeId", String.valueOf(node.getNodeId()));
                return true;
            }
            node = node.getParent();
        }
        return false;
    }

    @Override
    public boolean run() {
        int nodeID = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        WSDLPerspective wsdlPerspective = this.controller_.getWSDLPerspective();
        MessageQueue messageQueue = wsdlPerspective.getMessageQueue();
        NodeManager nodeManager = wsdlPerspective.getNodeManager();
        Node wsdlNode = nodeManager.getNode(nodeID);
        WSDLElement wsdlElement = (WSDLElement)wsdlNode.getTreeElement();
        Definition definitionCopy = wsdlElement.getDefinition();
        Vector schemaListCopy = wsdlElement.getSchemaList();
        wsdlElement.setDefinition(null);
        wsdlElement.setSchemaList(new Vector());
        int selectedNodeID = nodeManager.getSelectedNode().getNodeId();
        try {
            Vector errorMessages = wsdlElement.loadWSDL();
            if (errorMessages.size() > 0) {
                messageQueue.addMessage(wsdlPerspective.getMessage("MSG_ERROR_XSD_VALIDATION"));
                int i = 0;
                while (i < errorMessages.size()) {
                    messageQueue.addMessage((String)errorMessages.elementAt(i));
                    ++i;
                }
            }
        }
        catch (WSDLException e) {
            messageQueue.addMessage(wsdlPerspective.getMessage("MSG_ERROR_OPEN_WSDL", wsdlElement.getWsdlUrl()));
            this.handleUnexpectedException(wsdlPerspective, messageQueue, "WSDLException", e);
            wsdlElement.setDefinition(definitionCopy);
            wsdlElement.setSchemaList(schemaListCopy);
            return false;
        }
        wsdlElement.buildModel();
        Node node = nodeManager.getNode(selectedNodeID);
        if (node == null) {
            selectedNodeID = wsdlNode.getNodeId();
            Vector serviceNodes = wsdlNode.getChildNodes();
            if (serviceNodes.size() == 1) {
                Node serviceNode = (Node)serviceNodes.elementAt(0);
                Vector bindingNodes = serviceNode.getChildNodes();
                if (bindingNodes.size() == 1) {
                    Node bindingNode = (Node)bindingNodes.elementAt(0);
                    selectedNodeID = bindingNode.getNodeId();
                } else {
                    selectedNodeID = serviceNode.getNodeId();
                }
            }
            nodeManager.setSelectedNodeId(selectedNodeID);
            nodeManager.makeNodeVisible(nodeManager.getNode(selectedNodeID));
        }
        messageQueue.addMessage(wsdlPerspective.getMessage("MSG_INFO_REFRESH_WSDL_SUCCESSFUL", wsdlElement.getWsdlUrl()));
        return true;
    }
}

