/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.commands.ICustomizableCommand;
import org.eclipse.jst.pagedesigner.commands.SourceViewerCommand;
import org.eclipse.jst.pagedesigner.dnd.internal.SourceViewerDragDropHelper;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.editors.palette.IDropSourceData;
import org.eclipse.jst.pagedesigner.itemcreation.customizer.DropCustomizationController;
import org.eclipse.jst.pagedesigner.utils.CommandUtil;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PaletteDropInsertCommand
extends SourceViewerCommand
implements ICustomizableCommand {
    private final Logger _log = PDPlugin.getLogger(PaletteDropInsertCommand.class);
    private IDropSourceData _creationProvider;
    private int _location;
    private Element _element;
    private IAdaptable _customizationData;

    public PaletteDropInsertCommand(String label, StructuredTextEditor editor, IDropSourceData creationProvider, int location) {
        super(label, editor);
        this._creationProvider = creationProvider;
        this._location = location;
    }

    public void doExecute() {
        Node node;
        try {
            node = this.getSourceEditingTextTools().getNode(this._location);
        }
        catch (Exception e) {
            this._log.error("Bad text insertion location", (Throwable)e);
            return;
        }
        IDOMPosition position = null;
        position = node != null ? SourceViewerDragDropHelper.getInstance().findPosition(this._location, node) : (this.getModel().getDocument().getFirstChild() != null ? SourceViewerDragDropHelper.getInstance().findPosition(this.getModel().getDocument().getEndOffset(), this.getModel().getDocument().getFirstChild()) : new DOMPosition((Node)this.getModel().getDocument(), 0));
        IStatus status = this.performCustomization(this.getModel().getDocument(), position);
        if (status.isOK()) {
            Element element = CommandUtil.executeInsertion(this._creationProvider, this.getModel(), position, this.getCustomizationData());
            if (element != null) {
                this.formatNode(element);
            }
            this._element = element;
        }
    }

    protected IStatus performCustomization(IDOMDocument domDoc, IDOMPosition position) {
        return new DropCustomizationController(this, this._creationProvider, domDoc, position).performCustomization();
    }

    public void setCustomizationData(IAdaptable customizationData) {
        this._customizationData = customizationData;
    }

    protected final IAdaptable getCustomizationData() {
        return this._customizationData;
    }

    public void setSelection() {
        if (this._element != null) {
            int offset = EditModelQuery.getNodeStartIndex(this._element);
            int length = EditModelQuery.getNodeEndIndex(this._element) - offset;
            this._editor.getTextViewer().setSelectedRange(offset, length);
        }
    }
}

