/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.regression;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.core.tests.compiler.regression.AbstractRegressionTest;

public class BasicAnalyseTests
extends AbstractRegressionTest {
    public BasicAnalyseTests(String name) {
        super(name);
    }

    public void testBug251374_1() {
        HashMap<String, String> custom = new HashMap<String, String>();
        custom.put("org.eclipse.wst.jsdt.core.compiler.problem.nullReference", "error");
        custom.put("org.eclipse.wst.jsdt.core.compiler.problem.potentialNullReference", "error");
        this.runNegativeTest(new String[]{"X.js", "var b = null;\nfunction boo() {\nb.toString();\n}\nb = 2;\nboo();"}, "", null, false, custom);
    }

    public void testBug251374_2() {
        HashMap<String, String> custom = new HashMap<String, String>();
        custom.put("org.eclipse.wst.jsdt.core.compiler.problem.nullReference", "error");
        custom.put("org.eclipse.wst.jsdt.core.compiler.problem.potentialNullReference", "error");
        this.runNegativeTest(new String[]{"X.js", "var b = null;\nfunction boo() {\nb.toString();\n}\nboo();"}, "", null, false, custom);
    }

    public void testBug251374_3() {
        HashMap<String, String> custom = new HashMap<String, String>();
        custom.put("org.eclipse.wst.jsdt.core.compiler.problem.nullReference", "error");
        custom.put("org.eclipse.wst.jsdt.core.compiler.problem.potentialNullReference", "error");
        this.runNegativeTest(new String[]{"X.js", "var b = null;\nfunction boo() {\nb = null\nb.toString();\n}\nb = 2;\nboo();"}, "", null, false, custom);
    }

    public void testBug251374_4() {
        HashMap<String, String> custom = new HashMap<String, String>();
        custom.put("org.eclipse.wst.jsdt.core.compiler.problem.nullReference", "error");
        custom.put("org.eclipse.wst.jsdt.core.compiler.problem.potentialNullReference", "error");
        this.runNegativeTest(new String[]{"X.js", "var b = null;\nfunction boo() {\nb = null\nb.toString();\n}\nb = 2;\nboo();\nb.toString();"}, "", null, false, custom);
    }

    public void testBug251374_5() {
        this.runNegativeTest(new String[]{"X.js", "var b = null;\nfunction boo() {\nb = null\nb.toString();\n}\nb = 2;\nboo();\nb.toString();"}, "");
    }

    public void testBug286029_1() {
        this.runNegativeTest(new String[]{"X.js", "var sub;\nif(!sub) sub = {};"}, "");
    }

    public void testBug286029_2() {
        this.runNegativeTest(new String[]{"X.js", "function abc() {\nvar sub;\nif(!sub) sub = {};\n}"}, "----------\n1. WARNING in X.js (at line 3)\n\tif(!sub) sub = {};\n\t    ^^^\nThe local variable sub may not have been initialized\n----------\n");
    }

    public void testBug286029_3() {
        this.runNegativeTest(new String[]{"X.js", "function abc() {\nvar sub; sub = {};\nif(!sub) sub = {};\n}"}, "");
    }

    public void testBug251225_1() {
        this.runNegativeTest(new String[]{"X.js", "var temp = function () {};\ntemp();"}, "");
    }

    public void testBug251225_2() {
        this.runNegativeTest(new String[]{"X.js", "var temp = function () {};\nnew temp();"}, "");
    }

    public void testBug251225_3() {
        this.runNegativeTest(new String[]{"X.js", "function testFunction() {\nvar temp = function () {};\nfunction temp2(){}new temp2();}"}, "----------\n1. WARNING in X.js (at line 2)\n\tvar temp = function () {};\n\t    ^^^^\nThe local variable temp is never read\n----------\n");
    }

    public void testWI82701() {
        this.runNegativeTest(new String[]{"X.js", "function foo() {\nvar content = {};\nvar content1 = {};\nif(useLocation) {\ncontent.geocode = \"123,123\";\ndoSearch(content);\n} else {\ndoSearch(content);\n}\n}"}, "----------\n1. WARNING in X.js (at line 3)\n\tvar content1 = {};\n\t    ^^^^^^^^\nThe local variable content1 is never read\n----------\n");
    }

    public void testWI93475() {
        this.runNegativeTest(new String[]{"X.js", "function value() {this.val = 3;}\nthis.value = this.options[si != -1 ? si : 0].value;"}, "");
    }

    public void test001() {
        this.runNegativeTest(new String[]{"X.js", "function foo(arg) {\n\tswitch(arg) {\n\t\tcase 1:\n\t\t\tvar j = 1;\n\t\tcase 2:\n\t\t\tswitch(5) {\n\t\t\t\tcase j:\n\t\t\t}\n\t}\n}"}, "----------\n1. WARNING in X.js (at line 7)\n\tcase j:\n\t     ^\nThe local variable j may not have been initialized\n----------\n");
    }

    public void test002() {
        this.runNegativeTest(new String[]{"X.js", "function foo(arg) {\n\tif(false) {\n\t\tvar s;\n\t\tif(System.out != null) {\n\t\t\tSystem.out.doSomething(s);\n\t\t}\n\t}\n}"}, "----------\n1. WARNING in X.js (at line 5)\n\tSystem.out.doSomething(s);\n\t                       ^\nThe local variable s may not have been initialized\n----------\n");
    }

    public void test003() {
        this.runNegativeTest(new String[]{"X.js", "function foo(arg) {\n\tif(false) {\n\t\tvar s;\n\t\tSystem.out.doSomething(s);\n\t}\n}"}, "----------\n1. WARNING in X.js (at line 4)\n\tSystem.out.doSomething(s);\n\t                       ^\nThe local variable s may not have been initialized\n----------\n");
    }

    public void test004() {
        this.runNegativeTest(new String[]{"X.js", "function foo(arg) {\n\tswitch(1) {\n\t\tcase 0:\n\t\t\tvar j = 0;\n\t\tcase 1:\n\t\t\tSystem.out.doSomething(j);\n\t}\n}"}, "----------\n1. WARNING in X.js (at line 6)\n\tSystem.out.doSomething(j);\n\t                       ^\nThe local variable j may not have been initialized\n----------\n");
    }

    public void test005() {
        this.runNegativeTest(new String[]{"X.js", "function foo(arg) {\n    var s;\n    var o2 = arg;\n    if (o2 == null) {\n      s = \"\";\n    }\n    System.out.doSomething(s);\n}"}, "----------\n1. WARNING in X.js (at line 7)\n\tSystem.out.doSomething(s);\n\t                       ^\nThe local variable s may not have been initialized\n----------\n");
    }

    public void test006() {
        this.runNegativeTest(new String[]{"X.js", "function foo(b) {\n    var l;\n    do {\n   \tif (b) {\n      \t\tl = new Object();\n\t\t\tbreak;\n    \t}\n    } while (false);\n\tl.toString();\n}"}, "----------\n1. WARNING in X.js (at line 9)\n\tl.toString();\n\t^\nThe local variable l may not have been initialized\n----------\n");
    }

    public void test007() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.emptyStatement", "error");
        this.runNegativeTest(new String[]{"X.js", "function foo(args) {\n\tif(true)\n\t\t;\n\telse\n\t\t;\n}"}, "----------\n1. ERROR in X.js (at line 3)\n\t;\n\t^\nEmpty control-flow statement\n----------\n2. ERROR in X.js (at line 5)\n\t;\n\t^\nEmpty control-flow statement\n----------\n", null, true, options);
    }

    public void test008() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(new String[]{"X.js", "function foo(p, b) {\n\tswitch(p) {\n\t\tcase 0:\n\t\t\tif(b) {\n\t\t\t\tbreak;\n\t\t\t}\n\t\tcase 1:\n\t\t\tSystem.out.doSomething(j);\n\t}\n}"}, "----------\n1. ERROR in X.js (at line 7)\n\tcase 1:\n\t^^^^^^\nSwitch case may be entered by falling through previous case\n----------\n", null, true, options);
    }

    public void test009() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(new String[]{"X.js", "function foo(p, b) {\n\tswitch(p) {\n\t\tcase 0:\n\t\t\tSystem.exit();\n\t\tcase 1:\n\t\t\tSystem.out.doSomething(1);\n\t}\n}"}, "----------\n1. ERROR in X.js (at line 5)\n\tcase 1:\n\t^^^^^^\nSwitch case may be entered by falling through previous case\n----------\n", null, true, options);
    }

    public void test010() {
        Map options = this.getCompilerOptions();
        options.put("org.eclipse.wst.jsdt.core.compiler.problem.fallthroughCase", "error");
        this.runNegativeTest(new String[]{"X.js", "function foo(p) {\n\tswitch(p) {\n\t\tcase 0:\n\t\t\tSystem.exit(0);\n\t\tcase 1:\n\t\t\tSystem.out.doSomething(1);\n\t\t\tbreak;\n\t\tcase 2:\n\t\t\tSystem.out.doSomething(2);\n\t\t\treturn;\n\t\tcase 3:\n\t\tcase 4:\n\t\tdefault:\n\t\t\tSystem.out.println(3);\n\t}\n}"}, "----------\n1. ERROR in X.js (at line 5)\n\tcase 1:\n\t^^^^^^\nSwitch case may be entered by falling through previous case\n----------\n", null, true, options);
    }

    public void test011() {
        this.runNegativeTest(new String[]{"X.js", "function foo() {\n   var c1, c2;\n   do ; while((c1 = 0) == 1);\n\tif (c1 == 0) {} // silent\n\tif (c2 == 0) {} // complain\n}"}, "----------\n1. WARNING in X.js (at line 5)\n\tif (c2 == 0) {} // complain\n\t    ^^\nThe local variable c2 may not have been initialized\n----------\n");
    }

    public void test012() {
        this.runNegativeTest(new String[]{"X.js", "function foo() {\n   var c1, c2;\n   for(; (c1 = 0) == 1;);\n\tif (c1 == 0) {} // silent\n\tif (c2 == 0) {} // complain\n}"}, "----------\n1. WARNING in X.js (at line 5)\n\tif (c2 == 0) {} // complain\n\t    ^^\nThe local variable c2 may not have been initialized\n----------\n");
    }

    public void test013() {
        this.runNegativeTest(new String[]{"X.js", "function foo() {\n   var c1, c2;\n   while((c1 = 0) == 1);\n\tif (c1 == 0) {} // silent\n\tif (c2 == 0) {} // complain\n}"}, "----------\n1. WARNING in X.js (at line 5)\n\tif (c2 == 0) {} // complain\n\t    ^^\nThe local variable c2 may not have been initialized\n----------\n");
    }
}

