/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.tests.modelhandler;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.modelhandler.ModelHandlerRegistry;

public class ModelHandlerRegistryTest
extends TestCase {
    private static final String PROJECT = "ModelHandlerRegistryTest_";
    private static final String FILE = "test.MHRTfoo";

    IProject setUp(String name) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT + name);
        if (!project.isAccessible()) {
            project = ModelHandlerRegistryTest.createSimpleProject(project.getName());
        }
        return project;
    }

    void tearDown(String name) throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT + name);
        try {
            project.delete(true, true, null);
        }
        catch (Exception exception) {}
    }

    static IProject createSimpleProject(String name) {
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(name);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        try {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return project;
    }

    public void testGetHandler() throws Exception {
        IProject project = this.setUp(this.getName());
        IFile file = project.getFile(FILE);
        try {
            IModelHandler handler = ModelHandlerRegistry.getInstance().getHandlerFor(file);
            ModelHandlerRegistryTest.assertNotNull((String)"Model handler default should not be null.", (Object)handler);
            ModelHandlerRegistryTest.assertEquals((String)"Proper default model handler was not returned.", (String)handler.getId(), (String)"org.eclipse.wst.xml.core.modelhandler");
        }
        catch (CoreException e) {
            ModelHandlerRegistryTest.fail((String)("Caught exception: " + (Object)((Object)e)));
        }
        this.tearDown(this.getName());
    }

    public void testGetHandlerWithDefault() throws Exception {
        IProject project = this.setUp(this.getName());
        IFile file = project.getFile(FILE);
        try {
            IModelHandler handler = ModelHandlerRegistry.getInstance().getHandlerFor(file, true);
            ModelHandlerRegistryTest.assertNotNull((String)"Model handler default should not be null.", (Object)handler);
            ModelHandlerRegistryTest.assertEquals((String)"Proper default model handler was not returned.", (String)handler.getId(), (String)"org.eclipse.wst.xml.core.modelhandler");
        }
        catch (CoreException e) {
            ModelHandlerRegistryTest.fail((String)("Caught exception: " + (Object)((Object)e)));
        }
        this.tearDown(this.getName());
    }

    public void testGetHandlerWithoutDefault() throws Exception {
        IProject project = this.setUp(this.getName());
        IFile file = project.getFile(FILE);
        try {
            IModelHandler handler = ModelHandlerRegistry.getInstance().getHandlerFor(file, false);
            ModelHandlerRegistryTest.assertNull((String)"Model handler should not have returned a handler.", (Object)handler);
        }
        catch (CoreException e) {
            ModelHandlerRegistryTest.fail((String)("Caught exception: " + (Object)((Object)e)));
        }
        this.tearDown(this.getName());
    }
}

