/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.common.utility.closure.Closure;
import org.eclipse.jpt.common.utility.closure.InterruptibleClosure;
import org.eclipse.jpt.common.utility.exception.ExceptionHandler;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.closure.DisabledClosure;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.internal.collection.HashBag;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.enumeration.EnumerationTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.ArrayIterator;
import org.eclipse.jpt.common.utility.internal.iterator.ArrayListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.ChainIterator;
import org.eclipse.jpt.common.utility.internal.iterator.CloneIterator;
import org.eclipse.jpt.common.utility.internal.iterator.CloneListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.CompositeIterator;
import org.eclipse.jpt.common.utility.internal.iterator.CompositeListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.EmptyIterator;
import org.eclipse.jpt.common.utility.internal.iterator.EmptyListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.EnumerationIterator;
import org.eclipse.jpt.common.utility.internal.iterator.FilteringIterator;
import org.eclipse.jpt.common.utility.internal.iterator.GraphIterator;
import org.eclipse.jpt.common.utility.internal.iterator.LateralIteratorWrapper;
import org.eclipse.jpt.common.utility.internal.iterator.LateralListIteratorWrapper;
import org.eclipse.jpt.common.utility.internal.iterator.NullElementIterator;
import org.eclipse.jpt.common.utility.internal.iterator.NullElementListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.PeekableIterator;
import org.eclipse.jpt.common.utility.internal.iterator.QueueIterator;
import org.eclipse.jpt.common.utility.internal.iterator.ReadOnlyCompositeListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.ReadOnlyIterator;
import org.eclipse.jpt.common.utility.internal.iterator.ReadOnlyListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.RepeatingElementIterator;
import org.eclipse.jpt.common.utility.internal.iterator.RepeatingElementListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.ReverseIterator;
import org.eclipse.jpt.common.utility.internal.iterator.SimultaneousIterator;
import org.eclipse.jpt.common.utility.internal.iterator.SimultaneousListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.SingleElementIterator;
import org.eclipse.jpt.common.utility.internal.iterator.SingleElementListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.StackIterator;
import org.eclipse.jpt.common.utility.internal.iterator.SubIteratorWrapper;
import org.eclipse.jpt.common.utility.internal.iterator.SubListIteratorWrapper;
import org.eclipse.jpt.common.utility.internal.iterator.SuperIteratorWrapper;
import org.eclipse.jpt.common.utility.internal.iterator.SuperListIteratorWrapper;
import org.eclipse.jpt.common.utility.internal.iterator.SynchronizedIterator;
import org.eclipse.jpt.common.utility.internal.iterator.SynchronizedListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.TransformationIterator;
import org.eclipse.jpt.common.utility.internal.iterator.TransformationListIterator;
import org.eclipse.jpt.common.utility.internal.iterator.TreeIterator;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.queue.Queue;
import org.eclipse.jpt.common.utility.stack.Stack;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public final class IteratorTools {
    public static <E> HashBag<E> bag(Iterator<? extends E> iterator) {
        return CollectionTools.hashBag(iterator);
    }

    public static <E> HashBag<E> bag(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.hashBag(iterator, iteratorSize);
    }

    public static <E> HashBag<E> hashBag(Iterator<? extends E> iterator) {
        return CollectionTools.hashBag(iterator);
    }

    public static <E> HashBag<E> hashBag(Iterator<? extends E> iterator, int iteratorSize) {
        return CollectionTools.hashBag(iterator, iteratorSize);
    }

    public static boolean containsNull(Iterator<?> iterator) {
        return IteratorTools.contains(iterator, null);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean contains(Iterator<?> iterator, Object value) {
        block2: {
            if (value != null) ** GOTO lbl8
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!value.equals(iterator.next())) continue;
                return true;
lbl8:
                // 2 sources

                ** while (iterator.hasNext())
            }
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static int count(Iterator<?> iterator, Object value) {
        block2: {
            count = 0;
            if (value != null) ** GOTO lbl10
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                ++count;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                if (!value.equals(iterator.next())) continue;
                ++count;
lbl10:
                // 3 sources

                ** while (iterator.hasNext())
            }
        }
        return count;
    }

    public static <E> int countFalse(Iterator<? extends E> iterator, Predicate<? super E> predicate) {
        int count = 0;
        while (iterator.hasNext()) {
            if (predicate.evaluate(iterator.next())) continue;
            ++count;
        }
        return count;
    }

    public static <E> int countTrue(Iterator<? extends E> iterator, Predicate<? super E> predicate) {
        int count = 0;
        while (iterator.hasNext()) {
            if (!predicate.evaluate(iterator.next())) continue;
            ++count;
        }
        return count;
    }

    public static boolean containsAll(Iterator<?> iterator, Collection<?> collection) {
        return collection.isEmpty() || CollectionTools.hashSet(iterator).containsAll(collection);
    }

    public static boolean containsAll(Iterator<?> iterator, int iteratorSize, Collection<?> collection) {
        return collection.isEmpty() || CollectionTools.hashSet(iterator, iteratorSize).containsAll(collection);
    }

    public static boolean containsAll(Iterator<?> iterator, Iterable<?> iterable) {
        return IteratorTools.containsAll(iterator, iterable.iterator());
    }

    public static boolean containsAll(Iterator<?> iterator, int iteratorSize, Iterable<?> iterable) {
        return IteratorTools.containsAll(iterator, iteratorSize, iterable.iterator());
    }

    public static boolean containsAll(Iterator<?> iterator1, Iterator<?> iterator2) {
        return IteratorTools.isEmpty(iterator2) || CollectionTools.containsAll(CollectionTools.hashSet(iterator1), iterator2);
    }

    public static boolean containsAll(Iterator<?> iterator1, int iterator1Size, Iterator<?> iterator2) {
        return IteratorTools.isEmpty(iterator2) || CollectionTools.containsAll(CollectionTools.hashSet(iterator1, iterator1Size), iterator2);
    }

    public static boolean containsAll(Iterator<?> iterator, Object ... array) {
        return array.length == 0 || CollectionTools.containsAll(CollectionTools.hashSet(iterator), array);
    }

    public static boolean containsAll(Iterator<?> iterator, int iteratorSize, Object ... array) {
        return array.length == 0 || CollectionTools.containsAll(CollectionTools.hashSet(iterator, iteratorSize), array);
    }

    public static boolean elementsAreDifferent(Iterator<?> iterator1, Iterator<?> iterator2) {
        return !IteratorTools.elementsAreEqual(iterator1, iterator2);
    }

    public static boolean elementsAreEqual(Iterator<?> iterator1, Iterator<?> iterator2) {
        while (iterator1.hasNext() && iterator2.hasNext()) {
            if (!ObjectTools.notEquals(iterator1.next(), iterator2.next())) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static boolean elementsAreIdentical(Iterator<?> iterator1, Iterator<?> iterator2) {
        while (iterator1.hasNext() && iterator2.hasNext()) {
            if (iterator1.next() == iterator2.next()) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static boolean elementsAreNotIdentical(Iterator<?> iterator1, Iterator<?> iterator2) {
        return !IteratorTools.elementsAreIdentical(iterator1, iterator2);
    }

    public static <E> void execute(Iterator<? extends E> iterator, Closure<E> closure) {
        while (iterator.hasNext()) {
            closure.execute(iterator.next());
        }
    }

    public static <E> void execute(Iterator<? extends E> iterator, Closure<E> closure, ExceptionHandler exceptionHandler) {
        while (iterator.hasNext()) {
            try {
                closure.execute(iterator.next());
            }
            catch (Throwable ex) {
                exceptionHandler.handleException(ex);
            }
        }
    }

    public static <E> void execute(Iterator<? extends E> iterator, InterruptibleClosure<E> closure) throws InterruptedException {
        while (iterator.hasNext()) {
            closure.execute(iterator.next());
        }
    }

    public static <E> void execute(Iterator<? extends E> iterator, InterruptibleClosure<E> closure, ExceptionHandler exceptionHandler) throws InterruptedException {
        while (iterator.hasNext()) {
            try {
                closure.execute(iterator.next());
            }
            catch (InterruptedException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                exceptionHandler.handleException(ex);
            }
        }
    }

    public static <E> E get(Iterator<? extends E> iterator, int index) {
        int i = 0;
        while (iterator.hasNext()) {
            E next = iterator.next();
            if (i == index) {
                return next;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException(String.valueOf(String.valueOf(index)) + ':' + String.valueOf(i));
    }

    public static int hashCode(Iterator<?> iterator) {
        int hash = 1;
        while (iterator.hasNext()) {
            Object next = iterator.next();
            hash = 31 * hash + (next == null ? 0 : next.hashCode());
        }
        return hash;
    }

    public static int indexOf(Iterator<?> iterator, Object value) {
        return iterator.hasNext() ? IteratorTools.indexOf_(iterator, value, 0) : -1;
    }

    public static int indexOf(Iterator<?> iterator, Object value, int startIndex) {
        if (startIndex < 0) {
            startIndex = 0;
        } else {
            int i = 0;
            while (iterator.hasNext() && i < startIndex) {
                iterator.next();
                ++i;
            }
        }
        return iterator.hasNext() ? IteratorTools.indexOf_(iterator, value, startIndex) : -1;
    }

    private static int indexOf_(Iterator<?> iterator, Object value, int startIndex) {
        if (value == null) {
            int i = startIndex;
            while (iterator.hasNext()) {
                if (iterator.next() == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = startIndex;
            while (iterator.hasNext()) {
                if (value.equals(iterator.next())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(Iterator<?> iterator, Object value) {
        int last = -1;
        if (value == null) {
            int i = 0;
            while (iterator.hasNext()) {
                if (iterator.next() == null) {
                    last = i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (iterator.hasNext()) {
                if (value.equals(iterator.next())) {
                    last = i;
                }
                ++i;
            }
        }
        return last;
    }

    public static int lastIndexOf(Iterator<?> iterator, Object value, int startIndex) {
        if (startIndex < 0) {
            return -1;
        }
        return iterator.hasNext() ? IteratorTools.lastIndexOf_(iterator, value, startIndex) : -1;
    }

    private static int lastIndexOf_(Iterator<?> iterator, Object value, int startIndex) {
        int last = -1;
        if (value == null) {
            int i = 0;
            while (iterator.hasNext()) {
                if (i > startIndex) {
                    return last;
                }
                if (iterator.next() == null) {
                    last = i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (iterator.hasNext()) {
                if (i > startIndex) {
                    return last;
                }
                if (value.equals(iterator.next())) {
                    last = i;
                }
                ++i;
            }
        }
        return last;
    }

    public static <E> E first(Iterator<E> iterator) {
        return iterator.next();
    }

    public static <E> E last(Iterator<E> iterator) {
        E last;
        do {
            last = iterator.next();
        } while (iterator.hasNext());
        return last;
    }

    public static <E> ArrayList<E> list(Iterator<? extends E> iterator) {
        return ListTools.arrayList(iterator);
    }

    public static <E> ArrayList<E> list(Iterator<? extends E> iterator, int iteratorSize) {
        return ListTools.arrayList(iterator, iteratorSize);
    }

    public static int size(Iterator<?> iterator) {
        int size = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        return !iterator.hasNext();
    }

    public static boolean isNotEmpty(Iterator<?> iterator) {
        return iterator.hasNext();
    }

    public static <E extends Comparable<? super E>> ListIterator<E> sort(Iterator<? extends E> iterator) {
        return IteratorTools.sort(iterator, null);
    }

    public static <E extends Comparable<? super E>> ListIterator<E> sort(Iterator<? extends E> iterator, int iteratorSize) {
        return IteratorTools.sort(iterator, null, iteratorSize);
    }

    public static <E2, E1 extends E2> ListIterator<E2> sort(Iterator<E1> iterator, Comparator<? super E1> comparator) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.emptyListIterator();
        }
        return ListTools.sort(ListTools.arrayList(iterator), comparator).listIterator();
    }

    public static <E2, E1 extends E2> ListIterator<E2> sort(Iterator<E1> iterator, Comparator<? super E1> comparator, int iteratorSize) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.emptyListIterator();
        }
        return ListTools.sort(ListTools.arrayList(iterator, iteratorSize), comparator).listIterator();
    }

    public static Object[] toArray(Iterator<?> iterator) {
        return IteratorTools.isEmpty(iterator) ? ObjectTools.EMPTY_OBJECT_ARRAY : IteratorTools.list(iterator).toArray();
    }

    public static Object[] toArray(Iterator<?> iterator, int iteratorSize) {
        return IteratorTools.isEmpty(iterator) ? ObjectTools.EMPTY_OBJECT_ARRAY : IteratorTools.list(iterator, iteratorSize).toArray();
    }

    public static <E> E[] toArray(Iterator<? extends E> iterator, E[] array) {
        return IteratorTools.isEmpty(iterator) ? ArrayTools.newInstance(array, 0) : IteratorTools.list(iterator).toArray(array);
    }

    public static <E> E[] toArray(Iterator<? extends E> iterator, int iteratorSize, E[] array) {
        return IteratorTools.isEmpty(iterator) ? ArrayTools.newInstance(array, 0) : IteratorTools.list(iterator, iteratorSize).toArray(array);
    }

    @SafeVarargs
    public static <E, I extends Iterator<? extends E>> Iterator<List<E>> align(I ... iterators) {
        int len = iterators.length;
        if (len == 0) {
            return IteratorTools.emptyIterator();
        }
        return IteratorTools.align(IterableTools.iterable(iterators), len);
    }

    public static <E, I extends Iterator<? extends E>> Iterator<List<E>> align(Iterable<I> iterables) {
        return IteratorTools.align(iterables, -1);
    }

    public static <E, I extends Iterator<? extends E>> Iterator<List<E>> align(Iterable<I> iterables, int iterablesSize) {
        return new SimultaneousIterator(iterables, iterablesSize);
    }

    @SafeVarargs
    public static <E, I extends ListIterator<E>> ListIterator<List<E>> alignList(I ... iterators) {
        int len = iterators.length;
        if (len == 0) {
            return IteratorTools.emptyListIterator();
        }
        return IteratorTools.alignList(IterableTools.listIterable(iterators), len);
    }

    public static <E, I extends ListIterator<E>> ListIterator<List<E>> alignList(Iterable<I> iterables) {
        return IteratorTools.alignList(iterables, -1);
    }

    public static <E, I extends ListIterator<E>> ListIterator<List<E>> alignList(Iterable<I> iterators, int iteratorsSize) {
        return new SimultaneousListIterator(iterators, iteratorsSize);
    }

    public static <E1, E2> Iterator<E2> cast(Iterator<E1> iterator) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.emptyIterator();
        }
        return new LateralIteratorWrapper(iterator);
    }

    public static <E1, E2> ListIterator<E2> cast(ListIterator<E1> iterator) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.emptyListIterator();
        }
        return new LateralListIteratorWrapper(iterator);
    }

    public static <E1, E2 extends E1> Iterator<E2> downCast(Iterator<E1> iterator) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.emptyIterator();
        }
        return new SubIteratorWrapper(iterator);
    }

    public static <E1, E2 extends E1> ListIterator<E2> downCast(ListIterator<E1> iterator) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.emptyListIterator();
        }
        return new SubListIteratorWrapper(iterator);
    }

    public static <E> Iterator<E> upCast(Iterator<? extends E> iterator) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.emptyIterator();
        }
        return new SuperIteratorWrapper<E>(iterator);
    }

    public static <E> ListIterator<E> upCast(ListIterator<? extends E> iterator) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.emptyListIterator();
        }
        return new SuperListIteratorWrapper<E>(iterator);
    }

    public static <E> Iterator<E> chainIterator(E first, Transformer<? super E, ? extends E> transformer) {
        if (first == null) {
            return IteratorTools.emptyIterator();
        }
        return new ChainIterator<E>(first, transformer);
    }

    public static <E> Iterator<E> clone(Collection<? extends E> collection) {
        return IteratorTools.clone(collection, DisabledClosure.instance());
    }

    public static <E> Iterator<E> clone(Collection<? extends E> collection, Closure<? super E> removeClosure) {
        if (collection.isEmpty()) {
            return IteratorTools.emptyIterator();
        }
        return new CloneIterator<E>(collection, removeClosure);
    }

    public static <E> ListIterator<E> clone(List<? extends E> list) {
        return IteratorTools.clone(list, CloneListIterator.Adapter.ReadOnly.instance());
    }

    public static <E> ListIterator<E> clone(List<? extends E> list, CloneListIterator.Adapter<E> adapter) {
        if (list.isEmpty()) {
            return IteratorTools.emptyListIterator();
        }
        return new CloneListIterator<E>(list, adapter);
    }

    public static <E> Iterator<E> add(Iterator<? extends E> iterator, E object) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.singletonIterator(object);
        }
        return IteratorTools.concatenate_(iterator, IteratorTools.singletonIterator(object));
    }

    public static <E> Iterator<E> insert(E object, Iterator<? extends E> iterator) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.singletonIterator(object);
        }
        return IteratorTools.concatenate_(IteratorTools.singletonIterator(object), iterator);
    }

    public static <E> Iterator<E> concatenate(Iterator<? extends E> ... iterators) {
        int len = iterators.length;
        if (len == 0) {
            return IteratorTools.emptyIterator();
        }
        if (len == 1) {
            return iterators[0];
        }
        return IteratorTools.concatenate_(iterators);
    }

    @SafeVarargs
    private static <E> Iterator<E> concatenate_(Iterator<? extends E> ... iterators) {
        return IteratorTools.concatenate_(IteratorTools.iterator(iterators));
    }

    public static <E> Iterator<E> concatenate(Iterator<? extends Iterator<? extends E>> iterators) {
        if (IteratorTools.isEmpty(iterators)) {
            return IteratorTools.emptyListIterator();
        }
        return IteratorTools.concatenate_(iterators);
    }

    private static <E> Iterator<E> concatenate_(Iterator<? extends Iterator<? extends E>> iterators) {
        return new CompositeIterator(iterators);
    }

    public static <P, E> Iterator<E> children(Iterator<? extends P> parents, Transformer<? super P, ? extends Iterator<? extends E>> childrenTransformer) {
        return IteratorTools.concatenate(IteratorTools.transform(parents, childrenTransformer));
    }

    public static <E> ListIterator<E> add(ListIterator<E> iterator, E object) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.singletonListIterator(object);
        }
        return IteratorTools.concatenate_(iterator, IteratorTools.singletonListIterator(object));
    }

    public static <E> ListIterator<E> insert(E object, ListIterator<E> iterator) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.singletonListIterator(object);
        }
        return IteratorTools.concatenate_(IteratorTools.singletonListIterator(object), iterator);
    }

    @SafeVarargs
    public static <E> ListIterator<E> concatenate(ListIterator<E> ... iterators) {
        int len = iterators.length;
        if (len == 0) {
            return IteratorTools.emptyListIterator();
        }
        if (len == 1) {
            return iterators[0];
        }
        return IteratorTools.concatenate_(iterators);
    }

    @SafeVarargs
    private static <E> ListIterator<E> concatenate_(ListIterator<E> ... iterators) {
        return IteratorTools.concatenate_(IteratorTools.listIterator(iterators));
    }

    public static <E> ListIterator<E> concatenate(ListIterator<? extends ListIterator<E>> iterators) {
        if (IteratorTools.isEmpty(iterators)) {
            return IteratorTools.emptyListIterator();
        }
        return IteratorTools.concatenate_(iterators);
    }

    private static <E> ListIterator<E> concatenate_(ListIterator<? extends ListIterator<E>> iterators) {
        return new CompositeListIterator(iterators);
    }

    public static <P, E> ListIterator<E> children(ListIterator<? extends P> parents, Transformer<? super P, ? extends ListIterator<E>> childrenTransformer) {
        return IteratorTools.concatenate(IteratorTools.transform(parents, childrenTransformer));
    }

    public static <E> ListIterator<E> addReadOnly(ListIterator<? extends E> iterator, E object) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.singletonListIterator(object);
        }
        return IteratorTools.concatenateReadOnly_(iterator, IteratorTools.singletonListIterator(object));
    }

    public static <E> ListIterator<E> insertReadOnly(E object, ListIterator<? extends E> iterator) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.singletonListIterator(object);
        }
        return IteratorTools.concatenateReadOnly_(IteratorTools.singletonListIterator(object), iterator);
    }

    public static <E> ListIterator<E> concatenateReadOnly(ListIterator<? extends E> ... iterators) {
        int len = iterators.length;
        if (len == 0) {
            return IteratorTools.emptyListIterator();
        }
        if (len == 1) {
            return iterators[0];
        }
        return IteratorTools.concatenateReadOnly_(iterators);
    }

    @SafeVarargs
    private static <E> ListIterator<E> concatenateReadOnly_(ListIterator<? extends E> ... iterators) {
        return IteratorTools.concatenateReadOnly_(IteratorTools.listIterator(iterators));
    }

    public static <E> ListIterator<E> concatenateReadOnly(ListIterator<? extends ListIterator<? extends E>> iterators) {
        if (IteratorTools.isEmpty(iterators)) {
            return IteratorTools.emptyListIterator();
        }
        return IteratorTools.concatenateReadOnly_(iterators);
    }

    private static <E> ListIterator<E> concatenateReadOnly_(ListIterator<? extends ListIterator<? extends E>> iterators) {
        return new ReadOnlyCompositeListIterator(iterators);
    }

    public static <P, E> ListIterator<E> readOnlyChildren(ListIterator<? extends P> parents, Transformer<? super P, ? extends ListIterator<? extends E>> childrenTransformer) {
        return IteratorTools.concatenateReadOnly(IteratorTools.transform(parents, childrenTransformer));
    }

    public static <E> Iterator<E> emptyIterator() {
        return EmptyIterator.instance();
    }

    public static <E> ListIterator<E> emptyListIterator() {
        return EmptyListIterator.instance();
    }

    public static <E> Iterator<E> filter(Iterator<? extends E> iterator, Predicate<? super E> predicate) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.emptyIterator();
        }
        return new FilteringIterator<E>(iterator, predicate);
    }

    public static <E> Iterator<E> removeNulls(Iterator<? extends E> iterator) {
        return IteratorTools.filter(iterator, PredicateTools.isNotNull());
    }

    public static <E> Iterator<E> graphIterator(E root, Transformer<? super E, ? extends Iterator<? extends E>> transformer) {
        return IteratorTools.graphIterator_(IteratorTools.singletonIterator(root), transformer);
    }

    public static <E> Iterator<E> graphIterator(E[] roots, Transformer<? super E, ? extends Iterator<? extends E>> transformer) {
        if (roots.length == 0) {
            return IteratorTools.emptyIterator();
        }
        return IteratorTools.graphIterator_(IteratorTools.iterator(roots), transformer);
    }

    public static <E> Iterator<E> graphIterator(Iterator<? extends E> roots, Transformer<? super E, ? extends Iterator<? extends E>> transformer) {
        if (IteratorTools.isEmpty(roots)) {
            return IteratorTools.emptyIterator();
        }
        return IteratorTools.graphIterator_(roots, transformer);
    }

    private static <E> Iterator<E> graphIterator_(Iterator<? extends E> roots, Transformer<? super E, ? extends Iterator<? extends E>> transformer) {
        return new GraphIterator<E>(roots, transformer);
    }

    public static <E> Iterator<E> iterator(Enumeration<E> enumeration) {
        if (EnumerationTools.isEmpty(enumeration)) {
            return IteratorTools.emptyIterator();
        }
        return new EnumerationIterator<E>(enumeration);
    }

    @SafeVarargs
    public static <E> Iterator<E> iterator(E ... array) {
        return IteratorTools.iterator(array, 0);
    }

    public static <E> Iterator<E> iterator(E[] array, int start) {
        return IteratorTools.iterator(array, start, array.length);
    }

    public static <E> Iterator<E> iterator(E[] array, int start, int end) {
        if (start == end) {
            return IteratorTools.emptyIterator();
        }
        return new ArrayIterator<E>(array, start, end);
    }

    public static <E> Iterator<E> iterator(Queue<? extends E> queue) {
        return new QueueIterator<E>(queue);
    }

    public static <E> Iterator<E> iterator(Stack<? extends E> stack) {
        return new StackIterator<E>(stack);
    }

    @SafeVarargs
    public static <E> ListIterator<E> listIterator(E ... array) {
        return IteratorTools.listIterator(array, 0);
    }

    public static <E> ListIterator<E> listIterator(E[] array, int start) {
        return IteratorTools.listIterator(array, start, array.length);
    }

    public static <E> ListIterator<E> listIterator(E[] array, int start, int end) {
        if (start == end) {
            return IteratorTools.emptyListIterator();
        }
        return new ArrayListIterator<E>(array, start, end);
    }

    public static <E> Iterator<E> nullElementIterator(int size) {
        if (size == 0) {
            return IteratorTools.emptyIterator();
        }
        return new NullElementIterator(size);
    }

    public static <E> ListIterator<E> nullElementListIterator(int size) {
        if (size == 0) {
            return IteratorTools.emptyListIterator();
        }
        return new NullElementListIterator(size);
    }

    public static <E> PeekableIterator<E> peekable(Iterator<? extends E> iterator) {
        return new PeekableIterator<E>(iterator);
    }

    public static <E> Iterator<E> readOnly(Iterator<? extends E> iterator) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.emptyIterator();
        }
        return new ReadOnlyIterator<E>(iterator);
    }

    public static <E> ListIterator<E> readOnly(ListIterator<? extends E> iterator) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.emptyListIterator();
        }
        return new ReadOnlyListIterator<E>(iterator);
    }

    public static <E> Iterator<E> repeatingElementIterator(E element, int size) {
        if (size == 0) {
            return IteratorTools.emptyIterator();
        }
        return new RepeatingElementIterator<E>(element, size);
    }

    public static <E> ListIterator<E> repeatingElementListIterator(E element, int size) {
        if (size == 0) {
            return IteratorTools.emptyListIterator();
        }
        return new RepeatingElementListIterator<E>(element, size);
    }

    public static <E> Iterator<E> reverse(Iterator<? extends E> iterator) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.emptyIterator();
        }
        return new ReverseIterator<E>(iterator);
    }

    public static <E> Iterator<E> reverse(Iterator<? extends E> iterator, int iteratorSize) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.emptyIterator();
        }
        return new ReverseIterator<E>(iterator, iteratorSize);
    }

    public static <E> Iterator<E> singletonIterator(E value) {
        return new SingleElementIterator<E>(value);
    }

    public static <E> ListIterator<E> singletonListIterator(E value) {
        return new SingleElementListIterator<E>(value);
    }

    public static <E> Iterator<E> synchronize(Iterator<? extends E> iterator) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.emptyIterator();
        }
        return new SynchronizedIterator<E>(iterator);
    }

    public static <E> Iterator<E> synchronize(Iterator<? extends E> iterator, Object mutex) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.emptyIterator();
        }
        return new SynchronizedIterator<E>(iterator, mutex);
    }

    public static <E> ListIterator<E> synchronize(ListIterator<E> iterator) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.emptyListIterator();
        }
        return new SynchronizedListIterator<E>(iterator);
    }

    public static <E> ListIterator<E> synchronize(ListIterator<E> iterator, Object mutex) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.emptyListIterator();
        }
        return new SynchronizedListIterator<E>(iterator, mutex);
    }

    public static <E1, E2> Iterator<E2> transform(Iterator<? extends E1> iterator, Transformer<? super E1, ? extends E2> transformer) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.emptyIterator();
        }
        return new TransformationIterator<E1, E2>(iterator, transformer);
    }

    public static <E1, E2> ListIterator<E2> transform(ListIterator<? extends E1> iterator, Transformer<? super E1, ? extends E2> transformer) {
        if (IteratorTools.isEmpty(iterator)) {
            return IteratorTools.emptyListIterator();
        }
        return new TransformationListIterator<E1, E2>(iterator, transformer);
    }

    public static <E> Iterator<E> treeIterator(E root, Transformer<? super E, ? extends Iterator<? extends E>> transformer) {
        return IteratorTools.treeIterator_(IteratorTools.singletonIterator(root), transformer);
    }

    public static <E> Iterator<E> treeIterator(E[] roots, Transformer<? super E, ? extends Iterator<? extends E>> transformer) {
        if (roots.length == 0) {
            return IteratorTools.emptyIterator();
        }
        return IteratorTools.treeIterator_(IteratorTools.iterator(roots), transformer);
    }

    public static <E> Iterator<E> treeIterator(Iterator<? extends E> roots, Transformer<? super E, ? extends Iterator<? extends E>> transformer) {
        if (IteratorTools.isEmpty(roots)) {
            return IteratorTools.emptyIterator();
        }
        return IteratorTools.treeIterator_(roots, transformer);
    }

    private static <E> Iterator<E> treeIterator_(Iterator<? extends E> roots, Transformer<? super E, ? extends Iterator<? extends E>> transformer) {
        return new TreeIterator<E>(roots, transformer);
    }

    public static String toString(Iterator<?> iterator) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (iterator.hasNext()) {
            sb.append(iterator.next());
        }
        sb.append(']');
        return sb.toString();
    }

    private IteratorTools() {
        throw new UnsupportedOperationException();
    }
}

